/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ide.util.JavaEclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractJavaAnalysisAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private ISelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public static AnalysisScope computeScope(IStructuredSelection selection) throws IOException {
        return AbstractJavaAnalysisAction.computeScope(selection, EclipseProjectPath.AnalysisScopeType.NO_SOURCE);
    }

    public static AnalysisScope computeScope(final IStructuredSelection selection, final EclipseProjectPath.AnalysisScopeType scopeType) throws IOException {
        LinkedList<EclipseProjectPath> projectPaths;
        block6: {
            if (selection == null) {
                throw new IllegalArgumentException("null selection");
            }
            projectPaths = new LinkedList<EclipseProjectPath>();
            Job job = new Job("Compute project paths"){

                protected IStatus run(IProgressMonitor monitor) {
                    for (Object object : selection) {
                        if (object instanceof IJavaElement) {
                            IJavaElement e = (IJavaElement)object;
                            IJavaProject jp = e.getJavaProject();
                            try {
                                projectPaths.add(JavaEclipseProjectPath.make(jp, scopeType));
                                continue;
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                                continue;
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                                return new Status(4, "", 0, "", (Throwable)e2);
                            }
                        }
                        Assertions.UNREACHABLE(object.getClass());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
            try {
                job.join();
                IStatus result = job.getResult();
                if (result.getSeverity() == 4) {
                    Throwable exception = result.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        AnalysisScope scope = AbstractJavaAnalysisAction.mergeProjectPaths(projectPaths);
        return scope;
    }

    protected Collection<IJavaProject> computeJavaProjects() {
        IStructuredSelection selection = (IStructuredSelection)this.currentSelection;
        HashSet projects = HashSetFactory.make();
        for (Object object : selection) {
            if (object instanceof IJavaElement) {
                IJavaElement e = (IJavaElement)object;
                IJavaProject jp = e.getJavaProject();
                projects.add(jp);
                continue;
            }
            Assertions.UNREACHABLE(object.getClass());
        }
        return projects;
    }

    private static AnalysisScope mergeProjectPaths(Collection<EclipseProjectPath> projectPaths) throws IOException {
        AnalysisScope scope = AnalysisScope.createJavaAnalysisScope();
        HashSet seen = HashSetFactory.make();
        AbstractJavaAnalysisAction.buildScope(ClassLoaderReference.Application, projectPaths, scope, seen);
        AbstractJavaAnalysisAction.buildScope(ClassLoaderReference.Extension, projectPaths, scope, seen);
        AbstractJavaAnalysisAction.buildScope(ClassLoaderReference.Primordial, projectPaths, scope, seen);
        return scope;
    }

    private static void buildScope(ClassLoaderReference loader, Collection<EclipseProjectPath> projectPaths, AnalysisScope scope, Collection<Module> seen) throws IOException {
        for (EclipseProjectPath path : projectPaths) {
            AnalysisScope pScope = path.toAnalysisScope(null);
            for (Module m : pScope.getModules(loader)) {
                if (seen.contains(m)) continue;
                seen.add(m);
                scope.addToScope(loader, m);
            }
        }
    }

    public void run(IAction action) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile((IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    public ISelection getCurrentSelection() {
        return this.currentSelection;
    }
}

