/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.unique;

import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.unique.UniqueFactoid;
import com.ibm.safe.typestate.unique.UniqueTypeStateDomain;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.VectorKillFlowFunction;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Iterator;

public class UniqueReturnFlowFunction
implements IReversibleFlowFunction {
    private final VectorKillFlowFunction delegate;

    public UniqueReturnFlowFunction(UniqueTypeStateDomain d, OrdinalSet<InstanceKey> trackedInstances, final ILiveObjectAnalysis liveAnalysis, final CGNode caller, final HeapGraph hg, final CallSiteReference site, final IR ir) {
        Predicate shouldKill = new Predicate(){

            public boolean test(Object o) {
                if (o instanceof UniqueFactoid) {
                    UniqueFactoid f = (UniqueFactoid)o;
                    InstanceKey ik = f.instance;
                    if (ik instanceof AllocationSiteInNode) {
                        AllocationSiteInNode ak = (AllocationSiteInNode)ik;
                        if (!liveAnalysis.mayBeLive((InstanceKey)ak, caller, ir.getCallInstructionIndices(site))) {
                            return true;
                        }
                        return !f.isUnique() && UniqueReturnFlowFunction.mustBeUniqueInNode(ak, caller, hg, liveAnalysis);
                    }
                    return false;
                }
                if (!$assertionsDisabled && o instanceof BaseFactoid) {
                    throw new AssertionError();
                }
                return false;
            }
        };
        MutableSparseIntSet kill = MutableSparseIntSet.makeEmpty();
        FilterIterator it = new FilterIterator(d.iterator(), shouldKill);
        while (it.hasNext()) {
            BaseFactoid f = (BaseFactoid)it.next();
            kill.add(d.add(f));
        }
        this.delegate = VectorKillFlowFunction.make((IntSet)kill);
    }

    public static boolean mustBeUniqueInNode(AllocationSiteInNode ik, CGNode node, HeapGraph hg, ILiveObjectAnalysis live) {
        boolean foundFirstLocal = false;
        Iterator it = hg.getPredNodes((Object)ik);
        while (it.hasNext()) {
            PointerKey p = (PointerKey)it.next();
            if (!(p instanceof LocalPointerKey)) {
                return false;
            }
            LocalPointerKey lpk = (LocalPointerKey)p;
            if (!lpk.getNode().equals(node)) continue;
            if (foundFirstLocal) {
                return false;
            }
            foundFirstLocal = true;
            if (!lpk.isParameter()) continue;
            return false;
        }
        return true;
    }

    public IntSet getSources(int d2) {
        return this.delegate.getSources(d2);
    }

    public IntSet getTargets(int d1) {
        return this.delegate.getTargets(d1);
    }
}

