/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.unique;

import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.base.BaseCallFlowFunction;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.unique.UniqueFactoid;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.intset.OrdinalSet;

public class UniqueCallFlowFunction
extends BaseCallFlowFunction {
    private boolean uniqueMayTarget;

    public UniqueCallFlowFunction(TypeStateDomain domain, ITypeStateDFA dfa, OrdinalSet<InstanceKey> instances, IEvent event, BasicBlockInContext<IExplodedBasicBlock> block, SSAInvokeInstruction invokeInstr, CGNode caller, CGNode callee, PointerAnalysis pointerAnalysis, IClassHierarchy cha) {
        super(domain, dfa, instances, event, block, invokeInstr, caller);
        if (invokeInstr.getCallSite().isStatic()) {
            this.uniqueMayTarget = false;
        } else {
            HeapModel hm = pointerAnalysis.getHeapModel();
            OrdinalSet pointsTo = pointerAnalysis.getPointsToSet(hm.getPointerKeyForLocal(caller, invokeInstr.getReceiver()));
            this.uniqueMayTarget = UniqueCallFlowFunction.existsUniqueReceiver((OrdinalSet<InstanceKey>)pointsTo, callee, cha);
        }
    }

    public static boolean existsUniqueReceiver(OrdinalSet<InstanceKey> pointsTo, CGNode callee, IClassHierarchy cha) {
        boolean foundOne = false;
        for (InstanceKey ik : pointsTo) {
            IClass type = ik.getConcreteType();
            IMethod target = cha.resolveMethod(type, callee.getMethod().getSelector());
            if (!target.getReference().equals((Object)callee.getMethod().getReference())) continue;
            if (foundOne) {
                return false;
            }
            foundOne = true;
        }
        return true;
    }

    @Override
    protected boolean strongUpdate(BaseFactoid inputFact) {
        UniqueFactoid triplet = (UniqueFactoid)inputFact;
        return this.uniqueMayTarget && triplet.isUnique();
    }
}

