/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.staged;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.MaxFindingsException;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.exceptions.SolverTimeoutException;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.typestate.controller.TypeStateSolverKind;
import com.ibm.safe.typestate.core.AbstractTypestateSolver;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateProblem;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.TypestateSolverFactory;
import com.ibm.safe.typestate.core.WholeProgramSupergraph;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.InstanceBatchIterator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.Iterator2Collection;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class StagedSolver
extends AbstractTypestateSolver {
    static final TypeStateSolverKind[] stageKinds = new TypeStateSolverKind[]{TypeStateSolverKind.LOCAL_MUST_MUSTNOT, TypeStateSolverKind.UNIQUE, TypeStateSolverKind.AP_MUST_MUSTNOT};
    private ISolverResult[] stageResults = new ISolverResult[stageKinds.length];
    private final AnalysisOptions domoOptions;
    private final PerformanceTracker perfTracker;

    public StagedSolver(AnalysisOptions domoOptions, CallGraph cg, PointerAnalysis pointerAnalysis, TypeStateProperty property, TypeStateOptions options, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, PerformanceTracker perfTracker) {
        super(cg, pointerAnalysis, property, options, null, ora, metrics, reporter, null, null);
        this.domoOptions = domoOptions;
        this.perfTracker = perfTracker;
    }

    @Override
    public ISolverResult perform(IProgressMonitor monitor) throws WalaException, SolverTimeoutException, SetUpException, PropertiesException, CancelException {
        monitor.beginTask(null, 1);
        monitor.subTask(this.toString());
        this.optionalStatistics();
        int i = 0;
        while (i < stageKinds.length) {
            block11: {
                String timingKey = null;
                try {
                    try {
                        ISafeSolver s = TypestateSolverFactory.getSolver(stageKinds[i], this.domoOptions, this.getCallGraph(), this.getPointerAnalysis(), this.getPointerAnalysis().getHeapGraph(), this.getDFA(), this.getBenignOracle(), this.getOptions(), this.getMetrics(), this.getReporter(), this.perfTracker, null);
                        timingKey = stageKinds[i] + " " + s.toString();
                        if (this.perfTracker != null) {
                            this.perfTracker.startTracking(timingKey);
                        }
                        this.stageResults[i] = s.perform(monitor);
                    }
                    catch (MaxFindingsException maxFindingsException) {
                        if (this.perfTracker != null) {
                            this.perfTracker.stopTracking(timingKey);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (this.perfTracker != null) {
                        this.perfTracker.stopTracking(timingKey);
                    }
                    throw throwable;
                }
                if (this.perfTracker != null) {
                    this.perfTracker.stopTracking(timingKey);
                }
            }
            ++i;
        }
        if (Thread.interrupted()) {
            throw new SolverTimeoutException(this.stageResults[this.stageResults.length - 1]);
        }
        monitor.done();
        return this.stageResults[this.stageResults.length - 1];
    }

    private void optionalStatistics() throws PropertiesException {
        if (this.getOptions().shouldCollectStatistics()) {
            this.initializeProperty();
            Collection<InstanceKey> instances = this.computeTrackedInstances();
            this.getMetrics().setNumberOfDFASliceCandidateStatements(this.getPropertyName(), this.countCandidateStatements(instances));
            if (this.getMetrics().getUnoptimizedSupergraphSize() == 0) {
                this.initializeNoCollapseSet();
                AnalysisCacheImpl ac = new AnalysisCacheImpl();
                WholeProgramSupergraph g = this.buildSupergraph((AnalysisCache)ac, (Collection<CGNode>)Iterator2Collection.toList((Iterator)this.getCallGraph().iterator()));
                this.getMetrics().setUnoptimizedSupergraphSize(g.getNumberOfNodes());
            }
        }
    }

    @Override
    protected TypeStateProblem createTypeStateProblem(ICFGSupergraph supergraph, Collection<InstanceKey> instances) throws WalaException, PropertiesException {
        return null;
    }

    @Override
    protected void initializeDomain(Collection<InstanceKey> instances) {
    }

    @Override
    protected InstanceBatchIterator makeBatchIterator(Collection<InstanceKey> allInstances) {
        return null;
    }

    @Override
    protected boolean supportsWitnessGeneration() {
        return false;
    }
}

