/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.rules;

import com.ibm.safe.typestate.core.TwoExitCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InterproceduralCFG
implements NumberedGraph<BasicBlockInContext> {
    private static final int DEBUG_LEVEL = 0;
    private static final boolean CALL_TO_RETURN_EDGES = true;
    private final NumberedGraph<BasicBlockInContext> G = new SlowSparseNumberedGraph(2);
    private final CallGraph cg;
    private final boolean partitionExits;
    private final Predicate<CGNode> relevant;
    private final BitVector hasCallVector = new BitVector();
    private final Predicate isCall = new Predicate(){

        public boolean test(Object o) {
            return InterproceduralCFG.this.hasCall((BasicBlockInContext)o);
        }
    };

    public InterproceduralCFG(CallGraph CG) {
        this(CG, (Predicate<CGNode>)IndiscriminateFilter.singleton(), false);
    }

    public InterproceduralCFG(CallGraph CG, Predicate<CGNode> relevant, boolean partitionExits) {
        this.cg = CG;
        this.relevant = relevant;
        this.partitionExits = partitionExits;
        this.createNodes();
        this.createEdges();
    }

    private void createEdges() {
        for (CGNode n : this.cg) {
            Object cfg;
            IR ir;
            if (!this.relevant.test((Object)n) || (ir = n.getIR()) == null || (cfg = ir.getControlFlowGraph()) == null) continue;
            if (this.partitionExits) {
                cfg = new TwoExitCFG((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)cfg);
            }
            SSAInstruction[] instrs = (SSAInstruction[])cfg.getInstructions();
            for (ISSABasicBlock bb : cfg) {
                if (bb == cfg.entry()) {
                    this.addEdgesToEntryBlock(n, bb);
                    continue;
                }
                this.addEdgesToNonEntryBlock(n, (ControlFlowGraph<SSAInstruction, ISSABasicBlock>)cfg, instrs, bb);
            }
        }
    }

    private void createNodes() {
        for (CGNode n : this.cg) {
            ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg;
            if (!this.relevant.test((Object)n) || (cfg = this.getCFG(n)) == null) continue;
            this.addNodeForEachBasicBlock(cfg, n);
        }
    }

    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        IR ir = n.getIR();
        if (ir == null) {
            return null;
        }
        Object cfg = ir.getControlFlowGraph();
        if (cfg == null) {
            return null;
        }
        if (this.partitionExits) {
            cfg = new TwoExitCFG((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)cfg);
        }
        return cfg;
    }

    private void addEdgesToNonEntryBlock(CGNode n, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, SSAInstruction[] instrs, ISSABasicBlock bb) {
        Iterator ps = cfg.getPredNodes((Object)bb);
        while (ps.hasNext()) {
            ISSABasicBlock pb = (ISSABasicBlock)ps.next();
            if (pb.getLastInstructionIndex() < 0) {
                BasicBlockInContext p = new BasicBlockInContext(n, pb);
                BasicBlockInContext b = new BasicBlockInContext(n, bb);
                this.G.addEdge((Object)p, (Object)b);
                continue;
            }
            int index = pb.getLastInstructionIndex();
            SSAInstruction inst = instrs[index];
            if (inst instanceof IInvokeInstruction) {
                IInvokeInstruction call = (IInvokeInstruction)inst;
                CallSiteReference site = InterproceduralCFG.makeCallSiteReference(n.getMethod().getDeclaringClass().getClassLoader().getReference(), cfg.getProgramCounter(index), call);
                boolean irrelevantTargets = false;
                for (CGNode tn : this.cg.getPossibleTargets(n, site)) {
                    Object tcfg;
                    if (!this.relevant.test((Object)tn)) {
                        irrelevantTargets = true;
                        continue;
                    }
                    if (tn.getIR() == null || (tcfg = tn.getIR().getControlFlowGraph()) == null) continue;
                    if (this.partitionExits) {
                        if (!(tcfg instanceof TwoExitCFG)) {
                            tcfg = new TwoExitCFG((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)tcfg);
                        }
                        if (this.representsNormalReturn(cfg, bb, pb)) {
                            this.addEdgesFromNormalExitToReturn(n, bb, tn, (TwoExitCFG)tcfg);
                        }
                        if (!this.representsExceptionalReturn(cfg, bb, pb)) continue;
                        this.addEdgesFromExceptionalExitToReturn(n, bb, tn, (TwoExitCFG)tcfg);
                        continue;
                    }
                    this.addEdgesFromExitToReturn(n, bb, tn, (ControlFlowGraph<SSAInstruction, ISSABasicBlock>)tcfg);
                }
                BasicBlockInContext p = new BasicBlockInContext(n, pb);
                BasicBlockInContext b = new BasicBlockInContext(n, bb);
                this.G.addEdge((Object)p, (Object)b);
                continue;
            }
            BasicBlockInContext p = new BasicBlockInContext(n, pb);
            BasicBlockInContext b = new BasicBlockInContext(n, bb);
            if (!this.G.containsNode((Object)p) || !this.G.containsNode((Object)b)) {
                assert (this.G.containsNode((Object)p)) : "IPCFG does not contain " + p;
                assert (this.G.containsNode((Object)b)) : "IPCFG does not contain " + b;
            }
            this.G.addEdge((Object)p, (Object)b);
        }
    }

    public static CallSiteReference makeCallSiteReference(ClassLoaderReference loader, int pc, IInvokeInstruction call) throws IllegalArgumentException, IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        if (!(call instanceof SSAInvokeInstruction) && !(call instanceof InvokeInstruction)) {
            throw new IllegalArgumentException("(not ( call instanceof com.ibm.wala.ssa.SSAInvokeInstruction ) ) and (not ( call instanceof com.ibm.wala.shrikeBT.InvokeInstruction ) )");
        }
        CallSiteReference site = null;
        if (call instanceof InvokeInstruction) {
            InvokeInstruction c = (InvokeInstruction)call;
            site = CallSiteReference.make((int)pc, (MethodReference)MethodReference.findOrCreate((ClassLoaderReference)loader, (String)c.getClassType(), (String)c.getMethodName(), (String)c.getMethodSignature()), (IInvokeInstruction.IDispatch)call.getInvocationCode());
        } else {
            SSAInvokeInstruction c = (SSAInvokeInstruction)call;
            site = CallSiteReference.make((int)pc, (MethodReference)c.getDeclaredTarget(), (IInvokeInstruction.IDispatch)call.getInvocationCode());
        }
        return site;
    }

    private void addEdgesFromExceptionalExitToReturn(CGNode caller, ISSABasicBlock returnBlock, CGNode target, TwoExitCFG targetCFG) {
        ISSABasicBlock texit = targetCFG.getExceptionalExit();
        BasicBlockInContext exit = new BasicBlockInContext(target, texit);
        BasicBlockInContext ret = new BasicBlockInContext(caller, returnBlock);
        if (!this.G.containsNode((Object)exit) || !this.G.containsNode((Object)ret)) {
            assert (this.G.containsNode((Object)exit)) : "IPCFG does not contain " + exit;
            assert (this.G.containsNode((Object)ret)) : "IPCFG does not contain " + ret;
        }
        this.G.addEdge((Object)exit, (Object)ret);
    }

    private boolean representsExceptionalReturn(ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock ret, ISSABasicBlock call) {
        Iterator it = cfg.getExceptionalSuccessors((Object)call).iterator();
        while (it.hasNext()) {
            if (!ret.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    private void addEdgesFromNormalExitToReturn(CGNode caller, ISSABasicBlock returnBlock, CGNode target, TwoExitCFG targetCFG) {
        ISSABasicBlock texit = targetCFG.getNormalExit();
        BasicBlockInContext exit = new BasicBlockInContext(target, texit);
        BasicBlockInContext ret = new BasicBlockInContext(caller, returnBlock);
        if (!this.G.containsNode((Object)exit) || !this.G.containsNode((Object)ret)) {
            assert (this.G.containsNode((Object)exit)) : "IPCFG does not contain " + exit;
            assert (this.G.containsNode((Object)ret)) : "IPCFG does not contain " + ret;
        }
        this.G.addEdge((Object)exit, (Object)ret);
    }

    private boolean representsNormalReturn(ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, ISSABasicBlock ret, ISSABasicBlock call) {
        Iterator it = cfg.getNormalSuccessors((Object)call).iterator();
        while (it.hasNext()) {
            if (!ret.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    private void addEdgesFromExitToReturn(CGNode caller, ISSABasicBlock returnBlock, CGNode target, ControlFlowGraph<SSAInstruction, ISSABasicBlock> targetCFG) {
        ISSABasicBlock texit = (ISSABasicBlock)targetCFG.exit();
        BasicBlockInContext exit = new BasicBlockInContext(target, texit);
        BasicBlockInContext ret = new BasicBlockInContext(caller, returnBlock);
        if (!this.G.containsNode((Object)exit) || !this.G.containsNode((Object)ret)) {
            assert (this.G.containsNode((Object)exit)) : "IPCFG does not contain " + exit;
            assert (this.G.containsNode((Object)ret)) : "IPCFG does not contain " + ret;
        }
        this.G.addEdge((Object)exit, (Object)ret);
    }

    private void addEdgesToEntryBlock(CGNode n, ISSABasicBlock bb) {
        Iterator callers = this.cg.getPredNodes((Object)n);
        while (callers.hasNext()) {
            CGNode caller = (CGNode)callers.next();
            if (!this.relevant.test((Object)caller)) continue;
            SSACFG ccfg = caller.getIR().getControlFlowGraph();
            SSAInstruction[] cinsts = (SSAInstruction[])ccfg.getInstructions();
            int i = 0;
            while (i < cinsts.length) {
                if (cinsts[i] instanceof IInvokeInstruction) {
                    IInvokeInstruction call = (IInvokeInstruction)cinsts[i];
                    CallSiteReference site = InterproceduralCFG.makeCallSiteReference(n.getMethod().getDeclaringClass().getClassLoader().getReference(), ccfg.getProgramCounter(i), call);
                    if (this.cg.getPossibleTargets(caller, site).contains(n)) {
                        ISSABasicBlock callerBB = (ISSABasicBlock)ccfg.getBlockForInstruction(i);
                        BasicBlockInContext b1 = new BasicBlockInContext(caller, callerBB);
                        BasicBlockInContext b2 = new BasicBlockInContext(n, bb);
                        this.G.addEdge((Object)b1, (Object)b2);
                    }
                }
                ++i;
            }
        }
    }

    private void addNodeForEachBasicBlock(ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, CGNode N) {
        for (ISSABasicBlock bb : cfg) {
            BasicBlockInContext b = new BasicBlockInContext(N, bb);
            this.G.addNode((Object)b);
            if (!this.hasCall(b, cfg)) continue;
            this.hasCallVector.set(this.getNumber(b));
        }
    }

    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(BasicBlockInContext<ISSABasicBlock> B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return this.getCFG(this.getCGNode(B));
    }

    public CGNode getCGNode(BasicBlockInContext B) throws IllegalArgumentException {
        if (B == null) {
            throw new IllegalArgumentException("B == null");
        }
        return B.getNode();
    }

    public void removeNodeAndEdges(BasicBlockInContext N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterator<BasicBlockInContext> iterator() {
        return this.G.iterator();
    }

    public int getNumberOfNodes() {
        return this.G.getNumberOfNodes();
    }

    public void addNode(BasicBlockInContext n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeNode(BasicBlockInContext n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterator<BasicBlockInContext> getPredNodes(BasicBlockInContext N) {
        return this.G.getPredNodes((Object)N);
    }

    public int getPredNodeCount(BasicBlockInContext N) {
        return this.G.getPredNodeCount((Object)N);
    }

    public Iterator<BasicBlockInContext> getSuccNodes(BasicBlockInContext N) {
        return this.G.getSuccNodes((Object)N);
    }

    public int getSuccNodeCount(BasicBlockInContext N) {
        return this.G.getSuccNodeCount((Object)N);
    }

    public void addEdge(BasicBlockInContext src, BasicBlockInContext dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(BasicBlockInContext src, BasicBlockInContext dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIncidentEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.G.toString();
    }

    public boolean containsNode(BasicBlockInContext N) {
        return this.G.containsNode((Object)N);
    }

    public boolean hasCall(BasicBlockInContext B) {
        if (!this.containsNode(B)) assert (this.containsNode(B));
        return this.hasCallVector.get(this.getNumber(B));
    }

    private boolean hasCall(BasicBlockInContext B, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg) {
        SSAInstruction[] statements = (SSAInstruction[])cfg.getInstructions();
        int lastIndex = B.getLastInstructionIndex();
        if (lastIndex >= 0) {
            if (statements.length <= lastIndex) {
                System.err.println(statements.length);
                System.err.println(cfg);
                assert (lastIndex < statements.length) : "bad BB " + B + " and CFG for " + this.getCGNode(B);
            }
            SSAInstruction last = statements[lastIndex];
            return last instanceof IInvokeInstruction;
        }
        return false;
    }

    public Set<CGNode> getCallTargets(BasicBlockInContext B) {
        if (B == null) {
            throw new IllegalArgumentException("B is null");
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.getCFG((BasicBlockInContext<ISSABasicBlock>)B);
        return this.getCallTargets((IBasicBlock<SSAInstruction>)B, cfg, this.getCGNode(B));
    }

    private Set<CGNode> getCallTargets(IBasicBlock<SSAInstruction> B, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, CGNode Bnode) {
        SSAInstruction[] statements = (SSAInstruction[])cfg.getInstructions();
        IInvokeInstruction call = (IInvokeInstruction)statements[B.getLastInstructionIndex()];
        int pc = cfg.getProgramCounter(B.getLastInstructionIndex());
        CallSiteReference site = InterproceduralCFG.makeCallSiteReference(B.getMethod().getDeclaringClass().getClassLoader().getReference(), pc, call);
        HashSet result = HashSetFactory.make((int)this.cg.getNumberOfTargets(Bnode, site));
        for (CGNode target : this.cg.getPossibleTargets(Bnode, site)) {
            result.add(target);
        }
        return result;
    }

    public void removeIncomingEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeOutgoingEdges(BasicBlockInContext node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasEdge(BasicBlockInContext src, BasicBlockInContext dst) {
        return this.G.hasEdge((Object)src, (Object)dst);
    }

    public int getNumber(BasicBlockInContext N) {
        return this.G.getNumber((Object)N);
    }

    public BasicBlockInContext getNode(int number) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public int getMaxNumber() {
        return this.G.getMaxNumber();
    }

    public Iterator<BasicBlockInContext> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getSuccNodeNumbers(BasicBlockInContext node) {
        return this.G.getSuccNodeNumbers((Object)node);
    }

    public IntSet getPredNodeNumbers(BasicBlockInContext node) {
        return this.G.getPredNodeNumbers((Object)node);
    }

    public Object getEntry(CGNode n) {
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.getCFG(n);
        ISSABasicBlock entry = (ISSABasicBlock)cfg.entry();
        return new BasicBlockInContext(n, entry);
    }

    public Iterator<BasicBlockInContext> getReturnSites(BasicBlockInContext<ISSABasicBlock> callBlock) {
        if (callBlock == null) {
            throw new IllegalArgumentException("bb is null");
        }
        final CGNode node = callBlock.getNode();
        Predicate isReturn = new Predicate(){

            public boolean test(Object o) {
                BasicBlockInContext other = (BasicBlockInContext)o;
                return !other.isEntryBlock() && node.equals(other.getNode());
            }
        };
        return new FilterIterator(this.getSuccNodes(callBlock), isReturn);
    }

    public Iterator<BasicBlockInContext> getCallSites(BasicBlockInContext<ISSABasicBlock> bb) {
        if (bb == null) {
            throw new IllegalArgumentException("bb is null");
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.getCFG(bb);
        Iterator it = cfg.getPredNodes((Object)bb.getDelegate());
        final CGNode node = bb.getNode();
        Function<ISSABasicBlock, BasicBlockInContext> toContext = new Function<ISSABasicBlock, BasicBlockInContext>(){

            public BasicBlockInContext<ISSABasicBlock> apply(ISSABasicBlock object) {
                ISSABasicBlock b = object;
                return new BasicBlockInContext(node, b);
            }
        };
        MapIterator m = new MapIterator(it, (Function)toContext);
        return new FilterIterator((Iterator)m, this.isCall);
    }

    public boolean isReturn(BasicBlockInContext bb) throws IllegalArgumentException {
        if (bb == null) {
            throw new IllegalArgumentException("bb == null");
        }
        ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.getCFG((BasicBlockInContext<ISSABasicBlock>)bb);
        Iterator it = cfg.getPredNodes((Object)bb.getDelegate());
        while (it.hasNext()) {
            ISSABasicBlock b = (ISSABasicBlock)it.next();
            if (!this.hasCall(new BasicBlockInContext(bb.getNode(), b))) continue;
            return true;
        }
        return false;
    }

    public Iterator<BasicBlockInContext<ISSABasicBlock>> getCallSites(BasicBlockInContext<ISSABasicBlock> returnBlock, final CGNode callee) {
        if (returnBlock == null) {
            throw new IllegalArgumentException("bb is null");
        }
        final ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg = this.getCFG(returnBlock);
        Iterator it = cfg.getPredNodes((Object)returnBlock.getDelegate());
        final CGNode node = returnBlock.getNode();
        Predicate<ISSABasicBlock> dispatchFilter = new Predicate<ISSABasicBlock>(){

            public boolean test(ISSABasicBlock callBlock) {
                BasicBlockInContext bb = new BasicBlockInContext(node, callBlock);
                if (!InterproceduralCFG.this.hasCall(bb, (ControlFlowGraph<SSAInstruction, ISSABasicBlock>)cfg)) {
                    return false;
                }
                if (callee != null) {
                    return InterproceduralCFG.this.getCallTargets(bb).contains(callee);
                }
                return InterproceduralCFG.this.getCallTargets(bb).isEmpty();
            }
        };
        it = new FilterIterator(it, (Predicate)dispatchFilter);
        Function<ISSABasicBlock, BasicBlockInContext<ISSABasicBlock>> toContext = new Function<ISSABasicBlock, BasicBlockInContext<ISSABasicBlock>>(){

            public BasicBlockInContext<ISSABasicBlock> apply(ISSABasicBlock object) {
                ISSABasicBlock b = object;
                return new BasicBlockInContext(node, b);
            }
        };
        MapIterator m = new MapIterator(it, (Function)toContext);
        return new FilterIterator((Iterator)m, this.isCall);
    }
}

