/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.rules;

import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class InstanceBatchIterator {
    private final Collection<InstanceKey> allInstances;

    InstanceBatchIterator(Collection<InstanceKey> allInstances) {
        this.allInstances = allInstances;
    }

    abstract Iterator<Collection<InstanceKey>> getInstanceBatches();

    public static InstanceBatchIterator makeNoSeparation(Collection<InstanceKey> allInstances) {
        return new AllTogether(allInstances);
    }

    public static InstanceBatchIterator makeSeparation(Collection<InstanceKey> allInstances) {
        return new Separation(allInstances);
    }

    private static class AllTogether
    extends InstanceBatchIterator {
        AllTogether(Collection<InstanceKey> allInstances) {
            super(allInstances);
        }

        @Override
        Iterator<Collection<InstanceKey>> getInstanceBatches() {
            return Collections.singleton(((InstanceBatchIterator)this).allInstances).iterator();
        }
    }

    private static class Separation
    extends InstanceBatchIterator {
        Separation(Collection<InstanceKey> allInstances) {
            super(allInstances);
        }

        @Override
        Iterator<Collection<InstanceKey>> getInstanceBatches() {
            final Iterator it = ((InstanceBatchIterator)this).allInstances.iterator();
            return new Iterator<Collection<InstanceKey>>(){

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Collection<InstanceKey> next() {
                    return Collections.singleton((InstanceKey)it.next());
                }
            };
        }
    }
}

