/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.rules;

import com.ibm.safe.dfa.events.IDispatchEvent;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.Collection;

public abstract class AbstractTypeStateDFA
implements ITypeStateDFA {
    private final IClassHierarchy cha;
    private final Collection<IClass> types;
    private boolean observesProgramExit;
    private boolean observesObjectDeath;

    protected AbstractTypeStateDFA(IClassHierarchy cha, Collection<IClass> types) {
        this.cha = cha;
        this.types = types;
    }

    @Override
    public boolean receives(IMethod m) {
        boolean isType = false;
        IClass c = m.getDeclaringClass();
        for (IClass t : this.types) {
            if (t.isInterface()) {
                if (!this.cha.implementsInterface(c, t)) continue;
                isType = true;
                break;
            }
            if (!this.cha.isSubclassOf(c, t) && !this.cha.isSubclassOf(t, c)) continue;
            isType = true;
            break;
        }
        if (isType) {
            return this.matchDispatchEvent(m.getSignature()) != null;
        }
        return false;
    }

    @Override
    public Collection<IClass> getTypes() {
        return this.types;
    }

    public void addType(IClass aType) {
        this.types.add(aType);
    }

    @Override
    public IEvent matchDispatchEvent(CGNode caller, String sig) {
        return this.match(IDispatchEvent.class, sig);
    }

    @Override
    public IEvent matchDispatchEvent(String sig) {
        return this.match(IDispatchEvent.class, sig);
    }

    public abstract IEvent match(Class var1, String var2);

    @Override
    public boolean observesProgramExit() {
        return this.observesProgramExit;
    }

    public void setObservesProgramExit(boolean observesProgramExit) {
        this.observesProgramExit = observesProgramExit;
    }

    @Override
    public boolean observesObjectDeath() {
        return this.observesObjectDeath;
    }

    public void setObservesObjectDeath(boolean observesObjectDeath) {
        this.observesObjectDeath = observesObjectDeath;
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

