/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.quad;

import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathSet;
import com.ibm.safe.accesspath.AccessPathSetTransformers;
import com.ibm.safe.accesspath.LocalPathElement;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.typestate.ap.TemporaryParameterPointerKey;
import com.ibm.safe.typestate.ap.must.MustAuxiliary;
import com.ibm.safe.typestate.ap.must.MustMerge;
import com.ibm.safe.typestate.ap.must.mustnot.MustMustNotAuxiliary;
import com.ibm.safe.typestate.ap.must.mustnot.MustMustNotMerge;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.quad.Auxiliary;
import com.ibm.safe.typestate.quad.QuadFactoid;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

public class QuadTypeStateDomain
extends TypeStateDomain {
    private static final boolean VERBOSE = true;
    private final PointerAnalysis pointsTo;

    public QuadTypeStateDomain(ITypeStateDFA dfa, TypeStateOptions options, PointerAnalysis pointsTo) {
        super(dfa, options);
        this.pointsTo = pointsTo;
    }

    public int add(InstanceKey instance, IDFAState state, boolean isUnique, Auxiliary aux) {
        QuadFactoid f = new QuadFactoid(instance, state, isUnique, aux);
        if (this.getMappedIndex(f) == -1) {
            this.verbosePrint(f);
        }
        return this.add(f);
    }

    private void verbosePrint(QuadFactoid f) {
        MustAuxiliary m = (MustAuxiliary)f.aux;
        if (f.aux instanceof MustMustNotAuxiliary) {
            MustMustNotAuxiliary mn = (MustMustNotAuxiliary)f.aux;
            System.err.println("Factoid: " + this.add(f) + " " + m.getMustPaths().size() + " " + mn.getMustNotPaths().size());
            System.err.println(f);
            Trace.println((String)(String.valueOf(this.add(f)) + " " + m.getMustPaths().size() + " " + mn.getMustNotPaths().size()));
            Trace.println((Object)f);
        } else {
            System.err.println(String.valueOf(this.add(f)) + " " + m.getMustPaths().size());
            System.err.println(f);
            Trace.println((String)(String.valueOf(this.add(f)) + " " + m.getMustPaths().size()));
            Trace.println((Object)f);
        }
        if (m.isComplete() && m.getMustPaths().size() == 0) {
            Assertions.UNREACHABLE();
        }
        AccessPathSet must = m.getMustPaths();
        if (!m.isComplete() && AccessPathSetTransformers.containsArrayPath(must)) {
            Assertions.UNREACHABLE((String)"don't support array paths with incomplete must");
        }
        if (m instanceof MustMustNotAuxiliary) {
            MustMustNotAuxiliary mn = (MustMustNotAuxiliary)f.aux;
            AccessPathSet mustNot = mn.getMustNotPaths();
            this.checkDisjoint(must, mustNot);
            this.checkConsistent(mustNot, f.instance);
            if (AccessPathSetTransformers.containsArrayPath(mustNot)) {
                Assertions.UNREACHABLE((String)"don't support array paths in must not");
            }
            if (m.isComplete() && mustNot.size() > 0) {
                Assertions.UNREACHABLE((String)"no point carrying mustNot in complete factoid");
            }
        }
        this.checkConsistent(must, f.instance);
    }

    private void checkConsistent(AccessPathSet s, InstanceKey ik) {
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            this.checkConsistent(ap, ik);
        }
    }

    private void checkConsistent(AccessPath ap, InstanceKey ik) {
        PointerKey pk;
        PathElement head;
        if (ap.length() == 1 && (head = ap.getHead()) instanceof LocalPathElement && !((pk = ((LocalPathElement)head).getPointerKey()) instanceof TemporaryParameterPointerKey) && !this.pointsTo.getPointsToSet(pk).contains((Object)ik)) {
            Assertions.UNREACHABLE();
        }
    }

    private void checkDisjoint(AccessPathSet must, AccessPathSet mustNot) {
        Iterator<AccessPath> it = mustNot.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            if (!must.contains(ap)) continue;
            Assertions.UNREACHABLE();
        }
    }

    public int findOrCreate(InstanceKey instance, IDFAState state, boolean isUnique, Auxiliary aux) {
        return this.add(instance, state, isUnique, aux);
    }

    @Override
    public int getIndexForStateDelta(BaseFactoid inputFact, IDFAState succState) {
        QuadFactoid i = (QuadFactoid)inputFact;
        QuadFactoid f = new QuadFactoid(i.instance, succState, i.isUnique(), i.aux);
        if (this.getMappedIndex(f) == -1) {
            this.verbosePrint(f);
        }
        return this.add(f);
    }

    @Override
    public int getIndexForInitialState(InstanceKey ik) {
        Assertions.UNREACHABLE();
        return 0;
    }

    public boolean isWeakerThan(int d1, int d2) {
        assert (d1 != d2);
        if (d1 == 0) {
            return true;
        }
        if (d2 == 0) {
            return false;
        }
        QuadFactoid f1 = (QuadFactoid)this.getMappedObject(d1);
        QuadFactoid f2 = (QuadFactoid)this.getMappedObject(d2);
        if (f1.aux instanceof MustMustNotAuxiliary) {
            return MustMustNotMerge.isWeaker(f1, f2);
        }
        if (f1.aux instanceof MustAuxiliary) {
            return MustMerge.isWeaker(f1, f2);
        }
        return false;
    }
}

