/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.quad;

import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.ArrayList;
import java.util.List;

public class AggregateFlowFunction
implements IUnaryFlowFunction {
    private static final int DEBUG_LEVEL = 0;
    private static final int ARRAY_SIZE = 2;
    private static final boolean DEBUG_COUNT_INSTANCES = false;
    private static long instances = 0L;
    private List<IFlowFunction> functions;

    public SparseIntSet getTargets(int d1) {
        if (this.functions == null || this.functions.isEmpty()) {
            return SparseIntSet.singleton((int)d1);
        }
        MutableSparseIntSet currSet = MutableSparseIntSet.makeEmpty();
        MutableSparseIntSet nextSet = MutableSparseIntSet.makeEmpty();
        currSet.add(d1);
        for (IUnaryFlowFunction iUnaryFlowFunction : this.functions) {
            IntIterator factoidIt = currSet.intIterator();
            while (factoidIt.hasNext()) {
                int currFactoid = factoidIt.next();
                IntSet currResult = iUnaryFlowFunction.getTargets(currFactoid);
                if (currResult == null) continue;
                nextSet.addAll(currResult);
            }
            currSet = nextSet;
            nextSet = MutableSparseIntSet.makeEmpty();
        }
        assert (currSet != null);
        return currSet;
    }

    public void composeFunction(IFlowFunction flow) {
        assert (flow != null) : "cannot add a null flow function";
        if (flow == IdentityFlowFunction.identity()) {
            return;
        }
        if (this.functions == null) {
            this.functions = new ArrayList<IFlowFunction>(2);
        }
        this.functions.add(flow);
    }

    public boolean isEmpty() {
        return this.functions == null || this.functions.isEmpty();
    }

    public String toString() {
        return "Aggregate:" + (this.functions != null ? this.functions.toString() : "[]");
    }

    protected List<IFlowFunction> getFunctions() {
        return this.functions;
    }

    public static IUnaryFlowFunction compose(IUnaryFlowFunction f1, IUnaryFlowFunction f2) {
        if (f2 == IdentityFlowFunction.identity()) {
            return f1;
        }
        if (f1 == IdentityFlowFunction.identity()) {
            return f2;
        }
        if (f1 instanceof AggregateFlowFunction) {
            AggregateFlowFunction ag = (AggregateFlowFunction)f1;
            ag.composeFunction((IFlowFunction)f2);
            return ag;
        }
        AggregateFlowFunction result = new AggregateFlowFunction();
        result.composeFunction((IFlowFunction)f1);
        result.composeFunction((IFlowFunction)f2);
        return result;
    }

    public IFlowFunction simplify() {
        if (this.functions == null) {
            return IdentityFlowFunction.identity();
        }
        switch (this.functions.size()) {
            case 0: {
                return IdentityFlowFunction.identity();
            }
            case 1: {
                return this.functions.get(0);
            }
        }
        return this;
    }
}

