/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.options;

import com.ibm.safe.options.WholeProgramProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.wala.util.debug.Assertions;

public class TypestateProperties {
    public static void register() {
        PropertiesManager.registerProperties((PropertiesManager.IPropertyDescriptor[])Props.values());
        WholeProgramProperties.register();
    }

    public static enum Props implements PropertiesManager.IPropertyDescriptor
    {
        ABSTRACT_TRACE_FILE_NAME("abstract_trace_file_name", PropertiesManager.Type.STRING, "Name of output file used in spec mining."),
        GENERATE_WITNESS("generate_witness", PropertiesManager.Type.BOOLEAN, ""),
        MINE_DFA("mine_dfa", PropertiesManager.Type.BOOLEAN, "Enable specification mining."),
        MINE_MERGE("mine_merge", PropertiesManager.Type.STRING, "Simulation", "Specifies kind of merge operator used in spec mining."),
        MINE_TYPE("mine_type", PropertiesManager.Type.STRING, ""),
        MINE_CONTEXT("mine_context", PropertiesManager.Type.INT, 1, ""),
        MINE_CONTEXT_EVENT("mine_context_event", PropertiesManager.Type.STRING, ""),
        MODULAR_SUMMARY("modular_summary", PropertiesManager.Type.STRING, "Base", ""),
        MUST_AP_KLIMIT("must_ap_klmit", PropertiesManager.Type.INT, 2, "Access path limit length for Must pointer analysis"),
        PROPERTY_GRAPH("property_graph", PropertiesManager.Type.STRING, "Outputs the property graph."),
        SELECT_TYPESTATE_RULES("select_typestate_rules", PropertiesManager.Type.STRING, "Selects a list of typestate rules to apply (file name without extension XMI)."),
        SLICE_DFA("slice_dfa", PropertiesManager.Type.BOOLEAN, "Use DFA-slicing."),
        TYPESTATE_SOLVER_KIND("typestate_solver_kind", PropertiesManager.Type.STRING, "Staged", "Specifies kind of solver to use for TypeState analysis.");

        private final String name;
        private final boolean cmdLine;
        private final PropertiesManager.Type type;
        private final String defaultString;
        private final String description;

        private Props(String name, PropertiesManager.Type type, String defaultString, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.defaultString = defaultString;
            this.description = description;
        }

        private Props(String name, PropertiesManager.Type type, int defaultInt, String description) {
            this(name, type, String.valueOf(defaultInt), description);
        }

        private Props(String name, PropertiesManager.Type type, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.description = description;
            switch (type) {
                case BOOLEAN: {
                    this.defaultString = "false";
                    break;
                }
                case INT: {
                    this.defaultString = null;
                    break;
                }
                case STRING: {
                    this.defaultString = null;
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                    this.defaultString = null;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isCommandLineOption() {
            return this.cmdLine;
        }

        public PropertiesManager.Type getType() {
            return this.type;
        }

        public String getDefaultAsString() {
            return this.defaultString;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

