/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.options;

import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.options.WholeProgramOptions;
import com.ibm.safe.options.WholeProgramProperties;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.typestate.controller.TypeStateSolverKind;
import com.ibm.safe.typestate.options.MineMergeKind;
import com.ibm.safe.typestate.options.TypestateProperties;

public class TypeStateOptions
extends WholeProgramOptions {
    private IRule[] rules;

    public TypeStateOptions(WholeProgramOptions wpOptions) {
        super(wpOptions);
    }

    public TypeStateOptions(PropertiesManager propertiesManager) {
        super(propertiesManager);
    }

    public TypeStateOptions(PropertiesManager propertiesManager, IRule[] rules) {
        super(propertiesManager);
        this.rules = rules;
    }

    public String getPointsToDotFile() throws PropertiesException {
        return this.getStringValue((PropertiesManager.IPropertyDescriptor)WholeProgramProperties.Props.POINTS_TO_GRAPH);
    }

    public String getPropertyDotFile() throws PropertiesException {
        return this.getStringValue(TypestateProperties.Props.PROPERTY_GRAPH);
    }

    public void setRules(TypestateRule[] rules) {
        this.rules = rules;
    }

    public TypestateRule[] getRules() {
        return (TypestateRule[])this.rules;
    }

    public boolean shouldDumpCallGraph() throws PropertiesException {
        return this.getBooleanValue((PropertiesManager.IPropertyDescriptor)WholeProgramProperties.Props.REPORT_CALL_GRAPH);
    }

    public boolean shouldCollectStatistics() throws PropertiesException {
        return this.getBooleanValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.COLLECT_STATISTICS);
    }

    public boolean shouldMineDFA() throws PropertiesException {
        return this.getBooleanValue(TypestateProperties.Props.MINE_DFA);
    }

    public boolean shouldCreatePointsToDotFile() throws PropertiesException {
        return this.getPointsToDotFile() != null;
    }

    public boolean shouldCreatePropertyDotFile() throws PropertiesException {
        return this.getPropertyDotFile() != null;
    }

    public boolean shouldSliceDFA() throws PropertiesException {
        return this.getBooleanValue(TypestateProperties.Props.SLICE_DFA);
    }

    public boolean shouldGenerateWitness() throws PropertiesException {
        return this.getBooleanValue(TypestateProperties.Props.GENERATE_WITNESS);
    }

    public int getAccessPathKLimit() throws PropertiesException {
        return this.getIntValue(TypestateProperties.Props.MUST_AP_KLIMIT);
    }

    public String getMineType() throws PropertiesException {
        return this.getStringValue(TypestateProperties.Props.MINE_TYPE);
    }

    public String getTypeStateSolverKindString() throws PropertiesException {
        return this.getStringValue(TypestateProperties.Props.TYPESTATE_SOLVER_KIND);
    }

    public String getMineMergeKindString() throws PropertiesException {
        return this.getStringValue(TypestateProperties.Props.MINE_MERGE);
    }

    public MineMergeKind getMineMergeKind() throws PropertiesException {
        MineMergeKind kind = MineMergeKind.getMergeKindFromString(this.getMineMergeKindString());
        if (kind == null) {
            throw new PropertiesException("Bad merge property kind " + this.getMineMergeKindString());
        }
        return kind;
    }

    public TypeStateSolverKind getTypeStateSolverKind() throws PropertiesException {
        TypeStateSolverKind kind = TypeStateSolverKind.getSolverKindFromString(this.getTypeStateSolverKindString());
        if (kind == null) {
            throw new PropertiesException("Bad solver property kind " + this.getTypeStateSolverKindString());
        }
        return kind;
    }

    public String getPointsToDotFileName() throws PropertiesException {
        return this.getStringValue((PropertiesManager.IPropertyDescriptor)WholeProgramProperties.Props.POINTS_TO_GRAPH);
    }

    public String getOutputDirectory() throws PropertiesException {
        return this.getPathValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.OUTPUT_DIR);
    }

    public String getAbstractTraceFileName() throws PropertiesException {
        String result = this.getStringValue(TypestateProperties.Props.ABSTRACT_TRACE_FILE_NAME);
        if (result == null) {
            result = "traces.txt";
        }
        return result;
    }

    public String getPropertyDotFileName() throws PropertiesException {
        return this.getStringValue(TypestateProperties.Props.PROPERTY_GRAPH);
    }
}

