/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.options;

import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.safe.typestate.merge.FutureMerge;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.mine.EventNameStateFactory;
import com.ibm.safe.typestate.mine.LossLessMerge;
import com.ibm.safe.typestate.mine.StateSimulationMerge;
import com.ibm.safe.typestate.mine.UnifyMerge;
import com.ibm.safe.typestate.mine.UniqueNameStateFactory;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Map;

public class MineMergeKind {
    private static Map<String, MineMergeKind> allKinds = HashMapFactory.make();
    public static final MineMergeKind NONE = MineMergeKind.createMergeKind("None");
    public static final MineMergeKind TOTAL = MineMergeKind.createMergeKind("Total");
    public static final MineMergeKind SIMULATION = MineMergeKind.createMergeKind("Simulation");
    public static final MineMergeKind LOSSLESS = MineMergeKind.createMergeKind("Lossless");
    public static final MineMergeKind FUTURE = MineMergeKind.createMergeKind("Future");
    private final String mergeKind;

    public String toString() {
        return this.mergeKind;
    }

    private MineMergeKind(String mergeKind) {
        this.mergeKind = mergeKind;
    }

    private static MineMergeKind createMergeKind(String mergeKind) {
        MineMergeKind mmk = new MineMergeKind(mergeKind);
        allKinds.put(mergeKind, mmk);
        return mmk;
    }

    public static MineMergeKind getMergeKindFromString(String mineMergeKindString) {
        return allKinds.get(mineMergeKindString);
    }

    public static IMergeFunctionFactory getMergeFactory(MineMergeKind mmk) {
        if (mmk == NONE) {
            return null;
        }
        if (mmk == TOTAL) {
            return UnifyMerge.factory();
        }
        if (mmk == SIMULATION) {
            return StateSimulationMerge.factory();
        }
        if (mmk == LOSSLESS) {
            return LossLessMerge.factory();
        }
        if (mmk == FUTURE) {
            return FutureMerge.factory();
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static IDFAStateFactory getStateFactory(MineMergeKind mmk) {
        if (mmk == FUTURE) {
            return new UniqueNameStateFactory();
        }
        return new EventNameStateFactory();
    }
}

