/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IDispatchEvent;
import com.ibm.safe.dfa.events.IDispatchEventImpl;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IObjectDeathEvent;
import com.ibm.safe.dfa.events.IProgramExitEventImpl;
import com.ibm.safe.typestate.merge.AbstractUnification;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.safe.typestate.rules.AbstractTypeStateDFA;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TracingProperty
extends AbstractTypeStateDFA {
    private IDFAState initialState;
    public static final boolean SELECTOR_EVENTS = false;
    private final Map<String, IEvent> eventName2Event = HashMapFactory.make();

    public TracingProperty(IClassHierarchy cha, Collection<IClass> klasses) {
        super(cha, klasses);
        this.populateEventMap(klasses);
    }

    private void populateEventMap(Collection<IClass> klasses) {
        for (IClass klass : klasses) {
            this.populateEventMap(klass);
        }
    }

    private void populateEventMap(IClass klass) {
        try {
            for (IMethod m : klass.getAllMethods()) {
                String name;
                if (!this.isInterestingMethod(m) || this.eventName2Event.get(name = this.getEventName(m)) != null) continue;
                IDispatchEventImpl newEvent = new IDispatchEventImpl();
                newEvent.setName(name);
                this.eventName2Event.put(name, (IEvent)newEvent);
            }
        }
        catch (Exception exception) {
            Assertions.UNREACHABLE();
        }
    }

    private String getEventName(IMethod m) {
        return m.getName().toString();
    }

    private boolean isInterestingMethod(IMethod m) {
        if (this.isJavaLangObjectMethod(m) || m.isStatic() || m.isInit()) {
            return false;
        }
        if (m.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
            return !m.isPrivate() && !m.isProtected();
        }
        return m.isPublic();
    }

    private boolean isJavaLangObjectMethod(IMethod m) {
        IClass javaLangObject = this.getClassHierarchy().lookupClass(TypeReference.JavaLangObject);
        return this.getClassHierarchy().resolveMethod(javaLangObject, m.getSelector()) != null;
    }

    public void createInitial(AbstractUnification merger) {
        this.initialState = new AbstractHistory(merger);
    }

    @Override
    public IDFAState initial() {
        assert (this.initialState != null);
        return this.initialState;
    }

    private IEvent getEvent(String signature) {
        String selector = this.parseSignatureForEventName(signature);
        return this.eventName2Event.get(selector);
    }

    private String parseSignatureForEventName(String signature) {
        try {
            return TracingProperty.parseForName(signature);
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public static String parseForName(String sig) throws WalaException {
        int lastDot = sig.lastIndexOf(46);
        if (lastDot == -1) {
            throw new WalaException("ill-formatted method signature: " + sig);
        }
        int openParen = sig.indexOf(40);
        if (openParen == -1) {
            throw new WalaException("ill-formatted method signature: " + sig);
        }
        return sig.substring(lastDot + 1, openParen);
    }

    public static String parseForDescriptor(String sig) throws WalaException {
        int openParen = sig.indexOf(40);
        if (openParen == -1) {
            throw new WalaException("ill-formatted method signature: " + sig);
        }
        return sig.substring(openParen);
    }

    @Override
    public IEvent match(Class eventClass, String param) {
        if (eventClass.equals(IProgramExitEventImpl.class)) {
            Assertions.UNREACHABLE();
            return null;
        }
        return this.getEvent(param);
    }

    @Override
    public IEvent matchDispatchEvent(CGNode caller, String sig) {
        if (caller.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
            return this.getEvent(sig);
        }
        return null;
    }

    @Override
    public IDFAState successor(IDFAState state, IEvent event) {
        assert (state instanceof AbstractHistory);
        if (event instanceof IDispatchEvent) {
            return ((AbstractHistory)state).extend(event.getName());
        }
        if (event instanceof IObjectDeathEvent) {
            return ((AbstractHistory)state).exit();
        }
        if (event instanceof IProgramExitEventImpl) {
            return ((AbstractHistory)state).exit();
        }
        Assertions.UNREACHABLE((String)event.getClass().toString());
        return null;
    }

    public Set predecessors(IDFAState state, IEvent automatonLabel) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public String getName() {
        return "TracingProperty";
    }

    @Override
    public boolean receives(IMethod m) {
        return this.getEvent(m.getSignature()) != null;
    }

    @Override
    public boolean observesObjectDeath() {
        return true;
    }

    @Override
    public boolean observesProgramExit() {
        return true;
    }
}

