/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.safe.typestate.mine.AbstractTrace;
import com.ibm.safe.typestate.mine.TraceContainer;
import com.ibm.safe.typestate.mine.TracePersist;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

public class TraceReporter {
    private static final boolean VERBOSE = true;
    private final String outputDirectory;
    private final String programName;
    private final String type;
    private final String filename;
    private final String solver;
    private final String merger;
    Map<IDFA, Set<InstanceKey>> map = HashMapFactory.make();

    public TraceReporter(String solver, String merger, String type, String programName, String outputDirectory, String filename) {
        this.solver = solver;
        this.merger = merger;
        this.type = type;
        this.programName = programName;
        this.outputDirectory = outputDirectory;
        this.filename = filename;
    }

    public void record(BaseFactoid inputFact) {
        System.err.println("Reporting trace:");
        System.err.println(inputFact.toString());
        AbstractHistory t = (AbstractHistory)inputFact.state;
        Set instances = MapUtil.findOrCreateSet(this.map, (Object)t.getDfa());
        instances.add(inputFact.instance);
    }

    public void persist() throws WalaException {
        TraceContainer container = new TraceContainer();
        for (Map.Entry<IDFA, Set<InstanceKey>> e : this.map.entrySet()) {
            IDFA dfa = e.getKey();
            Set<InstanceKey> instances = e.getValue();
            AbstractTrace trace = this.makeTrace(dfa, instances);
            container.add(trace);
        }
        this.writeToFile(container);
    }

    private void writeToFile(TraceContainer container) throws WalaException {
        assert (container != null);
        File f = new File(String.valueOf(this.outputDirectory) + File.separator + this.filename);
        try {
            if (!f.exists()) {
                File parent = f.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                f.createNewFile();
            }
            PrintWriter out = new PrintWriter(new FileOutputStream(f));
            out.write(container.asXMLString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WalaException(this.getClass() + " failure to write to " + f.getAbsolutePath());
        }
        System.out.println("trace results have been created at " + f.getAbsolutePath());
    }

    private AbstractTrace makeTrace(IDFA dfa, Set<InstanceKey> instances) {
        AbstractTrace trace = new AbstractTrace();
        trace.setDfa(TracePersist.toEMF(dfa));
        trace.setProgram(this.programName);
        trace.setSolver(this.solver);
        trace.setMerger(this.merger);
        trace.setType(this.type);
        trace.addInstances(instances);
        return trace;
    }
}

