/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.DFASpec;
import com.ibm.safe.dfa.DFAState;
import com.ibm.safe.dfa.DFATransition;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.IDFATransition;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IEventImpl;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TracePersist {
    public static DFASpec toEMF(IDFA dfa) {
        DFASpec result = new DFASpec();
        IDFAState init = TracePersist.makeStates(dfa, result);
        TracePersist.makeEvents(dfa, result);
        TracePersist.makeTransitions(dfa, result);
        TracePersist.check(dfa, result, init);
        return result;
    }

    private static void makeTransitions(IDFA dfa, DFASpec result) {
        for (Object xObj : dfa) {
            String x = xObj.toString();
            Iterator it2 = dfa.getSuccNodes(xObj);
            while (it2.hasNext()) {
                Object yObj = it2.next();
                String y = yObj.toString();
                Set labels = dfa.getLabels(xObj, yObj);
                for (Object label : labels) {
                    DFATransition t = new DFATransition();
                    t.setDestination(y);
                    t.setSource(x);
                    t.setEvent(label.toString());
                    result.getTransitions().add(t);
                }
            }
        }
    }

    private static void makeEvents(IDFA dfa, DFASpec result) {
        HashSet allEvents = HashSetFactory.make();
        for (Object xObj : dfa) {
            Iterator it2 = dfa.getSuccNodes(xObj);
            while (it2.hasNext()) {
                Object yObj = it2.next();
                Set labels = dfa.getLabels(xObj, yObj);
                for (Object label : labels) {
                    IEvent e = TracePersist.makeEvent(label.toString());
                    allEvents.add(e);
                }
            }
        }
        Iterator it = allEvents.iterator();
        while (it.hasNext()) {
            result.getEvents().add((IEvent)it.next());
        }
        assert (result.getEvents().size() == allEvents.size());
    }

    private static IEvent makeEvent(String label) {
        IEventImpl e = new IEventImpl();
        e.setName(label);
        return e;
    }

    private static IDFAState makeStates(IDFA dfa, DFASpec result) {
        String initial = dfa.getInitialState().toString();
        IDFAState init = TracePersist.makeState(initial);
        result.getStates().add(init);
        for (Object node : dfa) {
            String nodeName = node.toString();
            if (nodeName.equals(initial)) continue;
            IDFAState state = TracePersist.makeState(nodeName);
            result.getStates().add(state);
        }
        return init;
    }

    private static void check(IDFA dfa, DFASpec result, IDFAState init) {
        assert (result.initialState().equals(init));
        assert (result.getStates().size() == dfa.getNumberOfNodes());
    }

    private static IDFAState makeState(String name) {
        DFAState state = new DFAState();
        state.setAccepting(false);
        state.setName(name);
        return state;
    }

    public static IDFA fromEMF(DFASpec dfa) {
        DFA result = new DFA((Object)dfa.initialState().getName());
        for (IDFAState state : dfa.getStates()) {
            result.addNode((Object)state.getName());
        }
        for (IDFATransition t : dfa.getTransitions()) {
            result.addLabeledEdge((Object)t.getSource(), (Object)t.getDestination(), (Object)t.getEvent());
        }
        return result;
    }
}

