/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.safe.typestate.mine.BinaryRelationTestCache;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Iterator;

public class LossLessMerge
implements IMergeFunction {
    private final TypeStateDomain domain;
    private final BinaryRelationTestCache subsetCache = new BinaryRelationTestCache();
    final IBinaryNaturalRelation merged = new BasicNaturalRelation();

    private LossLessMerge(TypeStateDomain domain) {
        this.domain = domain;
    }

    public static LossLessMerge make(TypeStateDomain domain) {
        return new LossLessMerge(domain);
    }

    public int merge(IntSet x, int j) {
        assert (j != 0) : "don't merge 0 please";
        IntIterator it = x.intIterator();
        while (it.hasNext()) {
            int newJ;
            BaseFactoid f_j;
            AbstractHistory t_new;
            AbstractHistory t_j;
            AbstractHistory t_i;
            IntSet supersOfI;
            int i = it.next();
            if (i == 0 || (supersOfI = this.subsetCache.getKnownTrue(i)) != null && x.containsAny(supersOfI) || this.merged.contains(i, j) || this.merged.contains(j, i)) continue;
            this.testSubset(i, j);
            this.testSubset(j, i);
            if (this.subsetCache.isTrue(i, j)) {
                t_i = this.getAbstractHistory(i);
                t_j = this.getAbstractHistory(j);
                t_new = (AbstractHistory)t_j.clone();
                t_new.addCurrentStates(t_i.getCurrentStates());
                f_j = (BaseFactoid)this.domain.getMappedObject(j);
                newJ = this.domain.getIndexForStateDelta(f_j, t_new);
                this.subsetCache.recordTrue(i, newJ);
                this.subsetCache.recordTrue(j, newJ);
                this.merged.add(i, newJ);
                this.merged.add(j, newJ);
                j = newJ;
                if (!x.contains(j)) continue;
                return j;
            }
            if (!this.subsetCache.isTrue(j, i)) continue;
            t_i = this.getAbstractHistory(i);
            t_j = this.getAbstractHistory(j);
            t_new = (AbstractHistory)t_i.clone();
            t_new.addCurrentStates(t_j.getCurrentStates());
            f_j = (BaseFactoid)this.domain.getMappedObject(j);
            newJ = this.domain.getIndexForStateDelta(f_j, t_new);
            this.subsetCache.recordTrue(i, newJ);
            this.subsetCache.recordTrue(j, newJ);
            this.merged.add(i, newJ);
            this.merged.add(j, newJ);
            j = newJ;
            if (!x.contains(j)) continue;
            return j;
        }
        return j;
    }

    private void testSubset(int i, int j) {
        assert (i != j);
        if (this.subsetCache.isTrue(i, j)) {
            return;
        }
        if (this.subsetCache.isFalse(i, j)) {
            return;
        }
        BaseFactoid f_j = (BaseFactoid)this.domain.getMappedObject(j);
        AbstractHistory t_i = this.getAbstractHistory(i);
        AbstractHistory t_j = this.getAbstractHistory(j);
        int test = this.domain.getIndexForStateDelta(f_j, t_i);
        if (test == i) {
            if (this.isSubset(t_i.getDfa(), t_j.getDfa())) {
                this.subsetCache.recordTrue(i, j);
                this.subsetCache.recordFalse(j, i);
            } else {
                this.subsetCache.recordFalse(i, j);
                this.subsetCache.recordTrue(j, i);
            }
        } else {
            this.subsetCache.recordFalse(i, j);
        }
    }

    private boolean isSubset(IDFA a, IDFA b) {
        for (Object x : a) {
            if (!b.containsNode(x)) {
                return false;
            }
            Iterator it2 = a.getSuccNodes(x);
            while (it2.hasNext()) {
                Object y = it2.next();
                if (!b.containsNode(y)) {
                    return false;
                }
                if (a.getLabels(x, y).equals(b.getLabels(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    private AbstractHistory getAbstractHistory(int j) {
        BaseFactoid f_j = (BaseFactoid)this.domain.getMappedObject(j);
        return (AbstractHistory)f_j.state;
    }

    public static IMergeFunctionFactory factory() {
        return new IMergeFunctionFactory(){

            @Override
            public IMergeFunction create(MutableMapping domain) {
                if (!$assertionsDisabled && !(domain instanceof TypeStateDomain)) {
                    throw new AssertionError();
                }
                return new LossLessMerge((TypeStateDomain)domain, null);
            }
        };
    }

    /* synthetic */ LossLessMerge(TypeStateDomain typeStateDomain, LossLessMerge lossLessMerge) {
        this(typeStateDomain);
    }
}

