/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HistoryStateMerger {
    private static HistoryStateMerger theInstance;

    public static HistoryStateMerger getInstance() {
        if (theInstance == null) {
            theInstance = new HistoryStateMerger();
        }
        return theInstance;
    }

    public AbstractHistory flatten(AbstractHistory history, IDFAStateFactory stateFactory) {
        return this.mergeStates(history, stateFactory);
    }

    protected AbstractHistory mergeStates(AbstractHistory history, IDFAStateFactory stateFactory) {
        HashMap partitionMap = HashMapFactory.make();
        HashSet partition = HashSetFactory.make();
        IDFA dfa = history.getDfa();
        Collection<Object> cut = history.getCurrentStates();
        Collection reachable = DFS.getReachableNodes((Graph)dfa, Collections.singleton(dfa.getInitialState()), (Predicate)IndiscriminateFilter.singleton());
        Set<Pair> equivalence = this.computeEquivalence(dfa, reachable, cut);
        HashSet ignoreSet = HashSetFactory.make();
        Collection<Object> currStates = history.getCurrentStates();
        HashSet current = HashSetFactory.make();
        for (Object src : reachable) {
            if (ignoreSet.contains(src)) continue;
            boolean currFlag = false;
            HashSet nodeSet = HashSetFactory.make();
            nodeSet.add(src);
            partitionMap.put(src, nodeSet);
            if (currStates.contains(src)) {
                currFlag = true;
            }
            for (Object dest : reachable) {
                if (dest == src || !equivalence.contains(Pair.make(src, dest))) continue;
                nodeSet.add(dest);
                ignoreSet.add(dest);
                partitionMap.put(dest, nodeSet);
                if (!currStates.contains(dest)) continue;
                currFlag = true;
                current.add(nodeSet);
            }
            partition.add(nodeSet);
            if (!currFlag) continue;
            current.add(nodeSet);
        }
        return this.constructNewHistory(history, partitionMap, partition, current, stateFactory);
    }

    protected AbstractHistory constructNewHistory(AbstractHistory history, Map<Object, Set> partitionMap, Set<Set> partition, Set<Set> current, IDFAStateFactory stateFactory) {
        Object newState;
        HashMap classes2states = HashMapFactory.make();
        IDFA dfa = history.getDfa();
        HashSet resultCurrentStates = HashSetFactory.make();
        Set initialClass = partitionMap.get(dfa.getInitialState());
        Object newInitState = stateFactory.createState((Object)initialClass.toString());
        classes2states.put(initialClass, newInitState);
        if (current.contains(initialClass)) {
            resultCurrentStates.add(newInitState);
        }
        DFA resultDFA = new DFA(newInitState);
        for (Set stateClass : partition) {
            if (stateClass == initialClass) continue;
            newState = stateFactory.createState((Object)stateClass.toString());
            resultDFA.addNode(newState, false);
            classes2states.put(stateClass, newState);
            if (!current.contains(stateClass)) continue;
            resultCurrentStates.add(newState);
        }
        for (Set stateClass : partition) {
            newState = classes2states.get(stateClass);
            for (Object state : stateClass) {
                for (Object label : dfa.alphabet()) {
                    Object successor = dfa.successor(state, label);
                    if (successor == null) continue;
                    Set succStateClass = partitionMap.get(successor);
                    Object succNewState = classes2states.get(succStateClass);
                    resultDFA.addLabeledEdge(newState, succNewState, label);
                }
            }
        }
        return new AbstractHistory((IDFA)resultDFA, resultCurrentStates, history.getMerger());
    }

    public Set<Pair> computeEquivalence(IDFA dfa, Collection<Object> reachable, Collection toMerge) {
        IntegerUnionFind equivUF = new IntegerUnionFind();
        MutableMapping states = MutableMapping.make();
        boolean first = true;
        int mergeRep = 0;
        for (Object state : reachable) {
            int i = states.add(state);
            if (!toMerge.contains(state)) continue;
            if (first) {
                first = false;
                mergeRep = i;
                continue;
            }
            equivUF.union(mergeRep, i);
        }
        boolean changedUF = false;
        do {
            changedUF = false;
            for (Object state1 : reachable) {
                for (Object state2 : reachable) {
                    if (state1 == state2 || equivUF.find(states.getMappedIndex(state1)) != equivUF.find(states.getMappedIndex(state2))) continue;
                    for (Object label : dfa.alphabet()) {
                        int class2;
                        int class1;
                        Object nextDest1 = dfa.successor(state1, label);
                        Object nextDest2 = dfa.successor(state2, label);
                        if (nextDest1 == null || nextDest2 == null || (class1 = equivUF.find(states.getMappedIndex(nextDest1))) == (class2 = equivUF.find(states.getMappedIndex(nextDest2)))) continue;
                        equivUF.union(class1, class2);
                        changedUF = true;
                    }
                }
            }
        } while (changedUF);
        HashSet equivPairs = HashSetFactory.make();
        for (Object state1 : reachable) {
            for (Object state2 : reachable) {
                if (state1 == state2 || equivUF.find(states.getMappedIndex(state1)) != equivUF.find(states.getMappedIndex(state2))) continue;
                equivPairs.add(Pair.make((Object)state1, (Object)state2));
            }
        }
        return equivPairs;
    }
}

