/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.mine;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.safe.typestate.merge.AbstractUnification;
import com.ibm.safe.typestate.merge.FutureMerge;
import com.ibm.safe.typestate.mine.EventFilter;
import com.ibm.safe.typestate.mine.EventNameStateFactory;
import com.ibm.safe.typestate.mine.HistoryState;
import com.ibm.safe.typestate.mine.UniqueNameStateFactory;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class AbstractHistory
implements IDFAState,
Cloneable {
    private static final int DEBUG_LEVEL = 0;
    public static final String ABSTRACT_HISTORY_INIT = "AH.init";
    private static final boolean EXTRA_CONTEXT = false;
    private static final String EXTRA_CONTEXT_EVENT = null;
    private IDFA dfa;
    private Collection<Object> currentStates;
    private boolean exit = false;
    private int hashCode;
    private AbstractUnification merger;
    private IDFAStateFactory stateFactory;
    private static int debugCounter = 0;
    private static int counter = 0;

    public AbstractHistory(AbstractUnification merger) {
        this.merger = merger;
        this.stateFactory = merger != null ? merger.getStateFactory() : EventNameStateFactory.getInstance();
        Object initState = this.stateFactory.createState((Object)ABSTRACT_HISTORY_INIT);
        this.initialize((IDFA)new DFA(initState), Collections.singleton(initState), merger);
    }

    public AbstractHistory(IDFA dfa, Collection<Object> currentStates, AbstractUnification merger) {
        this.merger = merger;
        this.stateFactory = merger != null ? merger.getStateFactory() : EventNameStateFactory.getInstance();
        this.initialize(dfa, currentStates, merger);
    }

    private void initialize(IDFA dfa, Collection<Object> currentStates, AbstractUnification merger) {
        this.dfa = dfa;
        this.currentStates = HashSetFactory.make();
        this.currentStates.addAll(currentStates);
        this.updateHashCode();
    }

    public String getName() {
        return "AbstractHistory";
    }

    public boolean isAccepting() {
        return this.exit;
    }

    public AbstractHistory extend(String event) {
        if (this.shouldIgnore(event)) {
            return this;
        }
        if (this.merger != null && this.merger instanceof FutureMerge) {
            DFA resultDFA = (DFA)this.dfa.clone();
            HashSet resultCurrStates = HashSetFactory.make();
            assert (this.currentStates.size() == 1) : "extend: expects exactly one current state in future merge";
            Object currObj = this.currentStates.iterator().next();
            assert (resultDFA.successor(currObj, (Object)event) == null) : "extend: expects current state to be a sink state in future merge";
            Object nextState = this.stateFactory.createState((Object)event);
            resultDFA.addNode(nextState);
            resultDFA.addLabeledEdge(currObj, nextState, (Object)event);
            resultCurrStates.add(nextState);
            AbstractHistory result = new AbstractHistory((IDFA)resultDFA, resultCurrStates, this.merger);
            result = ((FutureMerge)this.merger).beta(result);
            return result;
        }
        if (this.extendWouldBeNoOp(event)) {
            return this;
        }
        AbstractHistory result = new AbstractHistory(this.merger);
        result.dfa = (DFA)this.dfa.clone();
        result.currentStates.clear();
        for (Object currObj : this.currentStates) {
            String extended_event;
            HistoryState curr = (HistoryState)currObj;
            Object nextState = result.dfa.successor((Object)curr, (Object)(extended_event = event));
            if (nextState == null) {
                nextState = this.stateFactory.createState((Object)extended_event);
                result.dfa.addNode(nextState);
                result.dfa.addLabeledEdge((Object)curr, nextState, (Object)extended_event);
            }
            result.currentStates.add(nextState);
        }
        result.updateHashCode();
        return result;
    }

    private boolean shouldIgnore(String event) {
        return EventFilter.shouldIgnore(event);
    }

    private Collection getIncomingEvents(HistoryState curr) {
        HashSet result = HashSetFactory.make();
        Iterator predIt = this.dfa.getPredNodes((Object)curr);
        while (predIt.hasNext()) {
            Object pred = predIt.next();
            for (Pair currLabel : this.dfa.getLabels(pred, (Object)curr)) {
                result.add(currLabel.snd);
            }
        }
        return result;
    }

    private boolean extendWouldBeNoOp(String event) {
        if (this.currentStates.size() != 1) {
            return false;
        }
        Object state = this.currentStates.iterator().next();
        Object next = this.dfa.successor(state, (Object)event);
        if (next == null) {
            return false;
        }
        return state.equals(next);
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this == arg0) {
            return true;
        }
        if (!this.getClass().equals(arg0.getClass())) {
            return false;
        }
        AbstractHistory other = (AbstractHistory)arg0;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.stateFactory instanceof UniqueNameStateFactory) {
            return this.isIsomorphic(other);
        }
        return this.currentStates.equals(other.currentStates) && this.dfa.equals(other.dfa);
    }

    public boolean isIsomorphic(AbstractHistory t_i) {
        IDFA dfa_j = this.getDfa();
        IDFA dfa_i = t_i.getDfa();
        Collection<Object> currentStates_j = this.getCurrentStates();
        Collection<Object> currentStates_i = t_i.getCurrentStates();
        if (currentStates_j.contains(dfa_j.getInitialState()) != currentStates_i.contains(dfa_i.getInitialState())) {
            return false;
        }
        if (!dfa_j.alphabet().equals(dfa_i.alphabet())) {
            return false;
        }
        LinkedList<Pair> workList = new LinkedList<Pair>();
        HashSet explored = HashSetFactory.make();
        Pair origStatesPair = Pair.make((Object)dfa_j.getInitialState(), (Object)dfa_i.getInitialState());
        workList.add(origStatesPair);
        while (!workList.isEmpty()) {
            origStatesPair = (Pair)workList.remove(0);
            for (Object label : dfa_i.alphabet()) {
                Object nextDest_i;
                Object nextDest_j = dfa_j.successor(origStatesPair.fst, label);
                if (nextDest_j == null != ((nextDest_i = dfa_i.successor(origStatesPair.snd, label)) == null)) {
                    return false;
                }
                if (nextDest_j == null && nextDest_i == null) continue;
                if (currentStates_j.contains(nextDest_j) != currentStates_i.contains(nextDest_i)) {
                    return false;
                }
                Pair nextPair = Pair.make((Object)nextDest_j, (Object)nextDest_i);
                if (explored.contains(nextPair)) continue;
                workList.add(nextPair);
                explored.add(nextPair);
            }
        }
        return true;
    }

    private void updateHashCode() {
        this.hashCode = this.dfa.getNumberOfNodes() + 31 * this.dfa.getNumberOfLabels();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "AbstractHistory\ncurrent states:" + this.currentStates + "\nDFA:\n" + this.dfa.toString();
    }

    public AbstractHistory exit() {
        AbstractHistory result = new AbstractHistory(this.merger);
        result.dfa = (DFA)this.dfa.clone();
        result.currentStates = new HashSet<Object>(this.currentStates);
        result.exit = true;
        return result;
    }

    public IDFA getDfa() {
        return this.dfa;
    }

    public Object clone() {
        AbstractHistory result = new AbstractHistory(this.merger);
        result.dfa = (DFA)this.dfa.clone();
        result.currentStates = new HashSet<Object>(this.currentStates);
        result.updateHashCode();
        return result;
    }

    public Collection<Object> getCurrentStates() {
        return Collections.unmodifiableCollection(this.currentStates);
    }

    public void addCurrentStates(Collection<Object> newStates) {
        this.currentStates.addAll(newStates);
        this.updateHashCode();
    }

    public void extend(AbstractHistory t) {
        Iterator it = t.dfa.iterator();
        while (it.hasNext()) {
            this.dfa.addNode(it.next());
        }
        for (Object x : t.dfa) {
            Iterator it2 = t.dfa.getSuccNodes(x);
            while (it2.hasNext()) {
                Object y = it2.next();
                Set labels = t.dfa.getLabels(x, y);
                this.dfa.addLabeledEdges(x, y, (Collection)labels);
            }
        }
        this.currentStates.addAll(t.currentStates);
        this.updateHashCode();
    }

    public AbstractHistory historyCartesianProduct(AbstractHistory t_i) {
        HashMap statesMap = HashMapFactory.make();
        HashSet currentStates = HashSetFactory.make();
        IDFA dfa_j = this.getDfa();
        Collection<Object> currentStates_j = this.getCurrentStates();
        IDFA dfa_i = t_i.getDfa();
        Collection<Object> currentStates_i = t_i.getCurrentStates();
        Pair origStatesPair = Pair.make((Object)dfa_j.getInitialState(), (Object)dfa_i.getInitialState());
        Object newState = this.stateFactory.createState((Object)origStatesPair.toString());
        statesMap.put(origStatesPair, newState);
        DFA mergedDFA = new DFA(newState);
        if (currentStates_j.contains(dfa_j.getInitialState()) || currentStates_i.contains(dfa_i.getInitialState())) {
            currentStates.add(newState);
        }
        LinkedList<Pair> toExplore = new LinkedList<Pair>();
        toExplore.add(Pair.make((Object)origStatesPair, (Object)newState));
        while (!toExplore.isEmpty()) {
            Pair current = (Pair)toExplore.remove(0);
            origStatesPair = (Pair)current.fst;
            newState = current.snd;
            HashSet unionAlphabet = HashSetFactory.make();
            unionAlphabet.addAll(dfa_i.alphabet());
            unionAlphabet.addAll(dfa_j.alphabet());
            for (Object label : unionAlphabet) {
                Object nextDest_j = null;
                Object nextDest_i = null;
                if (origStatesPair.fst != null) {
                    nextDest_j = dfa_j.successor(origStatesPair.fst, label);
                }
                if (origStatesPair.snd != null) {
                    nextDest_i = dfa_i.successor(origStatesPair.snd, label);
                }
                if (nextDest_j == null && nextDest_i == null) continue;
                Pair nextPair = Pair.make((Object)nextDest_j, nextDest_i);
                Object nextState = statesMap.get(nextPair);
                if (nextState == null) {
                    nextState = this.stateFactory.createState((Object)nextPair.toString());
                    mergedDFA.addNode(nextState);
                    statesMap.put(nextPair, nextState);
                    toExplore.add(Pair.make((Object)nextPair, nextState));
                    if (currentStates_j.contains(nextDest_j) || currentStates_i.contains(nextDest_i)) {
                        currentStates.add(nextState);
                    }
                }
                mergedDFA.addLabeledEdge(newState, nextState, label);
            }
        }
        return new AbstractHistory((IDFA)mergedDFA, currentStates, this.merger);
    }

    public AbstractUnification getMerger() {
        return this.merger;
    }

    public void setAccepting(boolean value) {
    }

    public void setName(String value) {
    }
}

