/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.metrics;

import com.ibm.safe.metrics.IMetrics;
import com.ibm.safe.metrics.IntHistogram;
import com.ibm.safe.typestate.metrics.CallGraphMetricsByLoader;
import com.ibm.safe.typestate.metrics.TypeStateMetricsByLoader;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class TypeStateMetrics
implements IMetrics {
    private final Map<ClassLoaderReference, TypeStateMetricsByLoader> callGraphMetrics = HashMapFactory.make((int)3);
    private final Map<ClassLoaderReference, TypeStateMetricsByLoader> chaMetrics = HashMapFactory.make((int)3);
    private final Map<String, Integer> candidateStatements = HashMapFactory.make((int)10);
    private final Map<String, Integer> DFAcandidateStatements = HashMapFactory.make((int)10);
    private int unoptimizedSupergraphSize;
    private final IntHistogram supergraphSizes = new IntHistogram();

    public TypeStateMetrics(IClassHierarchy classHierarchy, CallGraph callGraph) {
        assert (classHierarchy != null);
        assert (callGraph != null);
        this.chaMetrics.put(ClassLoaderReference.Primordial, this.compute(classHierarchy, ClassLoaderReference.Primordial));
        this.chaMetrics.put(ClassLoaderReference.Extension, this.compute(classHierarchy, ClassLoaderReference.Extension));
        this.chaMetrics.put(ClassLoaderReference.Application, this.compute(classHierarchy, ClassLoaderReference.Application));
        this.callGraphMetrics.put(ClassLoaderReference.Primordial, this.compute(callGraph, ClassLoaderReference.Primordial));
        this.callGraphMetrics.put(ClassLoaderReference.Extension, this.compute(callGraph, ClassLoaderReference.Extension));
        this.callGraphMetrics.put(ClassLoaderReference.Application, this.compute(callGraph, ClassLoaderReference.Application));
    }

    public CallGraphMetricsByLoader getCallGraphMetrics(ClassLoaderReference classLoaderRef) {
        return (CallGraphMetricsByLoader)this.callGraphMetrics.get(classLoaderRef);
    }

    public TypeStateMetricsByLoader getCHAMetrics(ClassLoaderReference classLoaderRef) {
        return this.chaMetrics.get(classLoaderRef);
    }

    private CallGraphMetricsByLoader compute(CallGraph callGraph, ClassLoaderReference classLoaderRef) {
        HashSet methods = HashSetFactory.make();
        HashSet classes = HashSetFactory.make();
        long byteCodeStatements = 0L;
        long cgNodes = 0L;
        Iterator iter = callGraph.iterator();
        while (iter.hasNext()) {
            IMethod method = ((CGNode)iter.next()).getMethod();
            if (!method.getDeclaringClass().getReference().getClassLoader().equals((Object)classLoaderRef)) continue;
            if (!methods.contains(method)) {
                methods.add(method);
                cgNodes += (long)callGraph.getNodes(method.getReference()).size();
                if (method instanceof ShrikeCTMethod) {
                    byteCodeStatements += this.countStatements(method);
                }
            }
            classes.add(method.getDeclaringClass());
        }
        return new CallGraphMetricsByLoader(byteCodeStatements, classes.size(), methods.size(), cgNodes, classLoaderRef.getName().toString());
    }

    private TypeStateMetricsByLoader compute(IClassHierarchy classHierarchy, ClassLoaderReference classLoaderRef) {
        IClassLoader classLoader = classHierarchy.getLoader(classLoaderRef);
        long numberOfClasses = 0L;
        long numberOfMethods = 0L;
        long byteCodeStatements = 0L;
        Iterator iter = classLoader.iterateAllClasses();
        while (iter.hasNext()) {
            IClass clazz = (IClass)iter.next();
            ++numberOfClasses;
            for (IMethod method : clazz.getDeclaredMethods()) {
                ++numberOfMethods;
                if (!(method instanceof ShrikeCTMethod)) continue;
                byteCodeStatements += this.countStatements(method);
            }
        }
        return new TypeStateMetricsByLoader(byteCodeStatements, numberOfClasses, numberOfMethods, classLoaderRef.getName().toString());
    }

    /*
     * Unable to fully structure code
     */
    private long countStatements(IMethod method) {
        bcStream = ((ShrikeCTMethod)method).getBytecodeStream();
        count = 0L;
        if (bcStream != null) ** GOTO lbl8
        return 0L;
lbl-1000:
        // 1 sources

        {
            bcStream.nextInstruction();
            ++count;
lbl8:
            // 2 sources

            ** while (bcStream.hasMoreBytecodes())
        }
lbl9:
        // 1 sources

        return count;
    }

    public void setNumberOfCandidateStatements(String propertyName, int n) {
        int old = this.getNumberOfCandidateStatements(propertyName);
        if (old > -1) assert (old == n);
        this.candidateStatements.put(propertyName, n);
    }

    public int getNumberOfCandidateStatements(String propertyName) {
        Integer n = this.candidateStatements.get(propertyName);
        return n == null ? -1 : n;
    }

    public void setNumberOfDFASliceCandidateStatements(String propertyName, int n) {
        int old = this.getNumberOfDFASliceCandidateStatements(propertyName);
        if (old > -1) assert (old == n);
        this.DFAcandidateStatements.put(propertyName, n);
    }

    public int getNumberOfDFASliceCandidateStatements(String propertyName) {
        Integer n = this.DFAcandidateStatements.get(propertyName);
        return n == null ? -1 : n;
    }

    public Iterator<String> getPropertyNames() {
        return this.candidateStatements.keySet().iterator();
    }

    public int getUnoptimizedSupergraphSize() {
        return this.unoptimizedSupergraphSize;
    }

    public void setUnoptimizedSupergraphSize(int unoptimizedSupergraphSize) {
        this.unoptimizedSupergraphSize = unoptimizedSupergraphSize;
    }

    public void recordSupergraphSize(int numberOfNodes) {
        this.supergraphSizes.add(numberOfNodes, 1);
    }

    public Iterator getSupergraphSizes() {
        return this.supergraphSizes.iterator();
    }
}

