/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.merge;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.merge.AbstractUnification;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.safe.typestate.mine.UniqueNameStateFactory;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FutureMerge
extends AbstractUnification {
    private static final int DEBUG_LEVEL = 0;
    private static int combineCount = 0;
    private static String DEBUG_OUTDIR = "C:/temp/master/";

    private FutureMerge(TypeStateDomain domain) {
        super(domain);
        this.stateFactory = UniqueNameStateFactory.getInstance();
    }

    public int merge(IntSet x, int j) {
        assert (j != 0) : "don't merge 0 please";
        int jrep = this.uf.find(j);
        BaseFactoid f_j = this.getRepresentativeFactoid(jrep);
        AbstractHistory t_j = (AbstractHistory)f_j.state;
        if (t_j.getCurrentStates().contains(t_j.getDfa().getInitialState())) {
            return this.getRealRepresentative(jrep);
        }
        IDFA dfa_j = t_j.getDfa();
        HashSet initLabels_j = HashSetFactory.make();
        Iterator lIt = dfa_j.getSuccNodes(dfa_j.getInitialState());
        while (lIt.hasNext()) {
            initLabels_j.addAll(dfa_j.getLabels(dfa_j.getInitialState(), lIt.next()));
        }
        BitVectorIntSet reps = new BitVectorIntSet();
        reps.add(jrep);
        IntIterator it = x.intIterator();
        while (it.hasNext()) {
            int test;
            AbstractHistory t_r;
            int r;
            int i = it.next();
            if (i == 0 || reps.contains(r = this.uf.find(i)) || (t_r = (AbstractHistory)this.getRepresentativeFactoid((int)r).state).getCurrentStates().contains(t_r.getDfa().getInitialState()) || (test = this.getDomain().getIndexForStateDelta(f_j, t_r)) != this.getRealRepresentative(r)) continue;
            IDFA dfa_r = t_r.getDfa();
            for (Object label : dfa_r.alphabet()) {
                if (dfa_r.successor(dfa_r.getInitialState(), label) == null || !initLabels_j.contains(label)) continue;
                reps.add(r);
            }
        }
        return this.unify((IntSet)reps, jrep);
    }

    @Override
    protected int unify(IntSet reps, int jrep) {
        AbstractHistory t_i;
        int i;
        if (reps.size() == 1) {
            return this.getRealRepresentative(jrep);
        }
        Object resultInitState = this.stateFactory.createState((Object)"init");
        DFA resultDFA = new DFA(resultInitState);
        Object resultCurrState = this.stateFactory.createState((Object)"curr");
        resultDFA.addNode(resultCurrState);
        HashSet resultCurrentStates = HashSetFactory.make();
        resultCurrentStates.add(resultCurrState);
        HashMap label2state = HashMapFactory.make();
        IntIterator it = reps.intIterator();
        while (it.hasNext()) {
            i = it.next();
            t_i = (AbstractHistory)this.getRepresentativeFactoid((int)i).state;
            this.mapLabelsOfInitialState(t_i.getDfa(), label2state, resultInitState);
        }
        it = reps.intIterator();
        while (it.hasNext()) {
            i = it.next();
            t_i = (AbstractHistory)this.getRepresentativeFactoid((int)i).state;
            this.updateFlattenedHistory(t_i, (IDFA)resultDFA, resultCurrState, label2state);
        }
        BaseFactoid f_j = this.getRepresentativeFactoid(jrep);
        AbstractHistory resultAbstractHistory = new AbstractHistory((IDFA)resultDFA, resultCurrentStates, ((AbstractHistory)f_j.state).getMerger());
        int newJ = this.getDomain().getIndexForStateDelta(f_j, resultAbstractHistory);
        int newRep = this.uf.find(newJ);
        this.rep2Last.set(newRep, newJ);
        return newJ;
    }

    private void mapLabelsOfInitialState(IDFA dfa, Map<String, Object> label2state, Object resultInitState) {
        Object init_i = dfa.getInitialState();
        Iterator succIt = dfa.getSuccNodes(init_i);
        while (succIt.hasNext()) {
            Object succ = succIt.next();
            Set labels = dfa.getLabels(init_i, succ);
            for (String label : labels) {
                if (label.endsWith("$")) continue;
                label2state.put(label, resultInitState);
            }
        }
    }

    private void updateFlattenedHistory(AbstractHistory history, IDFA resultDFA, Object resultCurrState, Map<String, Object> label2state) {
        IDFA dfa = history.getDfa();
        HashMap stateMap = HashMapFactory.make();
        for (Object state : dfa) {
            Object newState;
            if (history.getCurrentStates().contains(state)) {
                stateMap.put(state, resultCurrState);
                continue;
            }
            String label = (String)dfa.getLabels(state, dfa.getSuccNodes(state).next()).iterator().next();
            if (label.endsWith("$")) {
                label = label.substring(0, label.indexOf("$"));
            }
            if ((newState = label2state.get(label)) == null) {
                newState = this.stateFactory.createState((Object)label);
                resultDFA.addNode(newState);
                label2state.put(label, newState);
            }
            stateMap.put(state, newState);
        }
        this.constructFlattenedDFAEdges(dfa, resultDFA, stateMap);
    }

    public AbstractHistory beta(AbstractHistory history) {
        IDFA dfa = history.getDfa();
        Object initState = dfa.getInitialState();
        Object currState = history.getCurrentStates().iterator().next();
        if (currState == initState) {
            return history;
        }
        DFA resultDFA = new DFA(initState);
        resultDFA.addNode(currState);
        HashSet resultCurrentStates = HashSetFactory.make();
        resultCurrentStates.add(currState);
        HashMap stateMap = HashMapFactory.make();
        stateMap.put(initState, initState);
        stateMap.put(currState, currState);
        HashMap label2state = HashMapFactory.make();
        this.mapLabelsOfInitialState(dfa, label2state, initState);
        for (Object state : dfa) {
            Object newState;
            if (state == currState || state == initState) continue;
            String label = (String)dfa.getLabels(state, dfa.getSuccNodes(state).next()).iterator().next();
            if (label.endsWith("$")) {
                label = label.substring(0, label.indexOf("$"));
            }
            if ((newState = label2state.get(label)) == null) {
                newState = state;
                resultDFA.addNode(newState);
                label2state.put(label, newState);
            }
            stateMap.put(state, newState);
        }
        this.constructFlattenedDFAEdges(dfa, (IDFA)resultDFA, stateMap);
        return new AbstractHistory((IDFA)resultDFA, resultCurrentStates, history.getMerger());
    }

    private void constructFlattenedDFAEdges(IDFA dfa, IDFA resultDFA, Map<Object, Object> stateMap) {
        for (Object state : dfa) {
            Object newState = stateMap.get(state);
            assert (newState != null) : "flattening: all states should be mapped to new states";
            Iterator succIt = dfa.getSuccNodes(state);
            while (succIt.hasNext()) {
                Object succ = succIt.next();
                Object newSucc = stateMap.get(succ);
                assert (newSucc != null) : "flattening: all states should be mapped to new states";
                for (String label : dfa.getLabels(state, succ)) {
                    if (label.endsWith("$")) {
                        label = label.substring(0, label.indexOf("$"));
                    }
                    Object currSucc = null;
                    do {
                        if ((currSucc = resultDFA.successor(newState, (Object)label)) == null) {
                            resultDFA.addLabeledEdge(newState, newSucc, (Object)label);
                            currSucc = newSucc;
                            continue;
                        }
                        label = label.concat("$");
                    } while (currSucc != newSucc);
                }
            }
        }
    }

    public static IMergeFunctionFactory factory() {
        return new IMergeFunctionFactory(){

            @Override
            public IMergeFunction create(MutableMapping domain) {
                if (!$assertionsDisabled && !(domain instanceof TypeStateDomain)) {
                    throw new AssertionError();
                }
                return new FutureMerge((TypeStateDomain)domain, null);
            }
        };
    }

    /* synthetic */ FutureMerge(TypeStateDomain typeStateDomain, FutureMerge futureMerge) {
        this(typeStateDomain);
    }
}

