/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.merge;

import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.mine.AbstractHistory;
import com.ibm.safe.typestate.mine.EventNameStateFactory;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.SimpleIntVector;

public abstract class AbstractUnification
implements IMergeFunction {
    private final TypeStateDomain domain;
    protected IDFAStateFactory stateFactory;
    protected final IntegerUnionFind uf = new IntegerUnionFind();
    final SimpleIntVector rep2Last = new SimpleIntVector(-1);

    protected AbstractUnification(TypeStateDomain domain) {
        this.domain = domain;
        this.stateFactory = EventNameStateFactory.getInstance();
    }

    protected final int getRealRepresentative(int x) {
        int rep = this.uf.find(x);
        rep = this.rep2Last.get(x);
        return rep == -1 ? x : rep;
    }

    protected final BaseFactoid getRepresentativeFactoid(int x) {
        int rep = this.uf.find(x);
        rep = this.rep2Last.get(x);
        return rep == -1 ? (BaseFactoid)this.domain.getMappedObject(x) : (BaseFactoid)this.domain.getMappedObject(rep);
    }

    protected TypeStateDomain getDomain() {
        return this.domain;
    }

    protected int unify(IntSet reps, int jrep) {
        assert (jrep != 0);
        if (reps.size() == 1) {
            return this.getRealRepresentative(jrep);
        }
        AbstractHistory t_jrep = (AbstractHistory)this.getRepresentativeFactoid((int)jrep).state;
        AbstractHistory t_merged = (AbstractHistory)t_jrep.clone();
        IntIterator it = reps.intIterator();
        while (it.hasNext()) {
            int i = it.next();
            if (i == jrep) continue;
            AbstractHistory t_i = (AbstractHistory)this.getRepresentativeFactoid((int)i).state;
            t_merged.extend(t_i);
            this.uf.union(i, jrep);
        }
        BaseFactoid f_j = this.getRepresentativeFactoid(jrep);
        int newJ = this.getDomain().getIndexForStateDelta(f_j, t_merged);
        this.uf.union(jrep, newJ);
        int newRep = this.uf.find(newJ);
        this.rep2Last.set(newRep, newJ);
        return newJ;
    }

    public IDFAStateFactory getStateFactory() {
        return this.stateFactory;
    }
}

