/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.local;

import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.core.TypeStateFunctionProvider;
import com.ibm.safe.typestate.local.UnionFlowFunction;
import com.ibm.safe.typestate.quad.AggregateFlowFunction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class SingleProcedureFlowFunctions
implements IFlowFunctionMap<BasicBlockInContext<IExplodedBasicBlock>> {
    private final CGNode node;
    private final ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg;
    private final TypeStateFunctionProvider delegate;
    private final Collection<CGNode> nodesThatMatter;
    private final Collection<InstanceKey> instances;
    private final ILiveObjectAnalysis live;
    private final CallGraph cg;

    public SingleProcedureFlowFunctions(CGNode node, ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg, TypeStateFunctionProvider delegate, Collection<CGNode> nodesThatMatter, Collection<InstanceKey> instances, ILiveObjectAnalysis live, CallGraph cg) {
        this.node = node;
        this.cfg = cfg;
        this.delegate = delegate;
        this.nodesThatMatter = nodesThatMatter;
        this.instances = instances;
        this.live = live;
        this.cg = cg;
    }

    public IUnaryFlowFunction getNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (((IExplodedBasicBlock)src.getDelegate()).equals(this.cfg.entry())) {
            if (this.anyInstanceMayBeLiveInCaller()) {
                return AggregateFlowFunction.compose(this.makeWorstCaseFlowFunction(), this.delegate.getNormalFlowFunction(src, dest));
            }
            return this.delegate.getNormalFlowFunction(src, dest);
        }
        return this.delegate.getNormalFlowFunction(src, dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean anyInstanceMayBeLiveInCaller() {
        try {
            Iterator<InstanceKey> it = this.instances.iterator();
            block2: while (true) {
                CGNode p;
                if (!it.hasNext()) {
                    return false;
                }
                InstanceKey ik = it.next();
                if (!(ik instanceof AllocationSiteInNode)) {
                    return true;
                }
                AllocationSiteInNode ak = (AllocationSiteInNode)ik;
                Iterator it2 = this.delegate.getCallGraph().getPredNodes((Object)this.node);
                do {
                    if (!it2.hasNext()) continue block2;
                } while (!this.live.mayBeLive((InstanceKey)ak, p = (CGNode)it2.next(), -1));
                break;
            }
            return true;
        }
        catch (WalaException e) {
            e.printStackTrace();
            return true;
        }
    }

    public IUnaryFlowFunction getCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IFlowFunction getReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IUnaryFlowFunction getCallToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IUnaryFlowFunction getCallNoneToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (this.hasCalleeThatMatters(src)) {
            return this.makeCallFlow(src);
        }
        return IdentityFlowFunction.identity();
    }

    private IUnaryFlowFunction makeCallFlow(BasicBlockInContext<IExplodedBasicBlock> call) {
        Collection<CGNode> callees = this.getCalleesThatMatter(call);
        assert (callees.size() > 0);
        IUnaryFlowFunction result = null;
        for (CGNode callee : callees) {
            IUnaryFlowFunction f;
            IEvent event = this.delegate.getEventForNode(callee);
            if (event == null) {
                f = this.makeWorstCaseFlowFunction();
                result = result == null ? f : UnionFlowFunction.union(result, f);
                continue;
            }
            f = this.makeEventFlowFunction(event, call, callee);
            IUnaryFlowFunction iUnaryFlowFunction = result = result == null ? f : UnionFlowFunction.union(result, f);
        }
        if (this.hasCalleeThatDoesNotMatter(call)) {
            result = UnionFlowFunction.union(result, (IUnaryFlowFunction)IdentityFlowFunction.identity());
        }
        return result;
    }

    protected abstract IUnaryFlowFunction makeEventFlowFunction(IEvent var1, BasicBlockInContext<IExplodedBasicBlock> var2, CGNode var3);

    protected abstract IUnaryFlowFunction makeWorstCaseFlowFunction();

    private Collection<CGNode> getCalleesThatMatter(BasicBlockInContext<IExplodedBasicBlock> call) {
        SSAInvokeInstruction s = TypeStateFunctionProvider.getLastCallInstruction(this.cfg, call);
        HashSet result = HashSetFactory.make((int)3);
        for (CGNode n : this.cg.getPossibleTargets(this.node, s.getCallSite())) {
            if (!this.nodesThatMatter.contains(n)) continue;
            result.add(n);
        }
        return result;
    }

    private boolean hasCalleeThatMatters(BasicBlockInContext<IExplodedBasicBlock> callBlock) {
        SSAInvokeInstruction s = TypeStateFunctionProvider.getLastCallInstruction(this.cfg, callBlock);
        Iterator it = this.cg.getPossibleTargets(this.node, s.getCallSite()).iterator();
        while (it.hasNext()) {
            if (!this.nodesThatMatter.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasCalleeThatDoesNotMatter(BasicBlockInContext<IExplodedBasicBlock> callBlock) {
        SSAInvokeInstruction s = TypeStateFunctionProvider.getLastCallInstruction(this.cfg, callBlock);
        Iterator it = this.cg.getPossibleTargets(this.node, s.getCallSite()).iterator();
        while (it.hasNext()) {
            if (this.nodesThatMatter.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    protected TypeStateFunctionProvider getDelegate() {
        return this.delegate;
    }

    protected Collection<InstanceKey> getInstances() {
        return this.instances;
    }

    protected CGNode getNode() {
        return this.node;
    }

    protected ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCfg() {
        return this.cfg;
    }
}

