/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.local;

import com.ibm.safe.Factoid;
import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.internal.exceptions.MaxFindingsException;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.exceptions.SolverTimeoutException;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.typestate.core.AbstractTypestateSolver;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateFunctionProvider;
import com.ibm.safe.typestate.core.TypeStateMessage;
import com.ibm.safe.typestate.core.TypeStateProblem;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.TypeStateResult;
import com.ibm.safe.typestate.local.LocalSolverResult;
import com.ibm.safe.typestate.local.SingleProcedureSupergraph;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.ExplodedControlFlowGraph;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractLocalSolver
extends AbstractTypestateSolver {
    private final Map<InstanceKey, Collection<CGNode>> nodesThatMatter = HashMapFactory.make();

    public AbstractLocalSolver(CallGraph cg, PointerAnalysis pointerAnalysis, TypeStateProperty property, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, IMergeFunctionFactory mergeFunctionFactory) {
        super(cg, pointerAnalysis, property, options, live, ora, metrics, reporter, mergeFunctionFactory);
    }

    protected Collection<CGNode> getNodesThatMatter(Collection<InstanceKey> instances) throws PropertiesException {
        HashSet result = HashSetFactory.make();
        for (InstanceKey ik : instances) {
            result.addAll(this.getNodesThatMatter(ik));
        }
        return result;
    }

    private Collection<CGNode> getNodesThatMatter(InstanceKey ik) throws PropertiesException {
        Collection<CGNode> result = this.nodesThatMatter.get(ik);
        if (result == null) {
            result = this.computeNodesThatMatter(ik);
            this.nodesThatMatter.put(ik, result);
        }
        return result;
    }

    protected abstract Collection<CGNode> computeNodesThatMatter(InstanceKey var1) throws PropertiesException;

    protected abstract TypeStateFunctionProvider makeFlowFunctions(ICFGSupergraph var1, Collection<InstanceKey> var2) throws PropertiesException;

    @Override
    protected boolean supportsWitnessGeneration() {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public ISolverResult perform(IProgressMonitor monitor) throws WalaException, SolverTimeoutException, MaxFindingsException, SetUpException, PropertiesException {
        monitor.beginTask(null, 1);
        monitor.subTask(this.toString());
        LocalSolverResult result = new LocalSolverResult();
        try {
            try {
                boolean hasPropertyType = this.initializeProperty();
                if (hasPropertyType) {
                    Collection<InstanceKey> instances = this.computeTrackedInstances();
                    OrdinalSet<InstanceKey> ordInstances = this.toOrdinalInstanceSet(instances);
                    Collection<CGNode> acceptNodes = this.scanForEventNodes(ordInstances);
                    acceptNodes = this.pruneForAccept(acceptNodes);
                    Collection<CGNode> nodeSet = this.computeRelevantCallers(acceptNodes, ordInstances);
                    BenignOracle oracle = this.getBenignOracle();
                    HashSet instructions = HashSetFactory.make();
                    for (CGNode n : nodeSet) {
                        if (!oracle.isBenignMethod(n.getMethod())) {
                            Collection<InstanceKey> relevant = this.computeInstancesForNode(n, ordInstances, acceptNodes);
                            Collection<Pair<CGNode, SSAInstruction>> relevantInstructions = oracle.computeMethodErrorInstructions(n, acceptNodes, this.toOrdinalInstanceSet(relevant));
                            instructions.addAll(relevantInstructions);
                            this.initializeDomain(relevant);
                            SingleProcedureSupergraph supergraph = this.buildSupergraph(n);
                            this.checkGraph((ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode>)supergraph);
                            TypeStateProblem p = this.createTypeStateProblem(n, supergraph, relevant);
                            TabulationSolver solver = TabulationSolver.make((TabulationProblem)p);
                            TabulationResult r = solver.solve();
                            TypeStateResult t = new TypeStateResult((TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid>)r, this.getDomain(), supergraph);
                            result.compose(t);
                        }
                        if (!Thread.interrupted()) continue;
                        throw new SolverTimeoutException((ISolverResult)result);
                    }
                    this.updateBenignOracle(instances, instructions, result);
                } else {
                    Trace.println((String)"---No instances of property Type were found---");
                }
            }
            catch (CancelException cancelException) {
                throw new SolverTimeoutException((ISolverResult)result);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private void updateBenignOracle(Collection<InstanceKey> instances, Collection<Pair<CGNode, SSAInstruction>> instructions, LocalSolverResult t) {
        Set<Message> messages = t.getMessages();
        HashSet<InstanceKey> errInstances = new HashSet<InstanceKey>();
        HashSet errInstructions = HashSetFactory.make();
        for (TypeStateMessage typeStateMessage : messages) {
            errInstances.add(typeStateMessage.getInstance());
            errInstructions.add(Pair.make((Object)typeStateMessage.getCaller(), (Object)typeStateMessage.getInstruction()));
        }
        for (InstanceKey instanceKey : instances) {
            if (errInstances.contains(instanceKey)) continue;
            this.getBenignOracle().addBenignInstanceKey(instanceKey);
        }
        if (!messages.isEmpty()) assert (!errInstructions.isEmpty());
        for (Pair<CGNode, SSAInstruction> pair : instructions) {
            if (errInstructions.contains(pair)) continue;
            this.getBenignOracle().addBenignStatement((CGNode)pair.fst, (SSAInstruction)pair.snd);
        }
    }

    private SingleProcedureSupergraph buildSupergraph(CGNode n) {
        IR ir = n.getIR();
        ExplodedControlFlowGraph cfg = ExplodedControlFlowGraph.make((IR)ir);
        return new SingleProcedureSupergraph(this.getCallGraph(), n, (ControlFlowGraph<SSAInstruction, IExplodedBasicBlock>)cfg);
    }

    private Collection<InstanceKey> computeInstancesForNode(CGNode n, OrdinalSet<InstanceKey> instances, Collection<CGNode> acceptNodes) {
        IR ir = n.getIR();
        HashSet result = HashSetFactory.make((int)instances.size());
        for (CGNode a : acceptNodes) {
            if (!this.getCallGraph().hasEdge((Object)n, (Object)a)) continue;
            Iterator it2 = this.getCallGraph().getPossibleSites(n, a);
            while (it2.hasNext()) {
                CallSiteReference site = (CallSiteReference)it2.next();
                SSAAbstractInvokeInstruction[] calls = ir.getCalls(site);
                int i = 0;
                while (i < calls.length) {
                    SSAInvokeInstruction call = (SSAInvokeInstruction)calls[i];
                    int receiver = call.getReceiver();
                    PointerKey r = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(n, receiver);
                    OrdinalSet pointsTo = this.getPointerAnalysis().getPointsToSet(r);
                    Iterator it3 = OrdinalSet.intersect(instances, (OrdinalSet)pointsTo).iterator();
                    while (it3.hasNext()) {
                        result.add((InstanceKey)it3.next());
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private Collection<CGNode> pruneForAccept(Collection<CGNode> eventNodes) {
        HashSet result = HashSetFactory.make((int)eventNodes.size());
        for (CGNode n : eventNodes) {
            if (!this.getDFA().receives(n.getMethod())) continue;
            String sig = n.getMethod().getSignature();
            IEvent e = this.getDFA().matchDispatchEvent(sig);
            if (!this.eventTransitionsToAccept(e)) continue;
            result.add(n);
        }
        return result;
    }

    protected abstract TypeStateProblem createTypeStateProblem(CGNode var1, ICFGSupergraph var2, Collection<InstanceKey> var3) throws WalaException, PropertiesException;
}

