/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.io;

import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.core.TypeStateProperty;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Set;

public class TypeStatePropertyDotWriter {
    public static void write(String fileName, Set<TypeStateProperty> properties) {
        StringBuffer result = new StringBuffer();
        for (TypeStateProperty curr : properties) {
            StringBuffer dotStringBuffer = TypeStatePropertyDotWriter.dotOutput(curr);
            result.append(dotStringBuffer);
        }
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    public static void writeSingleProperty(String fileName, TypeStateProperty property) {
        StringBuffer dotStringBuffer = TypeStatePropertyDotWriter.dotOutput(property);
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(dotStringBuffer.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    private static StringBuffer dotOutput(TypeStateProperty property) {
        StringBuffer result = new StringBuffer("digraph \"TypeStateProeprty:" + property.getTypesAsString() + "\" {\n");
        result.append("rankdir=LR;center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        result.append("__node [label=\"" + property.getTypesAsString() + "\" shape=\"box\"]\n");
        Iterator<IDFAState> it = property.statesIterator();
        while (it.hasNext()) {
            IDFAState state = it.next();
            result.append(TypeStatePropertyDotWriter.dotOutput(state));
            if (state.isAccepting()) {
                result.append(" [color=green]\n");
                continue;
            }
            result.append("\n");
        }
        IDFAState initial = property.initial();
        result.append("init [shape=\"plaintext\"]\n");
        result.append("init ->");
        result.append(TypeStatePropertyDotWriter.dotOutput(initial));
        result.append("\n");
        Iterator<IDFAState> it2 = property.statesIterator();
        while (it2.hasNext()) {
            IDFAState state = it2.next();
            Iterator<IEvent> letterIt = property.alphabetIterator();
            while (letterIt.hasNext()) {
                IEvent event = letterIt.next();
                IDFAState target = property.successor(state, event);
                if (target == null) continue;
                result.append(TypeStatePropertyDotWriter.dotOutput(state));
                result.append(" -> ");
                result.append(TypeStatePropertyDotWriter.dotOutput(target));
                result.append(" [label=\"" + event.getName() + "\"]\n");
            }
        }
        result.append("}");
        return result;
    }

    private static StringBuffer dotOutput(IDFAState state) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        result.append(state.getName());
        result.append("\"");
        return result;
    }
}

