/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.io;

import com.ibm.safe.dfa.IDFA;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.io.File;
import java.io.FileWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IDFADotWriter {
    private final boolean useAnonymousStates;

    public static IDFADotWriter instance() {
        return new IDFADotWriter(false);
    }

    public IDFADotWriter(boolean anonymousNames) {
        this.useAnonymousStates = anonymousNames;
    }

    public void write(String fileName, Set<IDFA> automata) {
        StringBuffer result = new StringBuffer();
        for (IDFA curr : automata) {
            StringBuffer dotStringBuffer = this.dotOutput(curr);
            result.append(dotStringBuffer);
        }
        try {
            FileWriter fw = new FileWriter(fileName, false);
            fw.write(result.toString());
            fw.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing dot file");
        }
    }

    public File writeDFA(String fileName, IDFA dfa) {
        StringBuffer dotStringBuffer = new StringBuffer();
        dotStringBuffer.append(this.openDigraph());
        dotStringBuffer.append(this.dotOutput(dfa));
        dotStringBuffer.append(this.closeDigraph());
        return this.writeDotFile(fileName, dotStringBuffer);
    }

    protected File writeDotFile(String fileName, StringBuffer dotStringBuffer) {
        try {
            File f = new File(fileName);
            FileWriter fw = new FileWriter(f);
            fw.write(dotStringBuffer.toString());
            fw.close();
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing dot file" + e);
        }
    }

    public StringBuffer openDigraph() {
        StringBuffer result = new StringBuffer("digraph \"DFA\" {\n");
        result.append("rankdir=LR;center=true;fontsize=12;node [fontsize=12];edge [fontsize=12]; \n");
        return result;
    }

    public StringBuffer closeDigraph() {
        return new StringBuffer("}");
    }

    public StringBuffer dotOutput(IDFA dfa) {
        StringBuffer result = new StringBuffer();
        Map<Object, String> nameMap = Collections.emptyMap();
        if (this.useAnonymousStates) {
            nameMap = this.initStateNames(dfa);
        }
        for (Object state : dfa) {
            result.append(this.nodeDotOutput(state, nameMap));
            result.append(this.nodeDotDecoration(dfa, state, nameMap));
        }
        result.append(this.createInitialState(dfa, nameMap));
        result.append(this.createEdges(dfa, nameMap));
        return result;
    }

    protected StringBuffer createInitialState(IDFA dfa, Map<Object, String> nameMap) {
        StringBuffer result = new StringBuffer();
        Object initial = dfa.getInitialState();
        result.append("_init_ [label=\"\" shape=\"plaintext\"]\n");
        result.append("_init_ ->");
        result.append(this.nodeDotOutput(initial, nameMap));
        result.append("[color=\"blue\"]\n");
        return result;
    }

    protected StringBuffer createEdges(IDFA dfa, Map<Object, String> nameMap) {
        StringBuffer result = new StringBuffer();
        for (Object state : dfa) {
            Iterator succIt = dfa.getSuccNodes(state);
            while (succIt.hasNext()) {
                Object target = succIt.next();
                result.append(this.nodeDotOutput(state, nameMap));
                result.append(" -> ");
                result.append(this.nodeDotOutput(target, nameMap));
                String label = dfa.getLabels(state, target).toString();
                String optionalColor = dfa.isAccepting(target) ? " color= \" green \" " : "";
                result.append(" [label=\"" + label + "\"" + optionalColor + "]\n");
            }
        }
        return result;
    }

    protected StringBuffer nodeDotDecoration(IDFA dfa, Object state, Map<Object, String> nameMap) {
        StringBuffer result = new StringBuffer();
        if (dfa.isAccepting(state)) {
            result.append(" [color=green]\n");
        } else {
            result.append("\n");
        }
        return result;
    }

    protected StringBuffer nodeDotOutput(Object state, Map<Object, String> stateNames) {
        StringBuffer result = new StringBuffer();
        result.append("\"");
        if (this.useAnonymousStates) {
            result.append(stateNames.get(state));
        } else {
            result.append(state.toString());
        }
        result.append("\"");
        return result;
    }

    protected Map<Object, String> initStateNames(IDFA dfa) {
        HashMap<Object, String> result = new HashMap<Object, String>();
        int counter = 0;
        SlowDFSDiscoverTimeIterator dfdi = new SlowDFSDiscoverTimeIterator((Graph)dfa, Collections.singleton(dfa.getInitialState()).iterator());
        while (dfdi.hasNext()) {
            Object state = dfdi.next();
            result.put(state, String.valueOf(counter++));
        }
        return result;
    }
}

