/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;

public class DFADebug {
    private static final String DOT_EXE_STRING = "C:/Progra~1/ATT/Graphviz/bin/dot.exe";
    private static final String DOT_GRAPH_SIZE = null;
    private static final String DOT_IMAGE_FORMAT = "gif";
    private static String outputDir;

    public static String flattenFileName(String fileName) {
        return fileName.replace('/', '_');
    }

    public static void dotifyImages(File dotFile, String imageFile) {
        String cmd = String.valueOf(DFADebug.getDotExe()) + " -T" + DOT_IMAGE_FORMAT + " -o " + imageFile + " -v " + dotFile.getAbsolutePath();
        if (DOT_GRAPH_SIZE != null) {
            cmd = String.valueOf(cmd) + " -Gsize=" + DOT_GRAPH_SIZE;
        }
        System.out.println("spawning process " + cmd);
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedInputStream output = new BufferedInputStream(p.getInputStream());
            BufferedInputStream error = new BufferedInputStream(p.getErrorStream());
            boolean repeat = true;
            while (repeat) {
                int nRead;
                byte[] data;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (output.available() > 0) {
                    data = new byte[output.available()];
                    nRead = output.read(data);
                    System.err.println("read " + nRead + " bytes from output stream");
                }
                if (error.available() > 0) {
                    data = new byte[error.available()];
                    nRead = error.read(data);
                    System.err.println("read " + nRead + " bytes from error stream");
                }
                try {
                    p.exitValue();
                    repeat = false;
                    System.out.println("process terminated with exit code " + p.exitValue());
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    repeat = true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error running dot " + e);
        }
    }

    private static String getDotExe() {
        return DOT_EXE_STRING;
    }

    public static void setOutputDirectory(String directory) {
        if (directory.charAt(directory.length() - 1) != '/') {
            directory = String.valueOf(directory) + "/";
        }
        outputDir = directory;
    }

    public static String getOutputDir() {
        return outputDir;
    }
}

