/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.typestate.ap.must.MustAPSolver;
import com.ibm.safe.typestate.ap.must.MustMerge;
import com.ibm.safe.typestate.ap.must.mustnot.MustMustNotAPSolver;
import com.ibm.safe.typestate.ap.must.mustnot.MustMustNotMerge;
import com.ibm.safe.typestate.base.BaseSolver;
import com.ibm.safe.typestate.base.SeparatingSolver;
import com.ibm.safe.typestate.controller.TypeStateSolverCreator;
import com.ibm.safe.typestate.controller.TypeStateSolverKind;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.local.LocalMustMustNotSolver;
import com.ibm.safe.typestate.merge.FutureMerge;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.LossLessMerge;
import com.ibm.safe.typestate.mine.StateSimulationMerge;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.UnifyMerge;
import com.ibm.safe.typestate.options.MineMergeKind;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.staged.StagedSolver;
import com.ibm.safe.typestate.strongUpdate.StrongUpdateSolver;
import com.ibm.safe.typestate.unique.UniqueSolver;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphReachability;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TypestateSolverFactory {
    private static final boolean DEBUG_MERGE = false;

    public static ISafeSolver getSolver(AnalysisOptions domoOptions, CallGraph cg, PointerAnalysis pointerAnalysis, HeapGraph hg, ITypeStateDFA dfa, BenignOracle ora, TypeStateOptions options, TypeStateMetrics metrics, IReporter reporter, PerformanceTracker perfTracker, TraceReporter traceReporter) throws PropertiesException, CancelException {
        return TypestateSolverFactory.getSolver(options.getTypeStateSolverKind(), domoOptions, cg, pointerAnalysis, hg, dfa, ora, options, metrics, reporter, perfTracker, traceReporter);
    }

    public static IMergeFunctionFactory makeMergeFactory(TypeStateOptions options, TypeStateSolverKind kind) throws PropertiesException {
        if (options.shouldMineDFA()) {
            MineMergeKind mmk = options.getMineMergeKind();
            if (mmk == MineMergeKind.NONE) {
                return null;
            }
            if (mmk == MineMergeKind.TOTAL) {
                return UnifyMerge.factory();
            }
            if (mmk == MineMergeKind.SIMULATION) {
                return StateSimulationMerge.factory();
            }
            if (mmk == MineMergeKind.LOSSLESS) {
                return LossLessMerge.factory();
            }
            if (mmk == MineMergeKind.FUTURE) {
                return FutureMerge.factory();
            }
            Assertions.UNREACHABLE();
            return null;
        }
        if (kind == TypeStateSolverKind.BASE) {
            return null;
        }
        if (kind == TypeStateSolverKind.SEPARATING) {
            return null;
        }
        if (kind == TypeStateSolverKind.LOCAL_MUST_MUSTNOT) {
            return MustMustNotMerge.factory();
        }
        if (kind == TypeStateSolverKind.STRONG_UPDATE) {
            return null;
        }
        if (kind == TypeStateSolverKind.UNIQUE) {
            return null;
        }
        if (kind == TypeStateSolverKind.AP_MUST) {
            return MustMerge.factory();
        }
        if (kind == TypeStateSolverKind.AP_MUST_MUSTNOT) {
            return MustMustNotMerge.factory();
        }
        if (kind == TypeStateSolverKind.NULL_DEREF) {
            return null;
        }
        if (kind == TypeStateSolverKind.STAGED) {
            return null;
        }
        if (kind == TypeStateSolverKind.TVLA) {
            return null;
        }
        if (kind == TypeStateSolverKind.MODULAR) {
            return null;
        }
        Assertions.UNREACHABLE((String)("unsupported " + kind));
        return null;
    }

    public static ISafeSolver getSolver(TypeStateSolverKind kind, AnalysisOptions domoOptions, CallGraph cg, PointerAnalysis pointerAnalysis, HeapGraph hg, ITypeStateDFA dfa, BenignOracle ora, TypeStateOptions options, TypeStateMetrics metrics, IReporter reporter, PerformanceTracker perfTracker, TraceReporter traceReporter) throws PropertiesException, CancelException {
        TypeStateProperty property = dfa instanceof TypeStateProperty ? (TypeStateProperty)dfa : null;
        IMergeFunctionFactory mergeFactory = TypestateSolverFactory.makeMergeFactory(options, kind);
        if (kind == TypeStateSolverKind.BASE) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, false) : null;
            return new BaseSolver(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.SEPARATING) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, false) : null;
            return new SeparatingSolver(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.LOCAL_MUST_MUSTNOT) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, false) : null;
            return new LocalMustMustNotSolver(cg, pointerAnalysis, hg, property, options, live, TypestateSolverFactory.computeReachability(cg), ora, metrics, reporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.STRONG_UPDATE) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, false) : null;
            return new StrongUpdateSolver(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.UNIQUE) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, false) : null;
            return new UniqueSolver(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.AP_MUST) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, true) : null;
            return new MustAPSolver(domoOptions, cg, TypestateSolverFactory.computeReachability(cg), pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.AP_MUST_MUSTNOT) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, true) : null;
            return new MustMustNotAPSolver(domoOptions, cg, TypestateSolverFactory.computeReachability(cg), pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        }
        if (kind == TypeStateSolverKind.STAGED) {
            return new StagedSolver(domoOptions, cg, pointerAnalysis, property, options, ora, metrics, reporter, perfTracker);
        }
        if (kind == TypeStateSolverKind.TVLA) {
            ILiveObjectAnalysis live = options.shouldUseLiveAnalysis() ? TypeStateSolverCreator.computeLiveObjectAnalysis(cg, hg, true) : null;
            return TypestateSolverFactory.loadTVLASolver(domoOptions, cg, pointerAnalysis, property, options, live, ora, metrics, reporter);
        }
        Assertions.UNREACHABLE((String)("unsupported " + kind));
        return null;
    }

    private static ISafeSolver loadTVLASolver(AnalysisOptions domoOptions, CallGraph cg, PointerAnalysis pointerAnalysis, TypeStateProperty property, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter) {
        Class<?> klass = null;
        ISafeSolver ret = null;
        String fullClassName = "com.ibm.safe.safet.SafeTSolver";
        try {
            klass = Class.forName(fullClassName);
            Constructor<?> ctr = klass.getConstructors()[0];
            Object[] params = new Object[]{domoOptions, cg, pointerAnalysis, property, options, live, ora, metrics, reporter};
            ret = (ISafeSolver)ctr.newInstance(params);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.println((String)(" TVLA Implmentation " + fullClassName + " not found!"));
            ret = null;
        }
        catch (InstantiationException instantiationException) {
            Trace.println((String)(" Failed to initialized TVLA Implmentation " + fullClassName));
            ret = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.println((String)(" Got an illegal access exception while initializing TVLA Implmentation " + fullClassName));
            ret = null;
        }
        catch (IllegalArgumentException e) {
            Trace.println((String)(" Got an illegal arguemnt exception while initializing TVLA Implmentation " + fullClassName));
            ret = null;
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Trace.println((String)(" Got an invocation target exception while initializing TVLA Implmentation " + fullClassName));
            ret = null;
            e.printStackTrace();
        }
        Assertions.productionAssertion((ret != null ? 1 : 0) != 0, (String)("could not create " + fullClassName));
        return ret;
    }

    protected static GraphReachability<CGNode, CGNode> computeReachability(CallGraph cg) throws CancelException {
        GraphReachability reach = new GraphReachability((Graph)cg, (Predicate)IndiscriminateFilter.singleton());
        reach.solve(null);
        return reach;
    }
}

