/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.Collection;
import java.util.Iterator;

public class TypeStatePropertyContext {
    public static boolean isTrackedType(IClassHierarchy classHierarchy, Collection<IClass> propertyTypes, IClass type) {
        boolean result = false;
        Iterator<IClass> iter = propertyTypes.iterator();
        while (iter.hasNext() && !result) {
            IClass propertyType = iter.next();
            if (propertyType.isInterface()) {
                try {
                    if (!type.isInterface()) {
                        result = type.getAllImplementedInterfaces().contains(propertyType);
                        continue;
                    }
                    result = type.equals(propertyType) || type.getAllImplementedInterfaces().contains(propertyType);
                }
                catch (Exception exception) {
                    result = false;
                }
                continue;
            }
            result = classHierarchy.isSubclassOf(type, propertyType);
        }
        return result;
    }

    public static IClass getPropertyTrackedType(IClassHierarchy classHierarchy, String typeName) {
        for (IClass currentClass : classHierarchy) {
            if (!currentClass.getName().toString().equals(typeName)) continue;
            return currentClass;
        }
        return null;
    }
}

