/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.dfa.DFASpec;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.IDFATransition;
import com.ibm.safe.dfa.events.IDispatchEvent;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IEventImpl;
import com.ibm.safe.dfa.events.IObjectDeathEvent;
import com.ibm.safe.dfa.events.IProgramExitEvent;
import com.ibm.safe.dfa.events.IReadFieldEventImpl;
import com.ibm.safe.internal.exceptions.AssertionFailedException;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.typestate.rules.AbstractTypeStateDFA;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeStateProperty
extends AbstractTypeStateDFA {
    Map<String, IEvent> eventName2Event = HashMapFactory.make();
    Map<String, IDFAState> stateName2State = HashMapFactory.make();
    Map<Class, List<IEvent>> class2events = HashMapFactory.make();
    private Set<IDFAState> acceptingStates = new HashSet<IDFAState>(3);
    protected Map<IDFAState, Map<IEvent, IDFAState>> transitionMapping = new HashMap<IDFAState, Map<IEvent, IDFAState>>(20);
    private Map<IDFAState, Map<IEvent, Set<IDFAState>>> reverseTransitionMapping = new HashMap<IDFAState, Map<IEvent, Set<IDFAState>>>(20);
    protected TypestateRule typeStateRule;

    public TypeStateProperty(TypestateRule aTypeStateRule, IClassHierarchy cha) {
        super(cha, new HashSet<IClass>(1));
        this.typeStateRule = aTypeStateRule;
        this.typeStateRule.getTypeStateAutomaton().getEvents().add(IEventImpl.GENERIC_EVENT);
        this.mapEventNames2Events();
        this.mapStateNames2States();
        this.mapEventClass2Events();
        this.initAcceptingStates(this.typeStateRule.getTypeStateAutomaton());
        this.initTransitionMappings(this.typeStateRule.getTypeStateAutomaton());
    }

    protected TypeStateProperty(IClassHierarchy cha) {
        super(cha, new HashSet<IClass>(1));
    }

    private void mapEventClass2Events() {
        Iterator<IEvent> it = this.alphabetIterator();
        while (it.hasNext()) {
            List<IEvent> classEntry;
            IEvent e = it.next();
            Class<Object> eventClass = e.getClass();
            if (e instanceof IDispatchEvent) {
                eventClass = IDispatchEvent.class;
            }
            if ((classEntry = this.class2events.get(eventClass)) == null) {
                classEntry = new ArrayList<IEvent>();
                this.class2events.put(eventClass, classEntry);
            }
            classEntry.add(e);
        }
    }

    private void mapEventNames2Events() {
        Iterator<IEvent> it = this.alphabetIterator();
        while (it.hasNext()) {
            IEvent e = it.next();
            this.eventName2Event.put(e.getName(), e);
            if (e instanceof IProgramExitEvent) {
                this.setObservesProgramExit(true);
            }
            if (!(e instanceof IObjectDeathEvent)) continue;
            this.setObservesObjectDeath(true);
        }
    }

    private void mapStateNames2States() {
        Iterator<IDFAState> it = this.statesIterator();
        while (it.hasNext()) {
            IDFAState s = it.next();
            this.stateName2State.put(s.getName(), s);
        }
    }

    public Iterator<IEvent> alphabetIterator() {
        return this.typeStateRule.getTypeStateAutomaton().getEvents().iterator();
    }

    public Set<IDFAState> getAcceptingStates() {
        return this.acceptingStates;
    }

    public int getAlphabetSize() {
        return this.typeStateRule.getTypeStateAutomaton().getEvents().size();
    }

    public IEvent getEvent(String eventName) {
        return this.eventName2Event.get(eventName);
    }

    public TypestateRule getRule() {
        return this.typeStateRule;
    }

    public int getNumberOfStates() {
        return this.typeStateRule.getTypeStateAutomaton().getStates().size();
    }

    public IDFAState getState(String name) {
        return this.stateName2State.get(name);
    }

    @Override
    public IDFAState initial() {
        return this.typeStateRule.getTypeStateAutomaton().initialState();
    }

    @Override
    public Set<IDFAState> predecessors(IDFAState state, IEvent event) {
        Map<IEvent, Set<IDFAState>> stateMap = this.reverseTransitionMapping.get(state);
        if (stateMap == null) {
            return Collections.emptySet();
        }
        Set<Object> predSet = stateMap.get(event);
        if (predSet == null && (predSet = stateMap.get(IEventImpl.GENERIC_EVENT)) == null) {
            predSet = Collections.emptySet();
        }
        return predSet;
    }

    public Iterator<IDFAState> statesIterator() {
        return this.typeStateRule.getTypeStateAutomaton().getStates().iterator();
    }

    @Override
    public IDFAState successor(IDFAState state, IEvent eventName) {
        Map<IEvent, IDFAState> stateMap = this.transitionMapping.get(state);
        assert (stateMap != null) : "no successor found for " + state + " with " + eventName;
        IDFAState result = stateMap.get(eventName);
        IDFAState iDFAState = result = result == null ? stateMap.get(IEventImpl.GENERIC_EVENT) : result;
        assert (result != null) : "No successor found for " + state + " " + eventName;
        return result;
    }

    public StringBuffer getTypesAsString() {
        StringBuffer result = new StringBuffer();
        for (String typeName : this.getRule().getTypes()) {
            result.append(" ; " + typeName);
        }
        return result;
    }

    public void validate() {
        boolean illegal = false;
        StringBuffer errorString = new StringBuffer();
        Iterator<IDFAState> stateIt = this.statesIterator();
        while (stateIt.hasNext()) {
            IDFAState curr = stateIt.next();
            Iterator<IEvent> eventIt = this.alphabetIterator();
            while (eventIt.hasNext()) {
                Set<IDFAState> pred;
                IEvent currEvent = eventIt.next();
                if (currEvent.equals(IEventImpl.GENERIC_EVENT)) continue;
                IDFAState succ = this.successor(curr, currEvent);
                if (succ == null) {
                    illegal = true;
                    errorString.append("cannot find successor for state " + curr + " and event " + currEvent + "\n");
                }
                if (this.initial().equals(curr) || (pred = this.predecessors(curr, currEvent)) != null) continue;
                illegal = true;
                errorString.append("cannot find predecessors for state " + curr + " and event " + currEvent + "\n");
            }
        }
        if (illegal) {
            throw new AssertionFailedException("Illegal typestate property: \n" + errorString.toString());
        }
    }

    boolean eventTransitionsOnlyToAccept(IEvent e) {
        DFASpec idfa = this.getRule().getTypeStateAutomaton();
        for (IDFATransition t : idfa.getTransitions()) {
            IDFAState dest;
            if (!t.getEvent().equals(e.getName()) || t.getSource().equals(t.getDestination()) || (dest = this.getState(t.getDestination())).isAccepting()) continue;
            return false;
        }
        return true;
    }

    protected boolean eventTransitionsToAccept(IEvent e) {
        DFASpec idfa = this.getRule().getTypeStateAutomaton();
        for (IDFATransition t : idfa.getTransitions()) {
            IDFAState dest;
            if (!t.getEvent().equals(e.getName()) || t.getSource().equals(t.getDestination()) || !(dest = this.getState(t.getDestination())).isAccepting()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.typeStateRule.getName();
    }

    private void addTransition(IDFATransition transition) {
        Set<IDFAState> preds;
        IDFAState src = this.getState(transition.getSource());
        IEvent event = this.getEvent(transition.getEvent());
        IDFAState dest = this.getState(transition.getDestination());
        if (src == null) {
            throw new AssertionFailedException("No source state " + transition.getSource() + " for the rule " + this.typeStateRule.getName());
        }
        if (event == null) {
            throw new AssertionFailedException("No event " + transition.getEvent() + " for the rule " + this.typeStateRule.getName());
        }
        if (dest == null) {
            throw new AssertionFailedException("No destination state " + transition.getDestination() + " for the rule " + this.typeStateRule.getName());
        }
        Map<IEvent, IDFAState> outedges = this.transitionMapping.get(src);
        if (outedges == null) {
            outedges = new HashMap<IEvent, IDFAState>(10);
            this.transitionMapping.put(src, outedges);
        }
        outedges.put(event, dest);
        Map<IEvent, Set<IDFAState>> reverseEdges = this.reverseTransitionMapping.get(dest);
        if (reverseEdges == null) {
            reverseEdges = new HashMap<IEvent, Set<IDFAState>>(10);
            this.reverseTransitionMapping.put(dest, reverseEdges);
        }
        if ((preds = reverseEdges.get(event)) == null) {
            preds = new HashSet<IDFAState>(10);
            reverseEdges.put(event, preds);
        }
        preds.add(src);
    }

    private void initAcceptingStates(DFASpec automaton) {
        for (IDFAState state : automaton.getStates()) {
            if (!state.isAccepting()) continue;
            this.acceptingStates.add(state);
        }
    }

    private void initTransitionMappings(DFASpec automaton) {
        Iterator iter = automaton.getTransitions().iterator();
        while (iter.hasNext()) {
            this.addTransition((IDFATransition)iter.next());
        }
    }

    @Override
    public String getName() {
        return this.getRule().getName();
    }

    @Override
    public IEvent match(Class eventClass, String param) {
        List<IEvent> eventList = this.class2events.get(eventClass);
        for (IEvent curr : eventList) {
            if (!curr.match(param)) continue;
            return curr;
        }
        return null;
    }

    public IEvent matchReadFieldEvent(String fld) {
        return this.match(IReadFieldEventImpl.class, fld);
    }

    public IEvent matchWriteFieldEvent(String fld) {
        return this.match(IReadFieldEventImpl.class, fld);
    }
}

