/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.debug.Assertions;

public class TypeStateMessage
implements Message {
    public InstanceKey instance;
    private final CGNode cgnode;
    public SSAInstruction instr;
    private final Object supergraphNode;
    private final BaseFactoid inputFact;
    public CGNode caller;
    public Object additionalInfo;
    public TypeStateProperty property;
    private int lineNumber;

    public TypeStateMessage(TypeStateProperty property, BaseFactoid inputFact, CGNode cgnode, Object supergraphNode, SSAInvokeInstruction instr, CGNode caller) {
        this.property = property;
        this.inputFact = inputFact;
        this.cgnode = cgnode;
        this.supergraphNode = supergraphNode;
        this.instance = inputFact.instance;
        this.instr = instr;
        this.caller = caller;
        try {
            this.lineNumber = this.invokeInstructionLineNumber();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    public TypeStateMessage(TypeStateProperty property, BaseFactoid inputFact, CGNode cgnode, Object supergraphNode, SSAInvokeInstruction instr, CGNode caller, Object additionalInfo) {
        this.property = property;
        this.inputFact = inputFact;
        this.cgnode = cgnode;
        this.supergraphNode = supergraphNode;
        this.instance = inputFact.instance;
        this.instr = instr;
        this.caller = caller;
        this.additionalInfo = additionalInfo;
        try {
            this.lineNumber = this.invokeInstructionLineNumber();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    public TypeStateMessage(TypeStateProperty property, BaseFactoid inputFact, CGNode cgnode, Object supergraphNode, SSAInstruction instr, CGNode caller, Object additionalInfo, int lineNumber) {
        this.property = property;
        this.inputFact = inputFact;
        this.cgnode = cgnode;
        this.supergraphNode = supergraphNode;
        this.instance = inputFact.instance;
        this.instr = instr;
        this.caller = caller;
        this.additionalInfo = additionalInfo;
        this.lineNumber = lineNumber;
    }

    public int getAllocSiteLineNumber() {
        if (this.instance instanceof AllocationSite) {
            AllocationSite allocInstance = (AllocationSite)this.instance;
            NewSiteReference siteRef = allocInstance.getSite();
            return siteRef.getProgramCounter();
        }
        return 0;
    }

    private int invokeInstructionLineNumber() throws InvalidClassFileException {
        if (this.instr == null) {
            return -1;
        }
        assert (this.instr instanceof SSAInvokeInstruction);
        int pc = ((SSAInvokeInstruction)this.instr).getProgramCounter();
        IMethod m = this.caller.getMethod();
        return m != null ? m.getLineNumber(pc) : -1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IMethod getMethod() {
        return this.caller != null ? this.caller.getMethod() : null;
    }

    public SSAInstruction getInstruction() {
        return this.instr;
    }

    public InstanceKey getInstance() {
        return this.instance;
    }

    public CGNode getCaller() {
        return this.caller;
    }

    public IMethod getAllocSiteMethod() {
        IMethod m = null;
        if (this.instance instanceof AllocationSite) {
            AllocationSite allocInstance = (AllocationSite)this.instance;
            m = allocInstance.getMethod();
        }
        return m;
    }

    public IRule getRule() {
        return this.property.getRule();
    }

    public Location getLocation() {
        Object result = this.instr != null ? Location.createMethodLocation((TypeName)this.getMethod().getDeclaringClass().getName(), (Selector)this.getMethod().getSelector(), (int)this.getLineNumber()) : Location.createUnknownLocation();
        return result;
    }

    public String getMessageType() {
        return "typestate";
    }

    public Object getAdditionalInfo() {
        return this.additionalInfo;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypeStateMessage)) {
            return false;
        }
        TypeStateMessage otherMessage = (TypeStateMessage)other;
        return !(this.instr != null && !this.instr.equals((Object)otherMessage.instr) || this.cgnode != null && !this.cgnode.equals(otherMessage.cgnode));
    }

    public int hashCode() {
        return (this.instr != null ? this.instr.hashCode() : 0) + 31 * (this.cgnode != null ? this.cgnode.hashCode() : 0);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.getRule().getName()).append(" (").append(this.getLocation().getSourceLocation()).append(')');
        return strBuilder.toString();
    }

    public String getText() {
        return this.toString();
    }
}

