/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IObjectDeathEventImpl;
import com.ibm.safe.solvers.WholeProgramFunctionProvider;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.UniversalKillFlowFunction;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.TracingProperty;
import com.ibm.safe.typestate.quad.AggregateFlowFunction;
import com.ibm.safe.typestate.rules.FilterKillFunction;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.rules.IntFilter;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class TypeStateFunctionProvider
extends WholeProgramFunctionProvider {
    public static final int DEBUG_LEVEL = 0;
    private static final boolean NORMAL_LIVE_KILLS = false;
    private final ITypeStateDFA dfa;
    protected final Map<CGNode, IEvent> node2event = HashMapFactory.make();
    private OrdinalSet<InstanceKey> trackedInstanceSet;
    private ILiveObjectAnalysis liveObjectAnalysis;
    private final TraceReporter traceReporter;
    private final boolean exceptionalFlowKills;

    public TypeStateFunctionProvider(CallGraph cg, TypeStateDomain domain, ITypeStateDFA dfa, ICFGSupergraph supergraph, PointerAnalysis pointerAnalysis, Collection<InstanceKey> trackedInstances, ILiveObjectAnalysis liveObjectAnalysis, TraceReporter traceReporter) {
        super(cg, pointerAnalysis, supergraph, (TabulationDomain)domain);
        this.dfa = dfa;
        this.liveObjectAnalysis = liveObjectAnalysis;
        this.traceReporter = traceReporter;
        this.exceptionalFlowKills = traceReporter != null;
        this.initTrackedInstanceSet(pointerAnalysis, trackedInstances);
        this.computeEventMap(cg);
        if (dfa instanceof TracingProperty) assert (traceReporter != null);
    }

    protected IUnaryFlowFunction makeProgramEntryCallFlowFunction(Object src, Object dest) {
        return IdentityFlowFunction.identity();
    }

    protected abstract IUnaryFlowFunction getNonEntryCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> var1, BasicBlockInContext<IExplodedBasicBlock> var2);

    public IUnaryFlowFunction getCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest, BasicBlockInContext<IExplodedBasicBlock> ret) {
        if (FakeRootMethod.isFromFakeRoot(src)) {
            return this.makeProgramEntryCallFlowFunction(src, dest);
        }
        return this.getNonEntryCallFlowFunction(src, dest);
    }

    public IUnaryFlowFunction getCallToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (this.slicedAnyCallee(src)) {
            if (this.exceptionalFlowKills) {
                ControlFlowGraph cfg = this.supergraph.getCFG(src);
                for (Object o : cfg.getNormalSuccessors((Object)((IExplodedBasicBlock)src.getDelegate()))) {
                    if (!o.equals(dest.getDelegate())) continue;
                    return IdentityFlowFunction.identity();
                }
                return UniversalKillFlowFunction.kill();
            }
            return IdentityFlowFunction.identity();
        }
        return UniversalKillFlowFunction.kill();
    }

    protected ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG(BasicBlockInContext<IExplodedBasicBlock> b) {
        return this.supergraph.getCFG(b);
    }

    protected ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG(CGNode n) {
        return this.supergraph.getICFG().getCFG(n);
    }

    private boolean slicedAnyCallee(BasicBlockInContext<IExplodedBasicBlock> src) {
        int actualCalleeCount;
        SSAInvokeInstruction srcInvokeInstr = TypeStateFunctionProvider.getLastCallInstruction(this.getCFG(src), src);
        CGNode callNode = this.getSupergraph().getProcOf(src);
        int originalCalleeCount = this.getCallGraph().getNumberOfTargets(callNode, srcInvokeInstr.getCallSite());
        return originalCalleeCount > (actualCalleeCount = Iterator2Collection.toSet((Iterator)this.getSupergraph().getCalledNodes(src)).size());
    }

    public final IUnaryFlowFunction getNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        ControlFlowGraph cfg = this.supergraph.getCFG(src);
        Collection ns = cfg.getNormalSuccessors((Object)((IExplodedBasicBlock)src.getDelegate()));
        if (!ns.contains(dest.getDelegate())) {
            return UniversalKillFlowFunction.kill();
        }
        if (this.exceptionalFlowKills) {
            for (Object o : cfg.getNormalSuccessors((Object)((IExplodedBasicBlock)src.getDelegate()))) {
                if (!o.equals(dest.getDelegate())) continue;
                return this.composeNormalFlowFunction(src, dest);
            }
            return UniversalKillFlowFunction.kill();
        }
        return this.composeNormalFlowFunction(src, dest);
    }

    private IUnaryFlowFunction composeNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> s, BasicBlockInContext<IExplodedBasicBlock> d) {
        return this.makeNormalFlowFunction(s, d);
    }

    private IUnaryFlowFunction getObjectDeathFlowFunction(BasicBlockInContext<IExplodedBasicBlock> s, BasicBlockInContext<IExplodedBasicBlock> d) {
        if (this.getDFA().observesObjectDeath()) {
            return new ObjectDeathTransitionFlow(this.makeDeadObjectFilter(s));
        }
        return FilterKillFunction.make(this.makeDeadObjectFilter(s));
    }

    protected IUnaryFlowFunction makeNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        return IdentityFlowFunction.identity();
    }

    public final IFlowFunction getReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (this.exceptionalFlowKills && ((IExplodedBasicBlock)src.getDelegate()).isCatchBlock()) {
            return UniversalKillFlowFunction.kill();
        }
        Trace.print((String)("Getting return flow from " + src + " to " + dest));
        if (FakeRootMethod.isFromFakeRoot(dest)) {
            Trace.println((String)"Return from FakeRootMethod");
            return this.getProgramExitFlowFunction(src, dest);
        }
        if (this.getLiveObjectAnalysis() == null) {
            return this.getNonExitReturnFlowFunction(call, src, dest);
        }
        IUnaryFlowFunction deadKiller = this.getObjectDeathFlowFunction(call, dest);
        AggregateFlowFunction result = new AggregateFlowFunction();
        result.composeFunction((IFlowFunction)deadKiller);
        result.composeFunction(this.getNonExitReturnFlowFunction(call, src, dest));
        return result;
    }

    private IntFilter makeDeadObjectFilter(final BasicBlockInContext b) {
        IntFilter shouldKill = new IntFilter(){

            @Override
            public boolean accepts(int i) {
                if (i == 0) {
                    return false;
                }
                Object factoid = TypeStateFunctionProvider.this.getDomain().getMappedObject(i);
                if (factoid instanceof BaseFactoid) {
                    BaseFactoid f = (BaseFactoid)factoid;
                    InstanceKey ik = f.instance;
                    if (ik instanceof AllocationSite) {
                        AllocationSite ak = (AllocationSite)ik;
                        try {
                            return !TypeStateFunctionProvider.this.getLiveObjectAnalysis().mayBeLive((InstanceKey)ak, b.getNode(), b.getLastInstructionIndex());
                        }
                        catch (WalaException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    return false;
                }
                return false;
            }
        };
        return shouldKill;
    }

    public IFlowFunction getNonExitReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        return IdentityFlowFunction.identity();
    }

    public abstract IUnaryFlowFunction getProgramExitFlowFunction(BasicBlockInContext<IExplodedBasicBlock> var1, BasicBlockInContext<IExplodedBasicBlock> var2);

    protected void computeEventMap(CallGraph cg) {
        for (CGNode n : cg) {
            String sig;
            IEvent event;
            if (n.getMethod().isStatic()) continue;
            PointerKey receiver = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(n, 1);
            OrdinalSet pointsTo = this.getPointerAnalysis().getPointsToSet(receiver);
            if (!pointsTo.containsAny(this.getTrackedInstanceSet()) || (event = this.dfa.matchDispatchEvent(sig = n.getMethod().getSignature())) == null) continue;
            this.node2event.put(n, event);
        }
    }

    public ITypeStateDFA getDFA() {
        return this.dfa;
    }

    public TypeStateProperty getDFAAsProperty() {
        assert (this.dfa instanceof TypeStateProperty);
        return (TypeStateProperty)this.dfa;
    }

    public TypeStateDomain getDomain() {
        return (TypeStateDomain)this.domain;
    }

    public IUnaryFlowFunction getCallNoneToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        return this.getNormalFlowFunction(src, dest);
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    public ICFGSupergraph getSupergraph() {
        return this.supergraph;
    }

    private void initTrackedInstanceSet(PointerAnalysis pointerAnalysis, Collection<InstanceKey> trackedInstances) {
        BitVectorIntSet s = new BitVectorIntSet();
        for (InstanceKey ik : trackedInstances) {
            s.add(pointerAnalysis.getInstanceKeyMapping().getMappedIndex((Object)ik));
        }
        this.trackedInstanceSet = new OrdinalSet((IntSet)s, pointerAnalysis.getInstanceKeyMapping());
    }

    public OrdinalSet<InstanceKey> getTrackedInstanceSet() {
        return this.trackedInstanceSet;
    }

    public IEvent getEventForNode(CGNode node) {
        return this.node2event.get(node);
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    protected ILiveObjectAnalysis getLiveObjectAnalysis() {
        return this.liveObjectAnalysis;
    }

    public static boolean nodeInApplication(CGNode node) {
        return node.getMethod().getReference().getDeclaringClass().getClassLoader().equals((Object)ClassLoaderReference.Application);
    }

    protected TraceReporter getTraceReporter() {
        if (this.dfa instanceof TracingProperty) assert (this.traceReporter != null);
        return this.traceReporter;
    }

    protected SSAInvokeInstruction getInvokeInstruction(BasicBlockInContext<IExplodedBasicBlock> callBlock) {
        assert (TypeStateFunctionProvider.hasLastCallInstruction(this.getCFG(callBlock), callBlock));
        return TypeStateFunctionProvider.getLastCallInstruction(this.getCFG(callBlock), callBlock);
    }

    public static boolean hasLastCallInstruction(ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg, BasicBlockInContext<IExplodedBasicBlock> block) {
        int lastIndex = block.getLastInstructionIndex();
        SSAInstruction[] instructions = (SSAInstruction[])cfg.getInstructions();
        return instructions[lastIndex] != null && instructions[lastIndex] instanceof SSAInvokeInstruction;
    }

    public static SSAInvokeInstruction getLastCallInstruction(ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg, BasicBlockInContext<IExplodedBasicBlock> block) {
        int lastIndex = block.getLastInstructionIndex();
        SSAInstruction[] instructions = (SSAInstruction[])cfg.getInstructions();
        return (SSAInvokeInstruction)instructions[lastIndex];
    }

    private class ObjectDeathTransitionFlow
    implements IUnaryFlowFunction {
        private final IntFilter deadObjectFilter;

        ObjectDeathTransitionFlow(IntFilter deadObjectFilter) {
            this.deadObjectFilter = deadObjectFilter;
        }

        public SparseIntSet getTargets(int d1) {
            boolean transitionToAccept;
            if (d1 == 0 || !this.deadObjectFilter.accepts(d1)) {
                return SparseIntSet.singleton((int)d1);
            }
            BaseFactoid inputFact = (BaseFactoid)TypeStateFunctionProvider.this.domain.getMappedObject(d1);
            IDFAState succState = TypeStateFunctionProvider.this.dfa.successor(inputFact.state, (IEvent)IObjectDeathEventImpl.singleton());
            boolean bl = transitionToAccept = !inputFact.state.isAccepting() && succState.isAccepting();
            if (transitionToAccept) {
                if (TypeStateFunctionProvider.this.getDFA() instanceof TypeStateProperty) {
                    Assertions.UNREACHABLE((String)"implement me");
                } else {
                    TypeStateFunctionProvider.this.traceReporter.record(inputFact);
                }
            }
            return SparseIntSet.singleton((int)0);
        }
    }
}

