/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.Factoid;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.AbstractWholeProgramSolver;
import com.ibm.safe.typestate.core.TypeStateMessage;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class TypeStateDomain
extends MutableMapping<Factoid>
implements TabulationDomain<Factoid, BasicBlockInContext<IExplodedBasicBlock>> {
    private final ITypeStateDFA dfa;
    private final Set<TypeStateMessage> messages = HashSetFactory.make();
    protected Collection<InstanceKey> trackedInstances = HashSetFactory.make();
    private final TypeStateOptions options;

    public TypeStateDomain(ITypeStateDFA dfa, TypeStateOptions options) {
        this.dfa = dfa;
        this.options = options;
        this.add(AbstractWholeProgramSolver.DUMMY_ZERO);
    }

    public abstract int getIndexForStateDelta(BaseFactoid var1, IDFAState var2);

    public abstract int getIndexForInitialState(InstanceKey var1);

    public boolean addMessage(TypeStateMessage message) {
        this.messages.add(message);
        try {
            return this.messages.size() >= this.options.getMaxFindingsPerRule();
        }
        catch (PropertiesException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Set<TypeStateMessage> getMessages() {
        return this.messages;
    }

    public Collection<InstanceKey> getAcceptingInstances() {
        HashSet result = HashSetFactory.make();
        for (TypeStateMessage msg : this.messages) {
            result.add(msg.getInstance());
        }
        return result;
    }

    public void populateWitnesses(TabulationSolver solver) {
        Iterator<TypeStateMessage> it = this.messages.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    public ITypeStateDFA getDFA() {
        return this.dfa;
    }

    public TypeStateProperty getDFAAsProperty() {
        assert (this.getDFA() instanceof TypeStateProperty);
        return (TypeStateProperty)this.getDFA();
    }

    public boolean hasMessage(CGNode caller, SSAInvokeInstruction call) {
        for (TypeStateMessage m : this.messages) {
            if (!m.getCaller().equals(caller) || !m.getInstruction().equals((Object)call)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPriorityOver(PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p1, PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p2) {
        return false;
    }
}

