/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IteratorPlusOne;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.FixedSizeBitVector;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TwoExitCFG
implements ControlFlowGraph<SSAInstruction, ISSABasicBlock> {
    static final int DEBUG_LEVEL = 0;
    private final ControlFlowGraph<SSAInstruction, ISSABasicBlock> delegate;
    private final ISSABasicBlock exceptionalExit = new ExceptionalExitBlock();
    private FixedSizeBitVector normalPred;
    private FixedSizeBitVector exceptionalPred;
    private final int delegateExitNumber;
    private boolean edgesAreComputed = false;

    public TwoExitCFG(ControlFlowGraph<SSAInstruction, ISSABasicBlock> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        assert (!(delegate instanceof TwoExitCFG)) : "bad recursion";
        this.delegate = delegate;
        this.delegateExitNumber = delegate.getNumber((Object)((ISSABasicBlock)delegate.exit()));
    }

    private void ensureEdgesReady() {
        if (!this.edgesAreComputed) {
            this.computeEdges();
            this.edgesAreComputed = true;
        }
    }

    private void computeEdges() {
        this.normalPred = this.delegate instanceof AbstractCFG ? ((AbstractCFG)this.delegate).getNormalToExit() : new FixedSizeBitVector(this.delegate.getMaxNumber() + 1);
        FixedSizeBitVector fixedSizeBitVector = this.exceptionalPred = this.delegate instanceof AbstractCFG ? ((AbstractCFG)this.delegate).getExceptionalToExit() : new FixedSizeBitVector(this.delegate.getMaxNumber() + 1);
        if (!(this.delegate instanceof AbstractCFG)) {
            SSAInstruction[] instructions = (SSAInstruction[])this.delegate.getInstructions();
            Iterator it = this.delegate.getPredNodes((Object)((ISSABasicBlock)this.delegate.exit()));
            while (it.hasNext()) {
                ISSABasicBlock b = (ISSABasicBlock)it.next();
                if (b.getLastInstructionIndex() < 0) continue;
                SSAInstruction last = instructions[b.getLastInstructionIndex()];
                if (last != null && last.isPEI()) {
                    this.exceptionalPred.set(b.getNumber());
                    if (last instanceof SSAThrowInstruction || b.getLastInstructionIndex() != instructions.length - 1) continue;
                    this.normalPred.set(b.getNumber());
                    continue;
                }
                this.normalPred.set(b.getNumber());
            }
        }
    }

    public ISSABasicBlock entry() {
        return (ISSABasicBlock)this.delegate.entry();
    }

    public IExplodedBasicBlock exit() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("don't call this");
    }

    public BitVector getCatchBlocks() {
        return this.delegate.getCatchBlocks();
    }

    public ISSABasicBlock getBlockForInstruction(int index) {
        return (ISSABasicBlock)this.delegate.getBlockForInstruction(index);
    }

    public SSAInstruction[] getInstructions() {
        return (SSAInstruction[])this.delegate.getInstructions();
    }

    public int getProgramCounter(int index) {
        return this.delegate.getProgramCounter(index);
    }

    public void removeNodeAndEdges(ISSABasicBlock N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getNumber(ISSABasicBlock N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exceptionalExit)) {
            return this.getMaxNumber();
        }
        return this.delegate.getNumber((Object)N);
    }

    public ISSABasicBlock getNode(int number) {
        return number == this.getMaxNumber() ? this.exceptionalExit : (ISSABasicBlock)this.delegate.getNode(number);
    }

    public int getMaxNumber() {
        return this.delegate.getMaxNumber() + 1;
    }

    public Iterator<ISSABasicBlock> iterator() {
        return IteratorPlusOne.make((Iterator)this.delegate.iterator(), (Object)this.exceptionalExit);
    }

    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes() + 1;
    }

    public void addNode(ISSABasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeNode(ISSABasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean containsNode(ISSABasicBlock N) {
        return this.delegate.containsNode((Object)N) || N.equals(this.exceptionalExit);
    }

    public Iterator<ISSABasicBlock> getPredNodes(ISSABasicBlock N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exceptionalExit)) {
            return this.delegate.getExceptionalPredecessors((Object)((ISSABasicBlock)this.delegate.exit())).iterator();
        }
        if (N.equals(this.delegate.exit())) {
            return this.delegate.getNormalPredecessors((Object)((ISSABasicBlock)this.delegate.exit())).iterator();
        }
        return this.delegate.getPredNodes((Object)N);
    }

    public int getPredNodeCount(ISSABasicBlock N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        this.ensureEdgesReady();
        if (N.equals(this.delegate.exit())) {
            return this.normalPred.populationCount();
        }
        if (N.equals(this.exceptionalExit)) {
            return this.exceptionalPred.populationCount();
        }
        return this.delegate.getPredNodeCount((Object)N);
    }

    public Iterator<ISSABasicBlock> getSuccNodes(ISSABasicBlock N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        this.ensureEdgesReady();
        ISSABasicBlock bb = N;
        if (N.equals(this.exceptionalExit)) {
            return EmptyIterator.instance();
        }
        if (this.exceptionalPred.get(bb.getNumber())) {
            if (this.normalPred.get(bb.getNumber())) {
                return IteratorPlusOne.make((Iterator)this.delegate.getSuccNodes((Object)N), (Object)this.exceptionalExit);
            }
            return new SubstitutionIterator(this.delegate.getSuccNodes((Object)N));
        }
        return this.delegate.getSuccNodes((Object)N);
    }

    public int getSuccNodeCount(ISSABasicBlock N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exceptionalExit)) {
            return 0;
        }
        this.ensureEdgesReady();
        int result = this.delegate.getSuccNodeCount((Object)N);
        ISSABasicBlock bb = N;
        if (this.exceptionalPred.get(bb.getNumber()) && this.normalPred.get(bb.getNumber())) {
            ++result;
        }
        return result;
    }

    public void addEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIncidentEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public IMethod getMethod() {
        return this.delegate.getMethod();
    }

    public List<ISSABasicBlock> getExceptionalSuccessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.equals(this.exceptionalExit)) {
            return Collections.emptyList();
        }
        ArrayList<ISSABasicBlock> c = new ArrayList<ISSABasicBlock>(this.getSuccNodeCount(b));
        for (ISSABasicBlock o : this.delegate.getExceptionalSuccessors((Object)b)) {
            if (o.equals(this.delegate.exit())) {
                c.add(this.exceptionalExit);
                continue;
            }
            c.add(o);
        }
        return c;
    }

    public Collection<ISSABasicBlock> getNormalSuccessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.equals(this.exceptionalExit)) {
            return Collections.emptySet();
        }
        return this.delegate.getNormalSuccessors((Object)b);
    }

    public ISSABasicBlock getNormalExit() {
        return (ISSABasicBlock)this.delegate.exit();
    }

    public ISSABasicBlock getExceptionalExit() {
        return this.exceptionalExit;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Two-Exit CFG");
        result.append("\ndelegate\n" + this.delegate);
        return result.toString();
    }

    public Iterator<ISSABasicBlock> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, (NumberedNodeManager)this);
    }

    public void removeIncomingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeOutgoingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Collection<ISSABasicBlock> getExceptionalPredecessors(ISSABasicBlock b) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public Collection<ISSABasicBlock> getNormalPredecessors(ISSABasicBlock b) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getSuccNodeNumbers(ISSABasicBlock node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(ISSABasicBlock node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public ControlFlowGraph getDelegate() {
        return this.delegate;
    }

    public final class ExceptionalExitBlock
    implements ISSABasicBlock {
        public ControlFlowGraph getDelegate() {
            return TwoExitCFG.this.delegate;
        }

        public int getFirstInstructionIndex() {
            Assertions.UNREACHABLE();
            return 0;
        }

        public int getLastInstructionIndex() {
            return -2;
        }

        public boolean isCatchBlock() {
            Assertions.UNREACHABLE();
            return false;
        }

        public boolean isExitBlock() {
            return true;
        }

        public boolean isEntryBlock() {
            return false;
        }

        public IMethod getMethod() {
            return TwoExitCFG.this.delegate.getMethod();
        }

        public int getGraphNodeId() {
            Assertions.UNREACHABLE();
            return 0;
        }

        public void setGraphNodeId(int number) {
            Assertions.UNREACHABLE();
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof ExceptionalExitBlock) {
                ExceptionalExitBlock other = (ExceptionalExitBlock)arg0;
                return ((ISSABasicBlock)TwoExitCFG.this.delegate.exit()).equals(other.getDelegate().exit());
            }
            return false;
        }

        public int hashCode() {
            return ((ISSABasicBlock)TwoExitCFG.this.delegate.exit()).hashCode() * 8467;
        }

        public String toString() {
            return "Exceptional Exit[ " + this.getMethod() + "]";
        }

        public int getNumber() {
            return TwoExitCFG.this.getMaxNumber();
        }

        public Iterator<SSAPhiInstruction> iteratePhis() {
            return EmptyIterator.instance();
        }

        public Iterator<SSAPiInstruction> iteratePis() {
            return EmptyIterator.instance();
        }

        public Iterator<SSAInstruction> iterator() {
            return EmptyIterator.instance();
        }

        public SSAInstruction getLastInstruction() {
            Assertions.UNREACHABLE();
            return null;
        }

        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return null;
        }

        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            return null;
        }

        public SSAInstruction getInstruction() {
            return null;
        }
    }

    private class SubstitutionIterator
    implements Iterator<ISSABasicBlock> {
        private final Iterator<ISSABasicBlock> it;

        SubstitutionIterator(Iterator<ISSABasicBlock> it) {
            this.it = it;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ISSABasicBlock next() {
            ISSABasicBlock n = this.it.next();
            if (n.getNumber() == TwoExitCFG.this.delegateExitNumber) {
                return TwoExitCFG.this.exceptionalExit;
            }
            return n;
        }
    }
}

