/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BenignOracle {
    private static final int DEBUG_LEVEL = 1;
    private static final boolean NO_LIBRARY_ERRORS = true;
    private final CallGraph cg;
    private final PointerAnalysis pointerAnalysis;
    private Set<InstanceKey> benignInstanceKeys = HashSetFactory.make();
    private Set<Pair<CGNode, SSAInstruction>> benignStatements = HashSetFactory.make();

    public BenignOracle(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        this.cg = callGraph;
        this.pointerAnalysis = pointerAnalysis;
    }

    public boolean isBenignInstanceKey(InstanceKey ik) {
        return this.benignInstanceKeys.contains(ik);
    }

    public boolean isBenignStatement(CGNode caller, SSAInvokeInstruction call) {
        return this.benignStatements.contains(Pair.make((Object)caller, (Object)call));
    }

    public boolean isBenignMethod(IMethod m) {
        return !m.getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application);
    }

    public void addBenignInstanceKey(InstanceKey ik) {
        System.err.println("Adding instancekey: " + ik);
        this.benignInstanceKeys.add(ik);
    }

    public void addBenignStatement(CGNode node, SSAInstruction curr) {
        System.err.println("Adding statement: " + node + "," + curr);
        this.benignStatements.add((Pair<CGNode, SSAInstruction>)Pair.make((Object)node, (Object)curr));
    }

    public Map<InstanceKey, Set<Pair<CGNode, SSAInstruction>>> possibleErrorLocations(TypeStateProperty property) {
        HashMap result = HashMapFactory.make();
        for (CGNode n : this.cg) {
            String sig;
            IEvent e;
            if (n.getMethod().isStatic() || !property.receives(n.getMethod()) || !property.eventTransitionsToAccept(e = property.matchDispatchEvent(sig = n.getMethod().getSignature()))) continue;
            PointerKey receiver = this.pointerAnalysis.getHeapModel().getPointerKeyForLocal(n, 1);
            OrdinalSet recvrs = this.pointerAnalysis.getPointsToSet(receiver);
            for (InstanceKey instance : recvrs) {
                Set s = MapUtil.findOrCreateSet((Map)result, (Object)instance);
                Collection<Pair<CGNode, SSAInstruction>> callerInstructions = this.computeRelevantInstructions(Collections.singleton(n), this.toOrdinalInstanceSet(Collections.singleton(instance)));
                for (Pair<CGNode, SSAInstruction> p : callerInstructions) {
                    CGNode caller = (CGNode)p.fst;
                    if (!this.isApplicationNode(caller)) continue;
                    s.add(p);
                }
            }
        }
        return result;
    }

    public Collection<Pair<CGNode, SSAInstruction>> computeMethodErrorInstructions(CGNode caller, Collection<CGNode> targets, OrdinalSet<InstanceKey> receivers) {
        HashSet result = HashSetFactory.make();
        IR ir = caller.getIR();
        for (CGNode t : targets) {
            Iterator it2 = this.cg.getPossibleSites(caller, t);
            while (it2.hasNext()) {
                CallSiteReference site = (CallSiteReference)it2.next();
                SSAAbstractInvokeInstruction[] calls = ir.getCalls(site);
                int i = 0;
                while (i < calls.length) {
                    SSAInvokeInstruction call = (SSAInvokeInstruction)calls[i];
                    int receiver = call.getReceiver();
                    PointerKey r = this.pointerAnalysis.getHeapModel().getPointerKeyForLocal(caller, receiver);
                    OrdinalSet pointsTo = this.pointerAnalysis.getPointsToSet(r);
                    if (pointsTo.containsAny(receivers)) {
                        result.add(Pair.make((Object)caller, (Object)call));
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    boolean pairContainsApplicationNode(Collection<Pair<CGNode, SSAInstruction>> callers) {
        for (Pair<CGNode, SSAInstruction> p : callers) {
            CGNode n = (CGNode)p.fst;
            if (!n.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
            return true;
        }
        return false;
    }

    boolean isApplicationNode(CGNode n) {
        return n.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application);
    }

    protected OrdinalSet<InstanceKey> toOrdinalInstanceSet(Collection<InstanceKey> instances) {
        MutableSparseIntSet s = MutableSparseIntSet.makeEmpty();
        OrdinalSetMapping map = this.pointerAnalysis.getInstanceKeyMapping();
        for (InstanceKey i : instances) {
            s.add(map.getMappedIndex((Object)i));
        }
        return new OrdinalSet((IntSet)s, map);
    }

    protected Collection<Pair<CGNode, SSAInstruction>> computeRelevantInstructions(Collection<CGNode> targets, OrdinalSet<InstanceKey> receivers) {
        HashSet result = HashSetFactory.make();
        for (CGNode t : targets) {
            Iterator it2 = this.cg.getPredNodes((Object)t);
            block1: while (it2.hasNext()) {
                CGNode caller = (CGNode)it2.next();
                IR ir = caller.getIR();
                Iterator it3 = this.cg.getPossibleSites(caller, t);
                while (it3.hasNext()) {
                    CallSiteReference site = (CallSiteReference)it3.next();
                    SSAAbstractInvokeInstruction[] calls = ir.getCalls(site);
                    int i = 0;
                    while (i < calls.length) {
                        SSAInvokeInstruction call = (SSAInvokeInstruction)calls[i];
                        int receiver = call.getReceiver();
                        PointerKey r = this.pointerAnalysis.getHeapModel().getPointerKeyForLocal(caller, receiver);
                        OrdinalSet pointsTo = this.pointerAnalysis.getPointsToSet(r);
                        if (pointsTo.containsAny(receivers)) {
                            result.add(Pair.make((Object)caller, (Object)call));
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }
}

