/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.Factoid;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.options.WholeProgramOptions;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.typestate.core.WholeProgramSupergraph;
import com.ibm.safe.typestate.merge.EmptyMergeFactory;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ide.ui.IFDSExplorer;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.BFSPathFinder;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractWholeProgramSolver
implements ISafeSolver {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean GUI_DEBUG = false;
    protected static final boolean GUI_DEBUG_ON_EXCEPTION = false;
    public static final boolean NO_LIBRARY_ERRORS = true;
    protected static final boolean IGNORE_BENIGN_STATEMENTS = true;
    protected static final boolean IGNORE_REFLECTIVE_SPAWN = true;
    public static final Factoid DUMMY_ZERO = new Factoid(){

        public int hashCode() {
            return 211;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public String toString() {
            return "dummy universal dataflow fact";
        }
    };
    protected final CallGraph callGraph;
    protected final PointerAnalysis pointerAnalysis;
    protected final WholeProgramOptions options;
    protected final ILiveObjectAnalysis liveObjectAnalysis;
    protected final IReporter reporter;
    protected final IMergeFunctionFactory mergeFactory;
    protected Collection<CGNode> noCollapse;

    public AbstractWholeProgramSolver(CallGraph cg, PointerAnalysis pointerAnalysis, TypeStateOptions options, ILiveObjectAnalysis live, IReporter reporter, IMergeFunctionFactory mergeFactory) {
        this.callGraph = cg;
        this.pointerAnalysis = pointerAnalysis;
        this.options = options;
        this.liveObjectAnalysis = live;
        this.reporter = reporter;
        this.mergeFactory = mergeFactory == null ? EmptyMergeFactory.instance() : mergeFactory;
        this.noCollapse = new HashSet<CGNode>();
    }

    protected abstract boolean supportsWitnessGeneration();

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    protected WholeProgramOptions getOptions() {
        return this.options;
    }

    public ILiveObjectAnalysis getLiveObjectAnalysis() {
        return this.liveObjectAnalysis;
    }

    public IReporter getReporter() {
        return this.reporter;
    }

    protected IMergeFunctionFactory getMergeFactory() {
        return this.mergeFactory;
    }

    protected void launchGuiExplorer(TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid> r) throws WalaException, SetUpException, PropertiesException {
        PropertiesManager p = PropertiesManager.initFromMap(new HashMap());
        IFDSExplorer.setDotExe((String)p.getPathValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.DOT_EXE));
        IFDSExplorer.setGvExe((String)p.getPathValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.GHOSTVIEW_EXE));
        IFDSExplorer.viewIFDS(this.makeStandardIFDSResult(r));
    }

    protected TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid> makeStandardIFDSResult(TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid> r) {
        return r;
    }

    protected WholeProgramSupergraph buildSupergraph(AnalysisCache ac, Collection<CGNode> relevantNodes) {
        WholeProgramSupergraph supergraph = new WholeProgramSupergraph(this.getCallGraph(), ac, (CollectionFilter<CGNode>)new CollectionFilter(relevantNodes));
        return supergraph;
    }

    public Collection<CGNode> getNoCollapse() {
        return this.noCollapse;
    }

    protected Collection<CGNode> getMinimumSpanningTree(Graph<CGNode> g, Object root, Collection<CGNode> targets) {
        HashSet<CGNode> result = new HashSet<CGNode>();
        Graph invG = GraphInverter.invert(g);
        CGNode cgroot = (CGNode)root;
        result.add(cgroot);
        for (CGNode n : targets) {
            if (result.contains(n)) continue;
            BFSPathFinder bfs = new BFSPathFinder(invG, (Iterator)new NonNullSingletonIterator((Object)n), (Predicate)new CollectionFilter(result));
            List path = bfs.find();
            assert (path != null);
            result.addAll(path);
        }
        return result;
    }

    public boolean isApplicationNode(CGNode n) {
        return n.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application);
    }

    protected void initializeNoCollapseSet() {
        for (CGNode n : this.getCallGraph()) {
            this.noCollapse.add(n);
        }
    }

    protected void checkGraph(ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> G) {
    }

    protected Collection<CGNode> computeNodesThatMatter(OrdinalSet<InstanceKey> instances) throws WalaException, PropertiesException {
        return Iterator2Collection.toSet((Iterator)this.getCallGraph().iterator());
    }
}

