/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.core;

import com.ibm.safe.Factoid;
import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.dfa.DFASpec;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.dfa.events.IObjectDeathEventImpl;
import com.ibm.safe.dfa.events.IProgramExitEventImpl;
import com.ibm.safe.internal.exceptions.MaxFindingsException;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.exceptions.SolverTimeoutException;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.AggregateSolverResult;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.typestate.core.AbstractWholeProgramSolver;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.core.TypeStateMessage;
import com.ibm.safe.typestate.core.TypeStateProblem;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.TypeStatePropertyContext;
import com.ibm.safe.typestate.core.TypeStateResult;
import com.ibm.safe.typestate.core.WholeProgramSupergraph;
import com.ibm.safe.typestate.merge.AbstractUnification;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.CallGraphMetricsByLoader;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.TracingProperty;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.rules.InstanceBatchIterator;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSPathFinder;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractTypestateSolver
extends AbstractWholeProgramSolver {
    private TypeStateDomain domain;
    private final ITypeStateDFA dfa;
    private final BenignOracle benignOracle;
    private final TypeStateMetrics metrics;
    private final TraceReporter traceReporter;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public AbstractTypestateSolver(CallGraph cg, PointerAnalysis pointerAnalysis, ITypeStateDFA dfa, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, TraceReporter traceReporter, IMergeFunctionFactory mergeFactory) {
        super(cg, pointerAnalysis, options, live, reporter, mergeFactory);
        this.dfa = dfa;
        this.benignOracle = ora;
        this.metrics = metrics;
        this.traceReporter = traceReporter;
    }

    public AbstractTypestateSolver(CallGraph cg, PointerAnalysis pointerAnalysis, TypeStateProperty property, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, IMergeFunctionFactory mergeFactory) {
        this(cg, pointerAnalysis, property, options, live, ora, metrics, reporter, null, mergeFactory);
    }

    public TypeStateDomain getDomain() {
        return this.domain;
    }

    public BenignOracle getBenignOracle() {
        return this.benignOracle;
    }

    @Override
    protected Collection<CGNode> computeNodesThatMatter(OrdinalSet<InstanceKey> instances) throws WalaException, PropertiesException {
        return Iterator2Collection.toList((Iterator)this.getCallGraph().iterator());
    }

    protected abstract InstanceBatchIterator makeBatchIterator(Collection<InstanceKey> var1);

    protected OrdinalSet<InstanceKey> toOrdinalInstanceSet(Collection<InstanceKey> instances) {
        MutableSparseIntSet s = MutableSparseIntSet.makeEmpty();
        OrdinalSetMapping map = this.pointerAnalysis.getInstanceKeyMapping();
        for (InstanceKey i : instances) {
            s.add(map.getMappedIndex((Object)i));
        }
        return new OrdinalSet((IntSet)s, map);
    }

    protected boolean initializeProperty() throws PropertiesException {
        if (this.getOptions().shouldMineDFA()) {
            return !this.getDFA().getTypes().isEmpty();
        }
        boolean hasType = false;
        assert (this.getDFA() instanceof TypeStateProperty);
        TypeStateProperty property = (TypeStateProperty)this.getDFA();
        TypestateRule rule = property.getRule();
        for (String typeDef : rule.getTypes()) {
            IClass pType = TypeStatePropertyContext.getPropertyTrackedType(this.getCallGraph().getClassHierarchy(), typeDef);
            if (pType == null) continue;
            property.addType(pType);
            hasType = true;
        }
        return hasType;
    }

    protected abstract void initializeDomain(Collection<InstanceKey> var1);

    public String getPropertyName() {
        return this.getDFA().getName();
    }

    public void setDomain(TypeStateDomain domain) {
        this.domain = domain;
    }

    protected Predicate<IDFAState> makeAcceptFilter() {
        assert (this.getDFA() instanceof TypeStateProperty);
        TypeStateProperty property = (TypeStateProperty)this.getDFA();
        Set<IDFAState> accept = property.getAcceptingStates();
        CollectionFilter acceptFilter = new CollectionFilter(accept);
        return acceptFilter;
    }

    boolean eventTransitionsOnlyToAccept(IEvent e) throws PropertiesException {
        if (this.getOptions().shouldMineDFA()) {
            return false;
        }
        assert (this.getDFA() instanceof TypeStateProperty);
        TypeStateProperty property = (TypeStateProperty)this.getDFA();
        return property.eventTransitionsOnlyToAccept(e);
    }

    protected boolean eventTransitionsToAccept(IEvent e) {
        assert (this.getDFA() instanceof TypeStateProperty);
        TypeStateProperty property = (TypeStateProperty)this.getDFA();
        return property.eventTransitionsToAccept(e);
    }

    boolean containsApplicationNode(Collection<CGNode> callers) {
        for (CGNode n : callers) {
            if (!n.getMethod().getDeclaringClass().getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) continue;
            return true;
        }
        return false;
    }

    protected static Predicate<CGNode> makeLiveNodeFilter(final OrdinalSet<InstanceKey> instances, final ILiveObjectAnalysis live) {
        Predicate<CGNode> liveFilter = new Predicate<CGNode>(){

            public boolean test(CGNode n) {
                for (InstanceKey ik : instances) {
                    if (ik instanceof AllocationSite) {
                        AllocationSite ak = (AllocationSite)ik;
                        try {
                            if (!live.mayBeLive((InstanceKey)ak, n, -1)) continue;
                            return true;
                        }
                        catch (WalaException e) {
                            e.printStackTrace();
                            return true;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        return liveFilter;
    }

    protected Collection<CGNode> scanForEventNodes(OrdinalSet<InstanceKey> instances) {
        HashSet<CGNode> result = new HashSet<CGNode>();
        for (CGNode n : this.getCallGraph()) {
            if (n.getMethod().isStatic() || !this.receiversIncludeRelevantInstance(instances, n) || !this.getDFA().receives(n.getMethod())) continue;
            result.add(n);
        }
        return result;
    }

    boolean receiversIncludeRelevantInstance(OrdinalSet<InstanceKey> instances, CGNode n) {
        PointerKey receiver = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(n, 1);
        OrdinalSet recvrs = this.getPointerAnalysis().getPointsToSet(receiver);
        boolean foundOne = false;
        Iterator it2 = instances.iterator();
        while (it2.hasNext()) {
            if (!recvrs.contains((Object)((InstanceKey)it2.next()))) continue;
            foundOne = true;
            break;
        }
        return foundOne;
    }

    protected Collection<InstanceKey> computeTrackedInstancesByType() {
        HashSet<InstanceKey> result = new HashSet<InstanceKey>();
        for (InstanceKey key : this.getPointerAnalysis().getInstanceKeys()) {
            this.logger.fine(() -> "Considering instance with key: " + key);
            IClass instanceType = key.getConcreteType();
            this.logger.fine(() -> "Instance type is: " + instanceType);
            if (!TypeStatePropertyContext.isTrackedType(this.getCallGraph().getClassHierarchy(), this.getDFA().getTypes(), instanceType)) continue;
            if (key instanceof AllocationSite) {
                AllocationSite ak = (AllocationSite)key;
                if (ak.getMethod().isSynthetic()) {
                    SyntheticMethod sm = (SyntheticMethod)ak.getMethod();
                    if (sm.isFactoryMethod()) continue;
                    result.add(key);
                    continue;
                }
                result.add(key);
                continue;
            }
            result.add(key);
        }
        return result;
    }

    protected Collection<InstanceKey> computeTrackedInstances() throws PropertiesException {
        Collection<InstanceKey> result = this.computeTrackedInstancesByType();
        if (this.getOptions().shouldMineDFA()) {
            Map<InstanceKey, Set<IEvent>> m = this.mapInstances2Events();
            result.retainAll(m.keySet());
        } else if (this.getOptions().shouldSliceDFA()) {
            assert (this.getDFA() instanceof TypeStateProperty);
            TypeStateProperty property = (TypeStateProperty)this.getDFA();
            System.err.println("do " + property.getRule().getName());
            System.err.println("before dfa slice: " + result.size());
            Collection<InstanceKey> receivers = this.computeRelevantReceiversByDFA();
            result.retainAll(receivers);
            System.err.println("after dfa slice : " + result.size());
        }
        this.logger.info(() -> "Number of relevant instances: " + result.size());
        return result;
    }

    protected Collection<InstanceKey> computeRelevantReceiversByDFA() throws PropertiesException {
        assert (this.getDFA() instanceof TypeStateProperty);
        TypeStateProperty property = (TypeStateProperty)this.getDFA();
        Map<InstanceKey, Set<IEvent>> m = this.mapInstances2Events();
        System.out.println(m.size());
        DFASpec idfa = property.getRule().getTypeStateAutomaton();
        final NumberedGraph dfa = idfa.asGraph();
        IDFAState start = idfa.initialState();
        Predicate<IDFAState> acceptFilter = this.makeAcceptFilter();
        HashSet<InstanceKey> result = new HashSet<InstanceKey>();
        for (Map.Entry<InstanceKey, Set<IEvent>> e : m.entrySet()) {
            InstanceKey ik = e.getKey();
            final Set<IEvent> events = e.getValue();
            DFSPathFinder<Object> search = new DFSPathFinder<Object>((Graph)dfa, (Object)start, acceptFilter){
                private static final long serialVersionUID = -964543746573101872L;

                protected Iterator<Object> getConnected(Object n) {
                    IDFAState state = (IDFAState)n;
                    HashSet<IDFAState> reached = new HashSet<IDFAState>(dfa.getSuccNodeCount(n));
                    for (IEvent e : events) {
                        IDFAState next = AbstractTypestateSolver.this.getDFA().successor(state, e);
                        if (!dfa.containsNode((Object)next)) continue;
                        reached.add(next);
                    }
                    return reached.iterator();
                }
            };
            if (search.find() == null || !this.appMightRaiseError(events, ik)) continue;
            result.add(ik);
        }
        return result;
    }

    protected boolean appMightRaiseError(Collection<IEvent> events, InstanceKey instance) {
        for (CGNode n : this.getCallGraph()) {
            Collection<CGNode> callers;
            IEvent e;
            if (n.getMethod().isStatic() || !this.getDFA().receives(n.getMethod()) || !events.contains(e = this.getDFA().matchDispatchEvent(n.getMethod().getSignature())) || !this.eventTransitionsToAccept(e) || (callers = this.computeRelevantCallers(Collections.singleton(n), this.toOrdinalInstanceSet(Collections.singleton(instance)))) == null || !this.containsApplicationNode(callers)) continue;
            return true;
        }
        return false;
    }

    protected Map<InstanceKey, Set<IEvent>> mapInstances2Events() throws PropertiesException {
        HashMap<InstanceKey, Set<IEvent>> result = new HashMap<InstanceKey, Set<IEvent>>();
        for (CGNode n : this.getCallGraph()) {
            if (n.getMethod().isStatic() || !this.getDFA().receives(n.getMethod())) continue;
            IEvent e = this.getDFA().matchDispatchEvent(n.getMethod().getSignature());
            PointerKey receiver = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(n, 1);
            OrdinalSet recvrs = this.getPointerAnalysis().getPointsToSet(receiver);
            for (InstanceKey instance : recvrs) {
                Collection<CGNode> callers = this.computeRelevantCallers(Collections.singleton(n), this.toOrdinalInstanceSet(Collections.singleton(instance)));
                if (callers == null || callers.isEmpty()) continue;
                if (this.eventTransitionsOnlyToAccept(e)) {
                    if (!this.containsApplicationNode(callers)) continue;
                    MapUtil.findOrCreateSet(result, (Object)instance).add(e);
                    continue;
                }
                MapUtil.findOrCreateSet(result, (Object)instance).add(e);
            }
        }
        if (this.getDFA().observesProgramExit()) {
            for (Set curr : result.values()) {
                curr.add(IProgramExitEventImpl.singleton());
            }
        }
        if (this.getDFA().observesObjectDeath()) {
            for (Set curr : result.values()) {
                curr.add(IObjectDeathEventImpl.singleton());
            }
        }
        return result;
    }

    protected Collection<CGNode> computeRelevantCallers(Collection<CGNode> targets, OrdinalSet<InstanceKey> receivers) {
        HashSet<CGNode> result = new HashSet<CGNode>();
        for (CGNode t : targets) {
            Iterator it2 = this.getCallGraph().getPredNodes((Object)t);
            block1: while (it2.hasNext()) {
                CGNode caller = (CGNode)it2.next();
                IR ir = caller.getIR();
                Iterator it3 = this.getCallGraph().getPossibleSites(caller, t);
                while (it3.hasNext()) {
                    CallSiteReference site = (CallSiteReference)it3.next();
                    SSAAbstractInvokeInstruction[] calls = ir.getCalls(site);
                    int i = 0;
                    while (i < calls.length) {
                        SSAInvokeInstruction call = (SSAInvokeInstruction)calls[i];
                        if (!(this.getDFA().matchDispatchEvent(caller, call.getDeclaredTarget().getSignature()) == null || this.getBenignOracle().isBenignStatement(caller, call) || this.getDomain() != null && this.getDomain().hasMessage(caller, call))) {
                            int receiver = call.getReceiver();
                            PointerKey r = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, receiver);
                            OrdinalSet pointsTo = this.getPointerAnalysis().getPointsToSet(r);
                            if (pointsTo.containsAny(receivers)) {
                                result.add(caller);
                                continue block1;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    public String toString() {
        return "Solver for " + this.getDFA().toString();
    }

    public TypeStateMetrics getMetrics() {
        return this.metrics;
    }

    protected ITypeStateDFA getDFA() {
        return this.dfa;
    }

    protected TypeStateProperty getDFAAsProperty() {
        assert (this.getDFA() instanceof TypeStateProperty);
        return (TypeStateProperty)this.getDFA();
    }

    protected TypeStateResult solveForInstances(Collection<InstanceKey> instances, AnalysisCache ac) throws WalaException, PropertiesException, SetUpException, CancelException {
        OrdinalSet<InstanceKey> instanceSet = this.toOrdinalInstanceSet(instances);
        this.logger.fine(() -> "original callgraph: " + this.getCallGraph().getNumberOfNodes());
        Collection<CGNode> relevantNodes = this.computeNodesThatMatter(instanceSet);
        this.logger.fine(() -> "sliced callgraph: " + relevantNodes.size());
        if (relevantNodes.size() == 0) {
            Trace.println((String)"Found no relevant events!");
            return null;
        }
        WholeProgramSupergraph supergraph = this.buildSupergraph(ac, relevantNodes);
        if (this.getOptions().shouldCollectStatistics()) {
            this.getMetrics().recordSupergraphSize(supergraph.getNumberOfNodes());
        }
        this.checkGraph((ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode>)supergraph);
        TypeStateProblem p = this.createTypeStateProblem(supergraph, instances);
        if (this.getOptions().shouldMineDFA()) {
            ((TracingProperty)this.getDFA()).createInitial((AbstractUnification)p.getMergeFunction());
        }
        TabulationSolver solver = TabulationSolver.make((TabulationProblem)p);
        TabulationResult r = solver.solve();
        if (this.supportsWitnessGeneration() && this.getOptions().shouldGenerateWitness()) {
            try {
                this.getDomain().populateWitnesses(solver);
            }
            catch (UnsupportedOperationException e) {
                System.err.println("WARNING: could not populate witness due to " + e.getMessage());
            }
        }
        return new TypeStateResult((TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, Factoid>)r, this.getDomain(), supergraph);
    }

    public ISolverResult perform(IProgressMonitor monitor) throws WalaException, SolverTimeoutException, PropertiesException, MaxFindingsException, SetUpException, CancelException {
        AnalysisCacheImpl ac = new AnalysisCacheImpl();
        monitor.beginTask(null, 1);
        monitor.subTask(this.toString());
        AggregateSolverResult result = new AggregateSolverResult();
        BenignOracle oracle = this.getBenignOracle();
        try {
            boolean hasPropertyType = this.initializeProperty();
            if (hasPropertyType) {
                this.initializeNoCollapseSet();
                Collection<InstanceKey> instances = this.computeTrackedInstances();
                result.addPotentialInstances(instances);
                Map<InstanceKey, Set<Pair<CGNode, SSAInstruction>>> potentialErrors = null;
                if (!this.getOptions().shouldMineDFA()) {
                    assert (this.getDFA() instanceof TypeStateProperty);
                    TypeStateProperty property = (TypeStateProperty)this.getDFA();
                    potentialErrors = oracle.possibleErrorLocations(property);
                }
                if (this.getOptions().shouldCollectStatistics() && !this.getOptions().shouldMineDFA()) {
                    this.getMetrics().setNumberOfCandidateStatements(this.getPropertyName(), this.countCandidateStatements(this.computeTrackedInstancesByType()));
                }
                for (InstanceKey theInstance : instances) {
                    if (!oracle.isBenignInstanceKey(theInstance)) {
                        Set<InstanceKey> oneInstance = Collections.singleton(theInstance);
                        this.logger.info(() -> "Solve for " + theInstance);
                        this.initializeDomain(oneInstance);
                        TypeStateResult baseResult = this.solveForInstances(oneInstance, (AnalysisCache)ac);
                        result.addInstanceResult(theInstance, (ISolverResult)baseResult);
                    } else {
                        result.addSkippedInstance(theInstance);
                        System.err.println("Skipped benign instance " + theInstance);
                    }
                    if (!Thread.interrupted()) continue;
                    throw new SolverTimeoutException((ISolverResult)result);
                }
                if (!this.getOptions().shouldMineDFA()) {
                    this.updateBenignOracle(result, instances, potentialErrors);
                }
            } else {
                Trace.println((String)"---No instances of property Type were found---");
            }
        }
        finally {
            monitor.done();
            if (this.getOptions().shouldMineDFA() && this.getOptions().shouldCollectStatistics()) {
                this.dumpMetrics();
            }
        }
        return result;
    }

    protected void dumpMetrics() {
        if (this.getMetrics() == null) {
            return;
        }
        CallGraphMetricsByLoader primMetrics = this.getMetrics().getCallGraphMetrics(ClassLoaderReference.Primordial);
        CallGraphMetricsByLoader appMetrics = this.getMetrics().getCallGraphMetrics(ClassLoaderReference.Application);
        System.out.println(primMetrics.toString());
        System.out.println(appMetrics.toString());
    }

    protected void updateBenignOracle(AggregateSolverResult result, Collection<InstanceKey> potentialInstances, Map<InstanceKey, Set<Pair<CGNode, SSAInstruction>>> potentialErrors) {
        HashSet<InstanceKey> errInstances = new HashSet<InstanceKey>();
        HashSet errInstructions = HashSetFactory.make();
        Iterator<InstanceKey> it = result.iterateInstances();
        while (it.hasNext()) {
            InstanceKey key = (InstanceKey)it.next();
            ISolverResult curr = result.getInstanceResult(key);
            Set messages = curr.getMessages();
            for (TypeStateMessage msg : messages) {
                InstanceKey errInstance = msg.getInstance();
                CGNode errNode = msg.getCaller();
                SSAInstruction errInstr = msg.getInstruction();
                errInstances.add(errInstance);
                errInstructions.add(Pair.make((Object)errNode, (Object)errInstr));
            }
        }
        for (InstanceKey curr : potentialInstances) {
            Collection currErrors;
            if (!errInstances.contains(curr)) {
                this.getBenignOracle().addBenignInstanceKey(curr);
            }
            if ((currErrors = (Collection)potentialErrors.get(curr)) == null) continue;
            for (Pair p : currErrors) {
                if (errInstructions.contains(p)) continue;
                this.getBenignOracle().addBenignStatement((CGNode)p.fst, (SSAInstruction)p.snd);
            }
        }
    }

    protected void addAllCalleesOfEventSites(Collection<CGNode> slice, Collection<CGNode> eventNodes) {
        for (CGNode event : eventNodes) {
            if (!slice.contains(event)) continue;
            Iterator it2 = this.getCallGraph().getPredNodes((Object)event);
            while (it2.hasNext()) {
                CGNode caller = (CGNode)it2.next();
                Iterator it3 = this.getCallGraph().getPossibleSites(caller, event);
                while (it3.hasNext()) {
                    CallSiteReference site = (CallSiteReference)it3.next();
                    slice.addAll(this.getCallGraph().getPossibleTargets(caller, site));
                }
            }
        }
    }

    protected abstract TypeStateProblem createTypeStateProblem(ICFGSupergraph var1, Collection<InstanceKey> var2) throws WalaException, PropertiesException;

    protected int countCandidateStatements(Collection<InstanceKey> instances) {
        int count = 0;
        for (CGNode n : this.getCallGraph()) {
            String sig;
            IEvent e;
            if (n.getMethod().isStatic()) continue;
            assert (this.getDFA() instanceof TypeStateProperty);
            TypeStateProperty property = (TypeStateProperty)this.getDFA();
            if (!property.receives(n.getMethod()) || !property.eventTransitionsToAccept(e = property.matchDispatchEvent(sig = n.getMethod().getSignature()))) continue;
            Iterator it2 = this.getCallGraph().getPredNodes((Object)n);
            while (it2.hasNext()) {
                CGNode caller = (CGNode)it2.next();
                if (!this.isApplicationNode(caller)) continue;
                IR ir = caller.getIR();
                Iterator it3 = this.getCallGraph().getPossibleSites(caller, n);
                block2: while (it3.hasNext()) {
                    CallSiteReference site = (CallSiteReference)it3.next();
                    SSAAbstractInvokeInstruction[] calls = ir.getCalls(site);
                    int i = 0;
                    while (i < calls.length) {
                        int recv = calls[i].getReceiver();
                        PointerKey pk = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, recv);
                        Collection c = OrdinalSet.toCollection((OrdinalSet)this.getPointerAnalysis().getPointsToSet(pk));
                        if (c.removeAll(instances)) {
                            ++count;
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
        }
        return count;
    }

    protected TraceReporter getTraceReporter() {
        return this.traceReporter;
    }

    @Override
    protected TypeStateOptions getOptions() {
        return (TypeStateOptions)this.options;
    }
}

