/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.controller;

import com.ibm.safe.controller.AbstractSafeController;
import com.ibm.safe.controller.BasicResultObserver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.CompositeSolverRunner;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.runners.ISolverRunner;
import com.ibm.safe.typestate.controller.TypeStateSolverRunner;
import com.ibm.safe.typestate.controller.TypestateRulesManager;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.options.TypestateProperties;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypestateController
extends AbstractSafeController {
    public TypestateController(PropertiesManager properties) {
        super(properties);
    }

    protected boolean isMining() throws PropertiesException {
        return this.propertiesManager.getBooleanValue((PropertiesManager.IPropertyDescriptor)TypestateProperties.Props.MINE_DFA);
    }

    public void execute(IRule[] rules, IReporter reporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        if (!(this.isMining() || rules != null && rules.length != 0)) {
            throw new SetUpException("No SAFE rules have been provided.");
        }
        CompositeSolverRunner solverRunner = new CompositeSolverRunner();
        PerformanceTracker perfoTracker = this.shouldUsePerfomanceTracker() ? new PerformanceTracker("Safe engine tracking report\n", PerformanceTracker.Kind.GLOBAL) : null;
        TypestateRulesManager rulesManager = new TypestateRulesManager(rules);
        rulesManager.applyFilters(this.propertiesManager);
        TypestateRule[] typeStateRules = rulesManager.getTypeStateRules();
        this.reportRulesActivated(reporter, typeStateRules);
        if (this.hasTypeStateOptionsActivated() && (typeStateRules.length > 0 || this.propertiesManager.getBooleanValue((PropertiesManager.IPropertyDescriptor)TypestateProperties.Props.MINE_DFA))) {
            TypeStateOptions tso = new TypeStateOptions(this.propertiesManager, (IRule[])typeStateRules);
            solverRunner.addSolverRunner(this.getTypeStateSolverRunner(tso, typeStateRules, perfoTracker, reporter));
        }
        if (solverRunner.isEmpty()) {
            throw new SetUpException("No solver options have been identified.\nAt least one structural or typestate option and rule should be activated.");
        }
        this.execute(solverRunner, perfoTracker, reporter, reporter, monitor);
    }

    public ISolverRunner getTypeStateSolverRunner(TypeStateOptions typestateOptions, TypestateRule[] rules, PerformanceTracker perfoTracker, IReporter reporter) {
        return new TypeStateSolverRunner(typestateOptions, (IRule[])rules, perfoTracker, reporter);
    }

    protected void execute(CompositeSolverRunner solverRunner, PerformanceTracker perfoTracker, IReporter originalReporter, IReporter realReporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        try {
            try {
                if (this.shouldCreateDomoReport()) {
                    Trace.setTraceFile((String)this.propertiesManager.getStringValue((PropertiesManager.IPropertyDescriptor)CommonProperties.Props.DOMO_REPORT));
                }
                if (this.isVerboseMode()) {
                    this.displaySafeVersion(realReporter);
                }
                BasicResultObserver resultObserver = new BasicResultObserver(realReporter);
                monitor.beginTask(null, 1);
                solverRunner.run((IResultObserver)resultObserver, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                originalReporter.reportNumberOfFindings(resultObserver.getNumberOfFindings());
            }
            catch (SafeException except) {
                realReporter.reportException((Throwable)except);
                throw except;
            }
        }
        finally {
            if (perfoTracker != null) {
                realReporter.reportPerformanceTracking(perfoTracker);
                if (this.shouldCreateDomoReport()) {
                    Trace.print((String)perfoTracker.reportPerformanceTracking());
                }
            }
            try {
                realReporter.produceFinalReport();
            }
            catch (Exception except) {
                except.printStackTrace();
                SafeLogger.severe((String)"Unable to create XML report.");
            }
        }
    }

    protected void reportRulesActivated(IReporter reporter, TypestateRule[] typeStateRules) throws SetUpException, PropertiesException {
        if (!this.isMining() && typeStateRules.length == 0) {
            throw new SetUpException("No SAFE rules have been activated after the selection of the ones loaded.");
        }
        this.reportRulesActivated(reporter, (IRule[])typeStateRules);
    }
}

