/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.controller;

import com.ibm.safe.callgraph.CallGraphEngine;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.internal.runners.WholeProgramSolverRunner;
import com.ibm.safe.metrics.IMetrics;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.Messages;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.typestate.controller.TypeStateSolverCreator;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypeStateSolverRunner
extends WholeProgramSolverRunner {
    protected TypestateRule[] rules;

    public TypeStateSolverRunner(TypeStateOptions properties, IRule[] typeStateRules, PerformanceTracker perfoTracker, IReporter reporter) {
        super((PropertiesManager)properties, perfoTracker, reporter);
        this.rules = (TypestateRule[])typeStateRules;
    }

    public void run(IResultObserver observer, IProgressMonitor monitor) throws SafeException, IllegalArgumentException, CancelException, CoreException {
        TraceReporter tReporter = this.shouldMineDFA() ? this.makeTraceReporter() : null;
        SubProgressMonitor cgMonitor = new SubProgressMonitor(monitor, 8);
        CallGraphEngine cge = this.createCallGraphEngine((IProgressMonitor)cgMonitor);
        cge.setInterestingTypes(this.getPropertyTypes());
        TypeStateSolverCreator creator = new TypeStateSolverCreator(cge, this.getManager(), this.getReporter(), this.getPerformanceTracker(), tReporter);
        monitor.beginTask(null, 20);
        monitor.subTask(Messages.TypeStateSolverRunner_CreateCallGraph);
        ISafeSolver[] solvers = creator.createSolvers();
        this.runSolvers(solvers, observer, AbstractSolverRunner.AnalysisKind.TYPESTATE, PerformanceTracker.Stages.TYPESTATE, (IProgressMonitor)new SubProgressMonitor(monitor, 12));
        if (creator.getMetrics() != null) {
            this.getReporter().reportStatistics((IMetrics)creator.getMetrics());
        }
        if (this.shouldMineDFA()) {
            try {
                tReporter.persist();
            }
            catch (WalaException e) {
                throw new SafeException("trace persist failed", (Throwable)e);
            }
        }
    }

    public void setRules(TypestateRule[] typestateRules) {
        this.rules = typestateRules;
    }

    public String toString() {
        return "TypeState";
    }

    protected String getTVLAFileName(String dir, String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return fileName;
        }
        if (dir == null) {
            Trace.println((String)"Expected to find here the output dir - wierd!");
            return fileName;
        }
        String fullName = String.valueOf(dir) + File.separator + fileName;
        return fullName;
    }

    protected String computeTVLAAnalysisDir(String rootDir, String subDir) {
        String dir = null;
        dir = rootDir == null ? subDir : (subDir == null ? rootDir : String.valueOf(rootDir) + subDir);
        return dir;
    }

    protected TraceReporter makeTraceReporter() throws PropertiesException {
        TypeStateOptions tso = this.getManager();
        assert (tso.getShortProgramName() != null) : "mining: must specify -" + CommonProperties.Props.SHORT_PROGRAM_NAME.getName();
        return new TraceReporter(tso.getTypeStateSolverKindString(), tso.getMineMergeKindString(), tso.getMineType(), tso.getShortProgramName(), tso.getOutputDirectory(), tso.getAbstractTraceFileName());
    }

    protected TypeStateOptions getManager() {
        return (TypeStateOptions)this.propertiesManager;
    }

    private String[] getPropertyTypes() {
        HashSet propertyTypes = HashSetFactory.make();
        int i = 0;
        while (i < this.rules.length) {
            for (String typeDef : this.rules[i].getTypes()) {
                propertyTypes.add(typeDef);
            }
            ++i;
        }
        return propertyTypes.toArray(new String[propertyTypes.size()]);
    }
}

