/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.controller;

import com.ibm.safe.callgraph.CallGraphEngine;
import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.io.DotWriter;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.core.TypestateSolverFactory;
import com.ibm.safe.typestate.io.TypeStatePropertyDotWriter;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.TracingProperty;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.escape.FILiveObjectAnalysis;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TypeStateSolverCreator {
    protected final CallGraphEngine callGraphEngine;
    protected final TypeStateOptions options;
    protected final TypeStateMetrics metrics;
    protected final IReporter reporter;
    protected final PerformanceTracker perfTracker;
    protected final TraceReporter traceReporter;

    public TypeStateSolverCreator(CallGraphEngine domoCallGraphBuilder, TypeStateOptions typeStateOptions, IReporter reporter, PerformanceTracker perfTracker, TraceReporter traceReporter) throws SafeException, IllegalArgumentException, CancelException {
        this.callGraphEngine = domoCallGraphBuilder;
        this.options = typeStateOptions;
        this.reporter = reporter;
        this.perfTracker = perfTracker;
        this.traceReporter = traceReporter;
        this.computeCallGraph(typeStateOptions.shouldDumpCallGraph());
        if (typeStateOptions.shouldCreatePointsToDotFile()) {
            DotWriter.write((String)typeStateOptions.getPointsToDotFile(), (PointerAnalysis)this.callGraphEngine.getPointerAnalysis());
        }
        this.metrics = typeStateOptions.shouldCollectStatistics() ? new TypeStateMetrics(this.callGraphEngine.getCallGraph().getClassHierarchy(), this.callGraphEngine.getCallGraph()) : null;
    }

    public ISafeSolver[] createSolvers() throws SafeException, CancelException {
        HeapGraph hg = this.callGraphEngine.getPointerAnalysis().getHeapGraph();
        Collection<Object> solvers = null;
        if (this.options.shouldMineDFA()) {
            Assertions.productionAssertion((this.options.getRules().length == 0 ? 1 : 0) != 0, (String)"don't specify rules when mining");
            solvers = this.createMiners(hg, this.traceReporter);
        } else {
            TypestateRule[] rules = this.options.getRules();
            solvers = new ArrayList(rules.length);
            HashSet<TypeStateProperty> typeStatePropertySet = new HashSet<TypeStateProperty>(rules.length);
            this.createVerifiers(rules, solvers, typeStatePropertySet, hg);
            if (this.options.shouldCreatePropertyDotFile()) {
                TypeStatePropertyDotWriter.write(this.options.getPropertyDotFile(), typeStatePropertySet);
            }
        }
        return solvers.toArray(new ISafeSolver[solvers.size()]);
    }

    private Collection<ISafeSolver> createMiners(HeapGraph hg, TraceReporter traceReporter) throws PropertiesException, CancelException {
        HashSet result = HashSetFactory.make();
        String type = this.options.getMineType();
        Assertions.productionAssertion((type != null ? 1 : 0) != 0, (String)"mine_type cannot be null!");
        type = StringStuff.deployment2CanonicalTypeString((String)type);
        TypeReference t = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)type);
        IClass klass = this.callGraphEngine.getCallGraph().getClassHierarchy().lookupClass(t);
        Assertions.productionAssertion((klass != null ? 1 : 0) != 0, (String)("Failed to find class " + t));
        TracingProperty dfa = this.createTypeStateTracer(klass);
        BenignOracle ora = new BenignOracle(this.callGraphEngine.getCallGraph(), this.callGraphEngine.getPointerAnalysis());
        result.add(TypestateSolverFactory.getSolver(this.callGraphEngine.getAnalysisOptions(), this.callGraphEngine.getCallGraph(), this.callGraphEngine.getPointerAnalysis(), hg, dfa, ora, this.options, this.metrics, this.reporter, this.perfTracker, traceReporter));
        return result;
    }

    protected void createVerifiers(TypestateRule[] rules, Collection<ISafeSolver> solvers, Set<TypeStateProperty> typeStatePropertySet, HeapGraph hg) throws PropertiesException, CancelException {
        int i = 0;
        while (i < rules.length) {
            TypeStateProperty property = this.createTypeStateProperty(rules[i]);
            typeStatePropertySet.add(property);
            BenignOracle ora = new BenignOracle(this.callGraphEngine.getCallGraph(), this.callGraphEngine.getPointerAnalysis());
            solvers.add(TypestateSolverFactory.getSolver(this.callGraphEngine.getAnalysisOptions(), this.callGraphEngine.getCallGraph(), this.callGraphEngine.getPointerAnalysis(), hg, property, ora, this.options, this.metrics, this.reporter, this.perfTracker, this.traceReporter));
            ++i;
        }
    }

    public static ILiveObjectAnalysis computeLiveObjectAnalysis(CallGraph cg, HeapGraph hg, boolean expensiveLiveAnalysis) {
        return new FILiveObjectAnalysis(cg, hg, expensiveLiveAnalysis);
    }

    private void computeCallGraph(boolean shouldDumpCallGraph) throws SafeException, IllegalArgumentException, CancelException {
        this.callGraphEngine.computeCallGraph();
        if (Trace.getTraceFile() != null && shouldDumpCallGraph) {
            Trace.println((Object)this.callGraphEngine.getCallGraph());
        }
    }

    private TracingProperty createTypeStateTracer(IClass klass) {
        return new TracingProperty(this.callGraphEngine.getCallGraph().getClassHierarchy(), Collections.singleton(klass));
    }

    protected TypeStateProperty createTypeStateProperty(TypestateRule rule) {
        TypeStateProperty result = new TypeStateProperty(rule, this.callGraphEngine.getCallGraph().getClassHierarchy());
        result.validate();
        return result;
    }

    private String[] getPropertyTypes() {
        HashSet propertyTypes = HashSetFactory.make();
        TypestateRule[] rules = this.options.getRules();
        int i = 0;
        while (i < rules.length) {
            for (String typeDef : rules[i].getTypes()) {
                propertyTypes.add(typeDef);
            }
            ++i;
        }
        return propertyTypes.toArray(new String[propertyTypes.size()]);
    }

    public TypeStateMetrics getMetrics() {
        return this.metrics;
    }
}

