/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.base;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.typestate.base.BaseProblem;
import com.ibm.safe.typestate.base.BaseTypeStateDomain;
import com.ibm.safe.typestate.core.AbstractTypestateSolver;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.core.TypeStateProblem;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.rules.InstanceBatchIterator;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class BaseSolver
extends AbstractTypestateSolver {
    static final boolean NO_PROPAGATE_ACCEPT = true;

    public BaseSolver(CallGraph cg, PointerAnalysis pointerAnalysis, ITypeStateDFA dfa, TypeStateOptions options, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, TraceReporter traceReporter, IMergeFunctionFactory mergeFactory) {
        super(cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        assert (dfa != null);
        if (!(dfa instanceof TypeStateProperty)) assert (traceReporter != null);
    }

    @Override
    protected TypeStateProblem createTypeStateProblem(ICFGSupergraph supergraph, Collection<InstanceKey> instances) throws WalaException {
        return new BaseProblem(this.getCallGraph(), this.getPointerAnalysis(), supergraph, this.getDomain(), this.getDFA(), instances, this.getLiveObjectAnalysis(), this.getTraceReporter(), this.getMergeFactory().create(this.getDomain()));
    }

    @Override
    public String toString() {
        assert (this.getDFA() != null);
        return "Solver for " + this.getDFA().toString();
    }

    @Override
    protected Collection<CGNode> computeNodesThatMatter(OrdinalSet<InstanceKey> instances) throws WalaException, PropertiesException {
        if (this.getOptions().shouldSliceSupergraph()) {
            Assertions.productionAssertion((this.getLiveObjectAnalysis() != null ? 1 : 0) != 0, (String)"expected non-null live object analysis in order to slice supergraph");
            Collection<CGNode> eventNodes = this.scanForEventNodes(instances);
            Collection<CGNode> relevantCallers = this.computeRelevantCallers(eventNodes, instances);
            relevantCallers.removeAll(eventNodes);
            relevantCallers.addAll(this.computeAllocators(instances));
            Predicate<CGNode> liveFilter = BaseSolver.makeLiveNodeFilter(instances, this.getLiveObjectAnalysis());
            Graph pruned = GraphSlicer.prune((Graph)this.getCallGraph(), liveFilter);
            Collection<Object> result = GraphSlicer.slice((Graph)pruned, (Predicate)new CollectionFilter(relevantCallers));
            result = this.getMinimumSpanningTree((Graph<CGNode>)this.getCallGraph(), this.getCallGraph().getFakeRootNode(), (Collection<CGNode>)result);
            result.addAll(eventNodes);
            this.addAllCalleesOfEventSites(result, eventNodes);
            return result;
        }
        return Iterator2Collection.toList((Iterator)this.getCallGraph().iterator());
    }

    private Collection<CGNode> computeAllocators(OrdinalSet<InstanceKey> instances) {
        HashSet result = HashSetFactory.make();
        for (InstanceKey ik : instances) {
            if (ik instanceof AllocationSiteInNode) {
                result.add(((AllocationSiteInNode)ik).getNode());
                continue;
            }
            if (ik instanceof ConcreteTypeKey) {
                IClass type = ((ConcreteTypeKey)ik).getConcreteType();
                result.addAll(this.scanForAllocators(type));
                continue;
            }
            Assertions.UNREACHABLE((String)("unexpected instance key type: " + ik.getClass()));
        }
        return result;
    }

    private Collection<CGNode> scanForAllocators(IClass type) {
        HashSet result = HashSetFactory.make();
        block0: for (CGNode n : this.getCallGraph()) {
            Iterator it2 = n.iterateNewSites();
            while (it2.hasNext()) {
                NewSiteReference site = (NewSiteReference)it2.next();
                IClass klass = this.getCallGraph().getClassHierarchy().lookupClass(site.getDeclaredType());
                if (klass == null || !type.equals(klass)) continue;
                result.add(n);
                continue block0;
            }
        }
        return result;
    }

    @Override
    protected void initializeDomain(Collection<InstanceKey> instances) {
        this.setDomain(new BaseTypeStateDomain(this.getDFA(), this.getOptions()));
    }

    @Override
    protected InstanceBatchIterator makeBatchIterator(Collection<InstanceKey> allInstances) {
        return InstanceBatchIterator.makeNoSeparation(allInstances);
    }

    @Override
    protected boolean supportsWitnessGeneration() {
        return false;
    }
}

