/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.base;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.base.BaseAllocationFlowFunction;
import com.ibm.safe.typestate.base.BaseCallFlowFunction;
import com.ibm.safe.typestate.base.BaseProgramExitFlowFunction;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.core.TypeStateFunctionProvider;
import com.ibm.safe.typestate.core.TypeStatePropertyContext;
import com.ibm.safe.typestate.core.UniversalKillFlowFunction;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.TracingProperty;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class BaseFunctionProvider
extends TypeStateFunctionProvider {
    public BaseFunctionProvider(CallGraph cg, PointerAnalysis pointerAnalysis, ICFGSupergraph supergraph, TypeStateDomain domain, ITypeStateDFA dfa, Collection<InstanceKey> trackedInstances, ILiveObjectAnalysis live, TraceReporter traceReporter) {
        super(cg, domain, dfa, supergraph, pointerAnalysis, trackedInstances, live, traceReporter);
    }

    protected IReversibleFlowFunction makeNonEntryCallFunction(OrdinalSet<InstanceKey> relevantInstances, IEvent event, BasicBlockInContext<IExplodedBasicBlock> srcBlock, SSAInvokeInstruction srcInvokeInstr, CGNode caller, CGNode callee, BasicBlockInContext<IExplodedBasicBlock> destBlock) {
        return new BaseCallFlowFunction(this.getDomain(), this.getDFA(), relevantInstances, event, srcBlock, srcInvokeInstr, caller);
    }

    protected IReversibleFlowFunction makeAllocationFlowFunction(OrdinalSet<InstanceKey> relevantInstances) {
        return new BaseAllocationFlowFunction(this.getDomain(), relevantInstances);
    }

    @Override
    public IUnaryFlowFunction makeNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        OrdinalSet<InstanceKey> affectedInstances = this.getInstancesAllocated(src);
        if (affectedInstances.size() > 0) {
            return this.makeAllocationFlowFunction(affectedInstances);
        }
        return IdentityFlowFunction.identity();
    }

    protected OrdinalSet<InstanceKey> getInstancesAllocated(BasicBlockInContext<IExplodedBasicBlock> src) {
        Collection<InstanceKey> allocKeys = this.getInstanceKeysAllocatedInBasicBlock(this.getSupergraph(), this.getCallGraph().getClassHierarchy(), this.getCallGraph(), this.getDFA(), this.getPointerAnalysis(), src);
        MutableSparseIntSet affected = MutableSparseIntSet.makeEmpty();
        for (InstanceKey ik : this.getTrackedInstanceSet()) {
            if (!allocKeys.contains(ik)) continue;
            affected.add(this.getPointerAnalysis().getInstanceKeyMapping().getMappedIndex((Object)ik));
        }
        OrdinalSet affectedInstances = new OrdinalSet((IntSet)affected, this.getPointerAnalysis().getInstanceKeyMapping());
        return affectedInstances;
    }

    protected Collection<InstanceKey> getInstanceKeysAllocatedInBasicBlock(ICFGSupergraph supergraph, IClassHierarchy classHierarchy, CallGraph callGraph, ITypeStateDFA dfa, PointerAnalysis pointerAnalysis, BasicBlockInContext<IExplodedBasicBlock> bb) {
        CGNode n = supergraph.getProcOf(bb);
        IR ir = n.getIR();
        HashSet result = HashSetFactory.make((int)5);
        SSAInstruction[] statements = ir.getInstructions();
        final class Visitor
        extends SSAInstruction.Visitor {
            private final /* synthetic */ IClassHierarchy val$classHierarchy;
            private final /* synthetic */ ITypeStateDFA val$dfa;
            private final /* synthetic */ PointerAnalysis val$pointerAnalysis;
            private final /* synthetic */ ICFGSupergraph val$supergraph;
            private final /* synthetic */ BasicBlockInContext val$bb;
            private final /* synthetic */ HashSet val$result;

            Visitor(IClassHierarchy iClassHierarchy, ITypeStateDFA iTypeStateDFA, PointerAnalysis pointerAnalysis, ICFGSupergraph iCFGSupergraph, BasicBlockInContext basicBlockInContext, HashSet hashSet) {
                this.val$classHierarchy = iClassHierarchy;
                this.val$dfa = iTypeStateDFA;
                this.val$pointerAnalysis = pointerAnalysis;
                this.val$supergraph = iCFGSupergraph;
                this.val$bb = basicBlockInContext;
                this.val$result = hashSet;
            }

            public void visitNew(SSANewInstruction instruction) {
                TypeReference allocatedType = instruction.getConcreteType();
                IClass theClass = this.val$classHierarchy.lookupClass(allocatedType);
                if (theClass == null) {
                    Trace.println((String)("Allocated type not found: " + allocatedType));
                }
                if (theClass != null && TypeStatePropertyContext.isTrackedType(this.val$classHierarchy, this.val$dfa.getTypes(), theClass)) {
                    PointerKey pLocalKey = this.val$pointerAnalysis.getHeapModel().getPointerKeyForLocal(this.val$supergraph.getProcOf(this.val$bb), instruction.getDef());
                    Iterator iter = this.val$pointerAnalysis.getPointsToSet(pLocalKey).iterator();
                    while (iter.hasNext()) {
                        this.val$result.add((InstanceKey)iter.next());
                    }
                }
            }
        }
        Visitor v = new Visitor(classHierarchy, dfa, pointerAnalysis, supergraph, bb, result);
        int first = bb.getFirstInstructionIndex();
        int last = bb.getLastInstructionIndex();
        if (first >= 0 && last >= 0) {
            int i = first;
            while (i <= last) {
                SSAInstruction s = statements[i];
                if (s != null) {
                    s.visit((SSAInstruction.IVisitor)v);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    protected IUnaryFlowFunction getNonEntryCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        SSAInvokeInstruction srcInvokeInstr;
        Object resultFlowFunction = IdentityFlowFunction.identity();
        CGNode callee = this.getSupergraph().getProcOf(dest);
        IEvent event = this.getEventForNode(callee);
        if (event != null && this.getDFA() instanceof TracingProperty) {
            CGNode caller = this.getSupergraph().getProcOf(src);
            event = this.getDFA().matchDispatchEvent(caller, callee.getMethod().getSignature());
        }
        if (event != null && !(srcInvokeInstr = TypeStateFunctionProvider.getLastCallInstruction(this.getCFG(src), src)).isStatic()) {
            int rcv = srcInvokeInstr.getReceiver();
            CGNode caller = this.getSupergraph().getProcOf(src);
            PointerKey p = this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, rcv);
            OrdinalSet pointsTo = this.getPointerAnalysis().getPointsToSet(p);
            OrdinalSet relevantInstances = OrdinalSet.intersect((OrdinalSet)pointsTo, this.getTrackedInstanceSet());
            resultFlowFunction = relevantInstances.size() == 0 ? IdentityFlowFunction.identity() : this.makeNonEntryCallFunction((OrdinalSet<InstanceKey>)relevantInstances, event, src, srcInvokeInstr, caller, callee, dest);
        }
        return resultFlowFunction;
    }

    @Override
    public IUnaryFlowFunction getProgramExitFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (!this.getDFA().observesProgramExit()) {
            return UniversalKillFlowFunction.kill();
        }
        SSAInvokeInstruction srcInvokeInstr = null;
        CGNode caller = this.getSupergraph().getProcOf(src);
        return new BaseProgramExitFlowFunction(this.getDomain(), this.getDFA(), src, srcInvokeInstr, caller, this.getTraceReporter());
    }
}

