/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.base;

import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.typestate.base.BaseFactoid;
import com.ibm.safe.typestate.core.TypeStateDomain;
import com.ibm.safe.typestate.core.TypeStateFunctionProvider;
import com.ibm.safe.typestate.core.TypeStateMessage;
import com.ibm.safe.typestate.core.TypeStateProperty;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Set;

public class BaseCallFlowFunction
implements IReversibleFlowFunction {
    private TypeStateDomain domain;
    private OrdinalSet<InstanceKey> instances;
    private IEvent automatonLabel;
    private ITypeStateDFA dfa;
    private SSAInvokeInstruction invokeInstr;
    private BasicBlockInContext<IExplodedBasicBlock> invokeBlock;
    private CGNode caller;

    public BaseCallFlowFunction(TypeStateDomain domain, ITypeStateDFA dfa, OrdinalSet<InstanceKey> instances, IEvent event, BasicBlockInContext<IExplodedBasicBlock> block, SSAInvokeInstruction invokeInstr, CGNode caller) {
        this.domain = domain;
        this.dfa = dfa;
        this.instances = instances;
        this.automatonLabel = event;
        this.invokeInstr = invokeInstr;
        this.invokeBlock = block;
        this.caller = caller;
    }

    public SparseIntSet getTargets(int d1) {
        if (d1 == 0) {
            return SparseIntSet.singleton((int)0);
        }
        BaseFactoid inputFact = (BaseFactoid)this.domain.getMappedObject(d1);
        SparseIntSet result = SparseIntSet.singleton((int)d1);
        if (this.getInstances().contains((Object)inputFact.instance)) {
            IDFAState succState = this.dfa.successor(inputFact.state, this.automatonLabel);
            if (!inputFact.state.isAccepting() && succState.isAccepting()) {
                if (TypeStateFunctionProvider.nodeInApplication(this.caller)) {
                    this.domain.addMessage(this.makeMessage(inputFact));
                }
                succState = inputFact.state;
            }
            int newStateIndex = this.domain.getIndexForStateDelta(inputFact, succState);
            result = this.strongUpdate(inputFact) ? SparseIntSet.singleton((int)newStateIndex) : (newStateIndex == d1 ? SparseIntSet.singleton((int)newStateIndex) : SparseIntSet.pair((int)newStateIndex, (int)d1));
        }
        return result;
    }

    private TypeStateMessage makeMessage(BaseFactoid inputFact) {
        return new TypeStateMessage(this.getDFAAsProperty(), inputFact, this.caller, this.invokeBlock, this.invokeInstr, this.caller);
    }

    protected boolean strongUpdate(BaseFactoid inputFact) {
        return false;
    }

    public SparseIntSet getSources(int d2) {
        if (d2 == 0) {
            return SparseIntSet.singleton((int)0);
        }
        BaseFactoid fact = (BaseFactoid)this.domain.getMappedObject(d2);
        if (this.instances.contains((Object)fact.instance)) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            if (!this.strongUpdate(fact)) {
                result.add(d2);
            }
            Set<IDFAState> predStates = this.dfa.predecessors(fact.state, this.automatonLabel);
            for (IDFAState state : predStates) {
                int prevStateIndex = this.domain.getIndexForStateDelta(fact, state);
                result.add(prevStateIndex);
            }
            if (predStates.isEmpty()) {
                result.add(d2);
            }
            return result;
        }
        return SparseIntSet.singleton((int)d2);
    }

    public IEvent getAutomatonLabel() {
        return this.automatonLabel;
    }

    public TypeStateProperty getDFAAsProperty() {
        assert (this.getDFA() instanceof TypeStateProperty);
        return (TypeStateProperty)this.getDFA();
    }

    public ITypeStateDFA getDFA() {
        return this.dfa;
    }

    public TypeStateDomain getDomain() {
        return this.domain;
    }

    public OrdinalSet<InstanceKey> getInstances() {
        return this.instances;
    }

    public CGNode getCaller() {
        return this.caller;
    }

    public IBasicBlock getInvokeBlock() {
        return this.invokeBlock;
    }

    public SSAInvokeInstruction getInvokeInstr() {
        return this.invokeInstr;
    }
}

