/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.ap.must;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathSet;
import com.ibm.safe.accesspath.AccessPathSetTransformers;
import com.ibm.safe.accesspath.ArrayContentsPathElement;
import com.ibm.safe.accesspath.InstanceFieldPathElement;
import com.ibm.safe.accesspath.LocalPathElement;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.accesspath.StaticFieldPathElement;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.typestate.ap.AccessPathFunctionProvider;
import com.ibm.safe.typestate.ap.TemporaryParameterPointerKey;
import com.ibm.safe.typestate.ap.must.MustAuxiliary;
import com.ibm.safe.typestate.base.BaseProgramExitFlowFunction;
import com.ibm.safe.typestate.core.UniversalKillFlowFunction;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.quad.QuadFactoid;
import com.ibm.safe.typestate.quad.QuadTypeStateDomain;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.safe.typestate.unique.UniqueReturnFlowFunction;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphReachability;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractMustAPFunctionProvider
extends AccessPathFunctionProvider {
    public AbstractMustAPFunctionProvider(CallGraph cg, PointerAnalysis pointerAnalysis, ICFGSupergraph supergraph, QuadTypeStateDomain domain, ITypeStateDFA dfa, Collection<InstanceKey> trackedInstances, AccessPathSetTransformers apst, GraphReachability<CGNode, CGNode> reach, TypeStateOptions options, ILiveObjectAnalysis live, TraceReporter traceReporter) throws PropertiesException {
        super(cg, pointerAnalysis, supergraph, domain, dfa, trackedInstances, apst, reach, options, live, traceReporter);
    }

    public AccessPathSet kLimit(AccessPathSet s, int limit) {
        return this.apsTransformer.kLimit(s, limit);
    }

    public AccessPathSet kLimitPollution(AccessPathSet s, int limit) {
        return this.apsTransformer.kLimitPollution(s, limit);
    }

    protected MustAuxiliary makeMustAuxiliary(AccessPathSet mustSet, boolean complete) {
        return new MustAuxiliary(mustSet, complete);
    }

    @Override
    protected IUnaryFlowFunction makeReturnFlowFunction(Set<PathElement> retValElements, CGNode caller, CGNode callee, SSAInvokeInstruction call) {
        return new ReturnFlowFunction(call, retValElements, caller, callee);
    }

    @Override
    public IUnaryFlowFunction getProgramExitFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (!this.getDFA().observesProgramExit()) {
            return UniversalKillFlowFunction.kill();
        }
        SSAInvokeInstruction srcInvokeInstr = null;
        CGNode caller = this.getSupergraph().getProcOf(src);
        return new BaseProgramExitFlowFunction(this.getDomain(), this.getDFA(), src, srcInvokeInstr, caller, this.getTraceReporter());
    }

    @Override
    protected IUnaryFlowFunction makePiFlowFunction(CGNode node, ISSABasicBlock bb, SSAPiInstruction pi) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    protected IUnaryFlowFunction makeAllocFlowFunction(InstanceKey ik, IDFAState initial, LocalPointerKey pk) {
        return new AllocFlowFunction(ik, this.getDFA().initial(), pk);
    }

    @Override
    protected IUnaryFlowFunction makePutStaticFlowFunction(StaticFieldKey X_f, LocalPointerKey y) {
        return new PutStaticFlowFunction(X_f, y);
    }

    @Override
    protected IUnaryFlowFunction makeAStoreFlowFunction(LocalPointerKey x, LocalPointerKey y) {
        return new AStoreFlowFunction(x, y);
    }

    @Override
    protected IUnaryFlowFunction makePutFieldFlowFunction(LocalPointerKey x, LocalPointerKey y, IField f) {
        return new PutFieldFlowFunction(x, y, f);
    }

    @Override
    protected IUnaryFlowFunction makeGetStaticFlowFunction(LocalPointerKey x, StaticFieldKey Y_f) {
        return new GetStaticFlowFunction(x, Y_f);
    }

    @Override
    protected IUnaryFlowFunction makeGetFieldFlowFunction(LocalPointerKey x, LocalPointerKey y, IField f) {
        return new GetFieldFlowFunction(x, y, f);
    }

    @Override
    protected IUnaryFlowFunction makeALoadFlowFunction(LocalPointerKey x, LocalPointerKey y) {
        AccessPath rhs = this.getAPDictionary().concat((PathElement)new LocalPathElement((AbstractPointerKey)y), (PathElement)ArrayContentsPathElement.instance());
        return this.makeLocalAssignFlowFunction(new LocalPathElement((AbstractPointerKey)x), rhs);
    }

    @Override
    protected IUnaryFlowFunction makeLocalAssignFlowFunction(AbstractPointerKey x, AbstractPointerKey y) {
        return this.makeLocalAssignFlowFunction(new LocalPathElement(x), this.getAPDictionary().findOrCreate(new LocalPathElement(y)));
    }

    protected IUnaryFlowFunction makeLocalAssignFlowFunction(LocalPathElement lhs, AccessPath rhs) {
        return new LocalAssignFlowFunction(lhs, rhs);
    }

    @Override
    protected IUnaryFlowFunction makeLocalRenameFlowFunction(AbstractPointerKey x, AbstractPointerKey y) {
        return new LocalRenameFlowFunction(new LocalPathElement(x), new LocalPathElement(y));
    }

    @Override
    protected IUnaryFlowFunction makeCallFlowFunction(CGNode caller, CGNode callee, SSAInvokeInstruction call) {
        return new CallFlowFunction(callee, call.getCallSite());
    }

    @Override
    protected IUnaryFlowFunction makeCheckCastFlowFunction(LocalPointerKey x, LocalPointerKey y, TypeReference T) {
        return new CheckCastFlowFunction(new LocalPathElement((AbstractPointerKey)x), new LocalPathElement((AbstractPointerKey)y), T);
    }

    protected int getAccessPathKLimit() {
        return this.accessPathKLimit;
    }

    protected boolean containsAllMayAliasPaths(CGNode node, AccessPathSet s, PointerKey x, AccessPath p) {
        AccessPath x_p = this.getAPDictionary().concat(this.makePathElement(x), p);
        int x_p_length = x_p.length();
        Iterator<AccessPath> it = s.pathsWithPrefix(x_p).iterator();
        while (it.hasNext()) {
            AccessPath x_p_path = it.next();
            AccessPath path = x_p_path.length() == x_p_length ? null : this.getAPDictionary().findOrCreate(x_p_path.getSuffix(x_p_length));
            Iterator it2 = this.iterateMayAliases(x);
            while (it2.hasNext()) {
                InstanceKey ik;
                PointerKey y = (PointerKey)it2.next();
                if (y.equals(x)) continue;
                if (y instanceof AbstractLocalPointerKey) {
                    CGNode yNode = ((AbstractLocalPointerKey)y).getNode();
                    if (!this.getReach().getReachableSet((Object)yNode).contains((Object)node)) continue;
                    LocalPathElement yElement = new LocalPathElement((AbstractPointerKey)((AbstractLocalPointerKey)y));
                    AccessPath y_p_path = this.getAPDictionary().concat((PathElement)yElement, p);
                    if (path != null) {
                        y_p_path = this.getAPDictionary().concat(y_p_path, path);
                    }
                    if (s.contains(y_p_path)) continue;
                    return false;
                }
                if (y instanceof StaticFieldKey) {
                    StaticFieldPathElement yElement = new StaticFieldPathElement((StaticFieldKey)y);
                    AccessPath y_p_path = this.getAPDictionary().concat((PathElement)yElement, p);
                    if (path != null) {
                        y_p_path = this.getAPDictionary().concat(y_p_path, path);
                    }
                    if (s.contains(y_p_path)) continue;
                    return false;
                }
                if (y instanceof InstanceFieldKey) {
                    ik = ((InstanceFieldKey)y).getInstanceKey();
                    IField g = ((InstanceFieldKey)y).getField();
                    Iterator pred = this.getPointerAnalysis().getHeapGraph().getPredNodes((Object)ik);
                    AbstractLocalPointerKey h = null;
                    while (pred.hasNext()) {
                        PointerKey pk = (PointerKey)pred.next();
                        if (pk instanceof AbstractLocalPointerKey) {
                            h = (AbstractLocalPointerKey)pk;
                            CGNode hNode = h.getNode();
                            if (!this.getReach().getReachableSet((Object)hNode).contains((Object)node)) continue;
                            break;
                        }
                        if (!(pk instanceof StaticFieldKey)) continue;
                        h = pk;
                        break;
                    }
                    assert (h != null);
                    InstanceFieldPathElement g_element = new InstanceFieldPathElement(g);
                    AccessPath g_p_path = this.getAPDictionary().concat((PathElement)g_element, p);
                    if (path != null) {
                        g_p_path = this.getAPDictionary().concat(g_p_path, path);
                    }
                    PathElement hElement = this.makePathElement((PointerKey)h);
                    AccessPath h_g_p_path = this.getAPDictionary().concat(hElement, g_p_path);
                    if (h instanceof AbstractLocalPointerKey) {
                        CGNode hNode = h.getNode();
                        if (this.getReach().getReachableSet((Object)hNode).contains((Object)node)) {
                            if (!s.contains(h_g_p_path)) {
                                return false;
                            }
                            if (this.containsAllMayAliasPaths(node, s, (PointerKey)h, g_p_path)) continue;
                            return false;
                        }
                        return false;
                    }
                    if (h instanceof StaticFieldKey) {
                        if (s.contains(h_g_p_path)) continue;
                        return false;
                    }
                    Assertions.UNREACHABLE((String)("unexpected " + h.getClass()));
                    continue;
                }
                if (y instanceof ArrayContentsKey) {
                    ik = ((ArrayContentsKey)y).getInstanceKey();
                    Iterator pred = this.getPointerAnalysis().getHeapGraph().getPredNodes((Object)ik);
                    AbstractLocalPointerKey h = null;
                    while (pred.hasNext()) {
                        PointerKey pk = (PointerKey)pred.next();
                        if (pk instanceof AbstractLocalPointerKey) {
                            h = (AbstractLocalPointerKey)pk;
                            CGNode hNode = h.getNode();
                            if (!this.getReach().getReachableSet((Object)hNode).contains((Object)node)) continue;
                            break;
                        }
                        if (!(pk instanceof StaticFieldKey)) continue;
                        h = pk;
                        break;
                    }
                    assert (h != null);
                    AccessPath g_p_path = this.getAPDictionary().concat((PathElement)ArrayContentsPathElement.instance(), p);
                    if (path != null) {
                        g_p_path = this.getAPDictionary().concat(g_p_path, path);
                    }
                    PathElement hElement = this.makePathElement((PointerKey)h);
                    AccessPath h_g_p_path = this.getAPDictionary().concat(hElement, g_p_path);
                    if (h instanceof AbstractLocalPointerKey) {
                        CGNode hNode = h.getNode();
                        if (this.getReach().getReachableSet((Object)hNode).contains((Object)node)) {
                            if (!s.contains(h_g_p_path)) {
                                return false;
                            }
                            if (this.containsAllMayAliasPaths(node, s, (PointerKey)h, g_p_path)) continue;
                            return false;
                        }
                        return false;
                    }
                    if (h instanceof StaticFieldKey) {
                        if (s.contains(h_g_p_path)) continue;
                        return false;
                    }
                    Assertions.UNREACHABLE((String)("unexpected " + h.getClass()));
                    continue;
                }
                Assertions.UNREACHABLE((String)("TODO: need to implement case for " + y.getClass()));
            }
        }
        return true;
    }

    private PathElement makePathElement(PointerKey h) {
        if (h instanceof AbstractLocalPointerKey) {
            return new LocalPathElement((AbstractPointerKey)((AbstractLocalPointerKey)h));
        }
        if (h instanceof StaticFieldKey) {
            return new StaticFieldPathElement((StaticFieldKey)h);
        }
        if (h instanceof InstanceFieldKey) {
            return new InstanceFieldPathElement(((InstanceFieldKey)h).getField());
        }
        if (h instanceof ArrayContentsKey) {
            return ArrayContentsPathElement.instance();
        }
        Assertions.UNREACHABLE((String)h.getClass().toString());
        return null;
    }

    private Iterator iterateMayAliases(PointerKey x) {
        final HeapGraph hg = this.getPointerAnalysis().getHeapGraph();
        final Iterator outer = this.getPointerAnalysis().getPointsToSet(x).iterator();
        return new Iterator(){
            Iterator inner;
            {
                this.inner = iterator.hasNext() ? heapGraph.getPredNodes(iterator.next()) : null;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }

            @Override
            public boolean hasNext() {
                return this.inner != null && this.inner.hasNext();
            }

            public Object next() {
                Object result = this.inner.next();
                if (!this.inner.hasNext()) {
                    this.inner = outer.hasNext() ? hg.getPredNodes(outer.next()) : null;
                }
                return result;
            }
        };
    }

    @Override
    protected IUnaryFlowFunction makeDeadAccessPathKiller(CGNode node, ISSABasicBlock b) {
        return new MustAPDeadKiller(node, b);
    }

    protected class AStoreFlowFunction
    implements IUnaryFlowFunction {
        private final PathElement xPathElement;
        private final PathElement yPathElement;
        private final AccessPath xContentsPath;
        private final CGNode node;
        private final LocalPointerKey x;

        public AStoreFlowFunction(LocalPointerKey x, LocalPointerKey y) {
            this.x = x;
            this.node = x.getNode();
            this.xPathElement = new LocalPathElement((AbstractPointerKey)x);
            this.yPathElement = new LocalPathElement((AbstractPointerKey)y);
            this.xContentsPath = AbstractMustAPFunctionProvider.this.getAPDictionary().concat(this.xPathElement, (PathElement)ArrayContentsPathElement.instance());
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)d1);
            }
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            if (!must.isComplete()) {
                return SparseIntSet.singleton((int)d1);
            }
            AccessPathSet mup = must.getMustPaths();
            AccessPathSet newMup = AbstractMustAPFunctionProvider.this.updateMust(mup, this.xContentsPath, this.yPathElement);
            boolean complete = AbstractMustAPFunctionProvider.this.containsAllMayAliasPaths(this.node, newMup, (PointerKey)this.x, AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(this.xContentsPath.getSuffix(1)));
            int size = newMup.size();
            newMup = AbstractMustAPFunctionProvider.this.apsTransformer.kLimit(newMup, AbstractMustAPFunctionProvider.this.accessPathKLimit);
            boolean bl = complete = newMup.size() == size ? complete : false;
            if (!complete) {
                AccessPathSetTransformers.removeArrayPaths(newMup);
            }
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(newMup, complete));
            result.add(newTupleIndex);
            return result;
        }

        protected AccessPath getXContentsPath() {
            return this.xContentsPath;
        }

        protected PathElement getXPathElement() {
            return this.xPathElement;
        }

        protected PathElement getYPathElement() {
            return this.yPathElement;
        }

        protected CGNode getNode() {
            return this.node;
        }

        protected LocalPointerKey getX() {
            return this.x;
        }
    }

    protected class AllocFlowFunction
    implements IUnaryFlowFunction {
        final int uniqueAlloc;
        final int notUniqueAlloc;
        final LocalPathElement lhsElement;
        protected final IDFAState initial;

        public AllocFlowFunction(InstanceKey ik, IDFAState initial, LocalPointerKey pk) {
            AccessPathSet mustSet = new AccessPathSet(AbstractMustAPFunctionProvider.this.getAPDictionary());
            this.lhsElement = new LocalPathElement((AbstractPointerKey)pk);
            this.initial = initial;
            mustSet.add(AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(this.lhsElement));
            MustAuxiliary aux = AbstractMustAPFunctionProvider.this.makeMustAuxiliary(mustSet, true);
            this.uniqueAlloc = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(ik, initial, true, aux);
            this.notUniqueAlloc = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(ik, initial, false, aux);
        }

        public SparseIntSet getTargets(int d1) {
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            if (d1 != 0) {
                Object domainItem = AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
                QuadFactoid tuple = (QuadFactoid)domainItem;
                MustAuxiliary must = (MustAuxiliary)tuple.aux;
                AccessPathSet newMup = AbstractMustAPFunctionProvider.this.kill(must.getMustPaths(), this.lhsElement);
                int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, false, AbstractMustAPFunctionProvider.this.makeMustAuxiliary(newMup, must.isComplete()));
                result.add(newTupleIndex);
                result.add(this.notUniqueAlloc);
            } else {
                result.add(this.uniqueAlloc);
                result.add(0);
            }
            return result;
        }

        protected LocalPathElement getLhsElement() {
            return this.lhsElement;
        }

        protected int getNotUniqueAlloc() {
            return this.notUniqueAlloc;
        }

        protected int getUniqueAlloc() {
            return this.uniqueAlloc;
        }
    }

    public class CallFlowFunction
    implements IReversibleFlowFunction {
        private final CGNode callee;
        private final CallSiteReference site;

        public CallFlowFunction(CGNode callee, CallSiteReference site) {
            this.callee = callee;
            this.site = site;
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            if (!this.isFeasibleCall(tuple)) {
                return SparseIntSet.singleton((int)0);
            }
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet mup = must.getMustPaths();
            IMethod calleeMethod = this.callee.getMethod();
            int numOfParams = calleeMethod.getNumberOfParameters();
            boolean newFactIsComplete = must.isComplete();
            int oldMustSize = mup.size();
            if ((mup = AbstractMustAPFunctionProvider.this.killLocals(mup, this.getCallee())).size() < oldMustSize) {
                newFactIsComplete = false;
            }
            AccessPathSet prevMup = mup;
            AccessPathSet newMup = mup;
            int i = 0;
            while (i < numOfParams) {
                int formal = i + 1;
                TypeReference formalType = calleeMethod.getParameterType(i);
                if (formalType.isReferenceType()) {
                    TemporaryParameterPointerKey actualPointerKey = TemporaryParameterPointerKey.make(i);
                    LocalPointerKey formalPointerKey = (LocalPointerKey)AbstractMustAPFunctionProvider.this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(this.callee, formal);
                    LocalPathElement formalPathElement = new LocalPathElement((AbstractPointerKey)formalPointerKey);
                    prevMup = newMup = AbstractMustAPFunctionProvider.this.rename(prevMup, formalPathElement, Collections.singleton(new LocalPathElement(actualPointerKey)));
                }
                ++i;
            }
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(newMup, newFactIsComplete));
            result.add(newTupleIndex);
            return result;
        }

        protected boolean isFeasibleCall(QuadFactoid tuple) {
            if (this.site.isSpecial() || this.site.isStatic()) {
                return true;
            }
            TemporaryParameterPointerKey recvPointerKey = TemporaryParameterPointerKey.make(0);
            AccessPath recv = AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(new LocalPathElement(recvPointerKey));
            AccessPathSet must = ((MustAuxiliary)tuple.aux).getMustPaths();
            if (must.contains(recv)) {
                IClass klass = tuple.instance.getConcreteType();
                IMethod resolved = AbstractMustAPFunctionProvider.this.getCallGraph().getClassHierarchy().resolveMethod(klass, this.callee.getMethod().getSelector());
                if (resolved.getReference().equals((Object)this.callee.getMethod().getReference())) {
                    if (this.callee.getContext() instanceof ReceiverInstanceContext) {
                        ReceiverInstanceContext c = (ReceiverInstanceContext)this.callee.getContext();
                        return c.getReceiver().equals(tuple.instance);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        public SparseIntSet getSources(int d2) {
            AccessPathSet mup;
            if (d2 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            IMethod calleeMethod = this.callee.getMethod();
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d2);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet newMup = mup = must.getMustPaths();
            int numOfParams = calleeMethod.getNumberOfParameters();
            int i = 0;
            while (i < numOfParams) {
                int formal = i + 1;
                LocalPointerKey formalPointerKey = (LocalPointerKey)AbstractMustAPFunctionProvider.this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(this.callee, formal);
                LocalPathElement formalPathElement = new LocalPathElement((AbstractPointerKey)formalPointerKey);
                TemporaryParameterPointerKey actualPointerKey = TemporaryParameterPointerKey.make(i);
                newMup = AbstractMustAPFunctionProvider.this.rename(newMup, new LocalPathElement(actualPointerKey), Collections.singleton(formalPathElement));
                ++i;
            }
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(newMup, must.isComplete()));
            result.add(newTupleIndex);
            return result;
        }

        protected CGNode getCallee() {
            return this.callee;
        }
    }

    protected class CheckCastFlowFunction
    implements IUnaryFlowFunction {
        private final IClass klass;
        final LocalPathElement lhs;
        final LocalPathElement rhs;
        final AccessPath rhsPath;

        public CheckCastFlowFunction(LocalPathElement lhs, LocalPathElement rhs, TypeReference T) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.klass = AbstractMustAPFunctionProvider.this.getCallGraph().getClassHierarchy().lookupClass(T);
            this.rhsPath = AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(rhs);
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet tempMup = AbstractMustAPFunctionProvider.this.assign(must.getMustPaths(), (PathElement)this.lhs, this.rhsPath);
            AccessPathSet newMup = new AccessPathSet(AbstractMustAPFunctionProvider.this.getAPDictionary());
            boolean complete = must.isComplete();
            Iterator<AccessPath> it = tempMup.iterator();
            while (it.hasNext()) {
                AccessPath ap = it.next();
                if (ap.getHead().equals(this.lhs)) {
                    if (ap.length() == 1 && this.klass != null) {
                        IClass concreteType = tuple.instance.getConcreteType();
                        if (this.klass.isInterface() && AbstractMustAPFunctionProvider.this.getCallGraph().getClassHierarchy().implementsInterface(concreteType, this.klass)) {
                            newMup.add(ap);
                            continue;
                        }
                        if (!AbstractMustAPFunctionProvider.this.getCallGraph().getClassHierarchy().isSubclassOf(concreteType, this.klass)) continue;
                        newMup.add(ap);
                        continue;
                    }
                    complete = false;
                    continue;
                }
                newMup.add(ap);
            }
            MustAuxiliary newMust = new MustAuxiliary(newMup, complete);
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), newMust);
            return SparseIntSet.singleton((int)newTupleIndex);
        }

        protected IClass getKlass() {
            return this.klass;
        }

        protected LocalPathElement getLhs() {
            return this.lhs;
        }

        protected LocalPathElement getRhs() {
            return this.rhs;
        }

        protected AccessPath getRhsPath() {
            return this.rhsPath;
        }
    }

    public class GetFieldFlowFunction
    extends LocalAssignFlowFunction {
        public GetFieldFlowFunction(LocalPointerKey x, LocalPointerKey y, IField f) {
            super(new LocalPathElement((AbstractPointerKey)x), AbstractMustAPFunctionProvider.this.getAPDictionary().concat(AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(new LocalPathElement((AbstractPointerKey)y)), (PathElement)new InstanceFieldPathElement(f)));
        }
    }

    public class GetStaticFlowFunction
    extends LocalAssignFlowFunction {
        public GetStaticFlowFunction(LocalPointerKey x, StaticFieldKey Y_f) {
            super(new LocalPathElement((AbstractPointerKey)x), AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(new StaticFieldPathElement(Y_f)));
            assert (x != null && Y_f != null) : "cannot create flow function with null receiver or static field";
        }
    }

    protected class LocalAssignFlowFunction
    implements IUnaryFlowFunction {
        final LocalPathElement lhs;
        final AccessPath rhs;

        public LocalAssignFlowFunction(LocalPathElement lhs, AccessPath rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet newMup = AbstractMustAPFunctionProvider.this.assign(must.getMustPaths(), (PathElement)this.lhs, this.rhs);
            MustAuxiliary newMust = new MustAuxiliary(newMup, must.isComplete());
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), newMust);
            return SparseIntSet.singleton((int)newTupleIndex);
        }

        protected LocalPathElement getLhs() {
            return this.lhs;
        }

        protected AccessPath getRhs() {
            return this.rhs;
        }
    }

    protected class LocalRenameFlowFunction
    implements IUnaryFlowFunction {
        final LocalPathElement lhs;
        final PathElement rhs;

        public LocalRenameFlowFunction(LocalPathElement lhs, PathElement rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet newMup = AbstractMustAPFunctionProvider.this.rename(must.getMustPaths(), this.lhs, Collections.singleton(this.rhs));
            MustAuxiliary newMust = new MustAuxiliary(newMup, must.isComplete());
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), newMust);
            return SparseIntSet.singleton((int)newTupleIndex);
        }

        protected LocalPathElement getLhs() {
            return this.lhs;
        }

        protected PathElement getRhs() {
            return this.rhs;
        }
    }

    protected class MustAPDeadKiller
    implements IUnaryFlowFunction {
        private final CGNode node;
        private final ISSABasicBlock b;

        MustAPDeadKiller(CGNode node, ISSABasicBlock b) {
            this.node = node;
            this.b = b;
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            MustAuxiliary aux = (MustAuxiliary)tuple.aux;
            AccessPathSet must = aux.getMustPaths();
            int oldSize = must.size();
            if ((must = AbstractMustAPFunctionProvider.this.removeDeadPaths(must, this.node, this.b, this.node.getIR(), this.node.getDU())).size() < oldSize) {
                if (must.size() == 0 && aux.isComplete()) {
                    return SparseIntSet.singleton((int)0);
                }
                int newIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(must, aux.isComplete()));
                return SparseIntSet.singleton((int)newIndex);
            }
            return SparseIntSet.singleton((int)d1);
        }
    }

    protected class PutFieldFlowFunction
    implements IUnaryFlowFunction {
        private final LocalPointerKey x;
        private final PathElement xPathElement;
        private final PathElement yPathElement;
        private final AccessPath x_fPath;
        private final CGNode node;

        public PutFieldFlowFunction(LocalPointerKey x, LocalPointerKey y, IField f) {
            assert (f != null);
            this.x = x;
            this.node = x.getNode();
            this.xPathElement = new LocalPathElement((AbstractPointerKey)x);
            this.yPathElement = new LocalPathElement((AbstractPointerKey)y);
            this.x_fPath = AbstractMustAPFunctionProvider.this.getAPDictionary().concat(this.xPathElement, (PathElement)new InstanceFieldPathElement(f));
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet mup = must.getMustPaths();
            AccessPathSet newMup = AbstractMustAPFunctionProvider.this.updateMust(mup, this.x_fPath, this.yPathElement);
            boolean complete = false;
            if (must.isComplete()) {
                complete = AbstractMustAPFunctionProvider.this.containsAllMayAliasPaths(this.node, newMup, (PointerKey)this.x, AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(this.x_fPath.getSuffix(1)));
            }
            int size = newMup.size();
            newMup = AbstractMustAPFunctionProvider.this.apsTransformer.kLimit(newMup, AbstractMustAPFunctionProvider.this.accessPathKLimit);
            complete = newMup.size() == size ? complete : false;
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(newMup, complete));
            result.add(newTupleIndex);
            return result;
        }

        protected AccessPath getX_fPath() {
            return this.x_fPath;
        }

        protected PathElement getXPathElement() {
            return this.xPathElement;
        }

        protected PathElement getYPathElement() {
            return this.yPathElement;
        }

        protected CGNode getNode() {
            return this.node;
        }

        protected LocalPointerKey getX() {
            return this.x;
        }
    }

    public class PutStaticFlowFunction
    implements IUnaryFlowFunction {
        private final PathElement yPathElement;
        private final AccessPath X_fPath;

        public PutStaticFlowFunction(StaticFieldKey X_f, LocalPointerKey y) {
            assert (y != null && X_f != null) : "cannot create flow function with null receiver or static field";
            this.X_fPath = AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(new StaticFieldPathElement(X_f));
            this.yPathElement = new LocalPathElement((AbstractPointerKey)y);
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            MustAuxiliary must = (MustAuxiliary)tuple.aux;
            AccessPathSet mup = must.getMustPaths();
            AccessPathSet newMup = AbstractMustAPFunctionProvider.this.updateMust(mup, this.X_fPath, this.yPathElement);
            if (must.isComplete() && newMup.size() == 0) {
                return SparseIntSet.singleton((int)0);
            }
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, tuple.isUnique(), new MustAuxiliary(newMup, must.isComplete()));
            return SparseIntSet.singleton((int)newTupleIndex);
        }

        protected AccessPath getX_fPath() {
            return this.X_fPath;
        }

        protected PathElement getYPathElement() {
            return this.yPathElement;
        }
    }

    protected class ReturnFlowFunction
    implements IUnaryFlowFunction {
        private final CGNode caller;
        private final CGNode callee;
        private final Set<PathElement> retValElements;
        protected final SSAInvokeInstruction call;

        protected ReturnFlowFunction(SSAInvokeInstruction call, Set<PathElement> retValElements, CGNode caller, CGNode callee) {
            this.caller = caller;
            this.callee = callee;
            this.retValElements = retValElements;
            this.call = call;
        }

        public SparseIntSet getTargets(int d1) {
            if (d1 == 0) {
                return SparseIntSet.singleton((int)0);
            }
            QuadFactoid tuple = (QuadFactoid)AbstractMustAPFunctionProvider.this.getQuadDomain().getMappedObject(d1);
            if (AbstractMustAPFunctionProvider.this.getLiveObjectAnalysis() != null && tuple.instance instanceof AllocationSite) {
                AllocationSite ak = (AllocationSite)tuple.instance;
                try {
                    if (!AbstractMustAPFunctionProvider.this.getLiveObjectAnalysis().mayBeLive((InstanceKey)ak, this.getCaller(), -1)) {
                        return SparseIntSet.singleton((int)0);
                    }
                }
                catch (WalaException e) {
                    e.printStackTrace();
                    Assertions.UNREACHABLE((String)tuple.instance.toString());
                }
            }
            MustAuxiliary aux = (MustAuxiliary)tuple.aux;
            AccessPathSet must = aux.getMustPaths();
            IMethod calleeMethod = this.getCallee().getMethod();
            int numOfParams = calleeMethod.getNumberOfParameters();
            int i = 0;
            while (i < numOfParams) {
                int formal = i + 1;
                if (calleeMethod.getParameterType(i).isReferenceType()) {
                    LocalPointerKey formalPointerKey = (LocalPointerKey)AbstractMustAPFunctionProvider.this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(this.getCallee(), formal);
                    LocalPathElement formalPathElement = new LocalPathElement((AbstractPointerKey)formalPointerKey);
                    LocalPointerKey act = (LocalPointerKey)AbstractMustAPFunctionProvider.this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(this.getCaller(), this.call.getUse(i));
                    AccessPath formalAP = AbstractMustAPFunctionProvider.this.getAPDictionary().findOrCreate(formalPathElement);
                    must = AbstractMustAPFunctionProvider.this.assign(must, (PathElement)new LocalPathElement((AbstractPointerKey)act), Collections.singleton(formalAP));
                }
                ++i;
            }
            if (!this.getRetValElements().isEmpty()) {
                LocalPathElement symRetVal = new LocalPathElement(TemporaryParameterPointerKey.makeReturnValue());
                must = AbstractMustAPFunctionProvider.this.rename(must, symRetVal, this.getRetValElements());
            }
            must = AbstractMustAPFunctionProvider.this.killOutOfScopeLocals(must, this.getCaller());
            must = AbstractMustAPFunctionProvider.this.killLocals(must, this.getCallee());
            boolean unique = tuple.isUnique();
            if (!unique && this.canForceToUnique(tuple)) {
                unique = true;
            }
            if (aux.isComplete() && must.isEmpty()) {
                return SparseIntSet.singleton((int)0);
            }
            int newTupleIndex = AbstractMustAPFunctionProvider.this.getQuadDomain().findOrCreate(tuple.instance, tuple.state, unique, new MustAuxiliary(must, aux.isComplete()));
            return SparseIntSet.singleton((int)newTupleIndex);
        }

        protected boolean canForceToUnique(QuadFactoid tuple) {
            AllocationSiteInNode ak;
            return tuple.instance instanceof AllocationSiteInNode && UniqueReturnFlowFunction.mustBeUniqueInNode(ak = (AllocationSiteInNode)tuple.instance, this.caller, AbstractMustAPFunctionProvider.this.getHeapGraph(), AbstractMustAPFunctionProvider.this.getLiveObjectAnalysis());
        }

        protected CGNode getCaller() {
            return this.caller;
        }

        protected Set<PathElement> getRetValElements() {
            return this.retValElements;
        }

        protected CGNode getCallee() {
            return this.callee;
        }
    }
}

