/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.ap;

import com.ibm.safe.accesspath.AccessPathDictionary;
import com.ibm.safe.accesspath.AccessPathSetTransformers;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.typestate.core.BenignOracle;
import com.ibm.safe.typestate.merge.IMergeFunctionFactory;
import com.ibm.safe.typestate.metrics.TypeStateMetrics;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.quad.QuadSolver;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.CollectionFilter;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.GraphReachability;
import com.ibm.wala.util.graph.GraphSlicer;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.BFSIterator;
import com.ibm.wala.util.graph.traverse.BoundedBFSIterator;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AccessPathSolver
extends QuadSolver {
    private AccessPathSetTransformers apsTransformer;
    private GraphReachability<CGNode, CGNode> reach;
    private final AccessPathDictionary APDictionary;

    public AccessPathSolver(AnalysisOptions domoOptions, CallGraph cg, GraphReachability<CGNode, CGNode> reach, PointerAnalysis pointerAnalysis, ITypeStateDFA dfa, TypeStateOptions options, AccessPathSetTransformers apst, ILiveObjectAnalysis live, BenignOracle ora, TypeStateMetrics metrics, IReporter reporter, TraceReporter traceReporter, IMergeFunctionFactory mergeFactory) {
        super(domoOptions, cg, pointerAnalysis, dfa, options, live, ora, metrics, reporter, traceReporter, mergeFactory);
        this.apsTransformer = apst;
        this.reach = reach;
        this.APDictionary = apst.getAPDictionary();
    }

    protected AccessPathSetTransformers getApsTransformer() {
        return this.apsTransformer;
    }

    protected GraphReachability<CGNode, CGNode> getReach() {
        return this.reach;
    }

    @Override
    protected Collection<CGNode> computeNodesThatMatter(OrdinalSet<InstanceKey> instances) throws WalaException, PropertiesException {
        if (this.getOptions().shouldSliceSupergraph()) {
            Collection<CGNode> eventNodes = this.scanForEventNodes(instances);
            Collection<CGNode> result = AccessPathSolver.computeNodesThatDirectlyMatter(instances, this.getLiveObjectAnalysis(), this.getCallGraph(), this.getHeapGraph(), this.getDFA(), this.getOptions().getAccessPathKLimit());
            result = this.getMinimumSpanningTree((Graph<CGNode>)this.getCallGraph(), this.getCallGraph().getFakeRootNode(), result);
            this.addAllCalleesOfEventSites(result, eventNodes);
            return result;
        }
        return Iterator2Collection.toList((Iterator)this.getCallGraph().iterator());
    }

    public static Collection<CGNode> computeNodesThatDirectlyMatter(OrdinalSet<InstanceKey> instances, ILiveObjectAnalysis live, CallGraph callGraph, HeapGraph heapGraph, ITypeStateDFA dfa, int kLimit) throws WalaException {
        Assertions.productionAssertion((live != null ? 1 : 0) != 0, (String)"expected non-null live object analysis in order to slice supergraph");
        Collection<CGNode> relevantNodes = AccessPathSolver.computeRelevantNodes(instances, heapGraph, callGraph, dfa, kLimit);
        Predicate<CGNode> liveFilter = AccessPathSolver.makeLiveNodeFilter(instances, live);
        Graph pruned = GraphSlicer.prune((Graph)callGraph, liveFilter);
        Set result = GraphSlicer.slice((Graph)pruned, (Predicate)new CollectionFilter(relevantNodes));
        return result;
    }

    private static Collection<CGNode> computeRelevantNodes(OrdinalSet<InstanceKey> instances, HeapGraph heapGraph, CallGraph cg, ITypeStateDFA dfa, int kLimit) {
        BoundedBFSIterator traverse = kLimit > 0 ? new BoundedBFSIterator((Graph)GraphInverter.invert((NumberedGraph)heapGraph), OrdinalSet.toCollection(instances).iterator(), kLimit) : new BFSIterator((Graph)GraphInverter.invert((NumberedGraph)heapGraph), OrdinalSet.toCollection(instances).iterator());
        Iterator2Set reached = Iterator2Collection.toSet((Iterator)traverse);
        HashSet result = HashSetFactory.make();
        for (Object node : reached) {
            if (heapGraph.getPredNodeCount(node) != 0 || node instanceof StaticFieldKey) continue;
            if (node instanceof AbstractLocalPointerKey) {
                AbstractLocalPointerKey local = (AbstractLocalPointerKey)node;
                if (!AccessPathSolver.localIsRelevant(local, cg, dfa)) continue;
                result.add(local.getNode());
                continue;
            }
            if (node instanceof PropagationCallGraphBuilder.TypedPointerKey) {
                PropagationCallGraphBuilder.TypedPointerKey t = (PropagationCallGraphBuilder.TypedPointerKey)node;
                PointerKey b = t.getBase();
                if (b instanceof AbstractLocalPointerKey) {
                    AbstractLocalPointerKey local = (AbstractLocalPointerKey)b;
                    if (!AccessPathSolver.localIsRelevant(local, cg, dfa)) continue;
                    result.add(local.getNode());
                    continue;
                }
                Assertions.UNREACHABLE((String)("unexpected: " + b.getClass() + " " + b));
                continue;
            }
            Assertions.UNREACHABLE((String)("unexpected: " + node.getClass() + " " + node));
        }
        return result;
    }

    private static boolean localIsRelevant(AbstractLocalPointerKey local, CallGraph cg, ITypeStateDFA dfa) {
        CGNode n = local.getNode();
        if (dfa.receives(n.getMethod())) {
            return true;
        }
        if (local instanceof LocalPointerKey) {
            LocalPointerKey lpk = (LocalPointerKey)local;
            DefUse du = n.getDU();
            if (du == null) {
                return true;
            }
            Iterator it = du.getUses(lpk.getValueNumber());
            while (it.hasNext()) {
                SSAInstruction s = (SSAInstruction)it.next();
                if (s instanceof SSAInvokeInstruction) continue;
                if (s instanceof SSAGetInstruction) {
                    SSAGetInstruction g = (SSAGetInstruction)s;
                    if (g.getDeclaredFieldType().isPrimitiveType()) continue;
                    return true;
                }
                if (s instanceof SSAPutInstruction) {
                    SSAPutInstruction p = (SSAPutInstruction)s;
                    if (p.getDeclaredFieldType().isPrimitiveType()) continue;
                    return true;
                }
                if (s instanceof SSAReturnInstruction || s instanceof SSAArrayStoreInstruction) {
                    return true;
                }
                if (s instanceof SSAInstanceofInstruction || s instanceof SSACheckCastInstruction || s instanceof SSAConditionalBranchInstruction || s instanceof SSAPhiInstruction || s instanceof SSAMonitorInstruction) continue;
                Assertions.UNREACHABLE((String)("unexpected " + s.toString()));
                return true;
            }
            return false;
        }
        return true;
    }

    protected HeapGraph getHeapGraph() {
        return this.getPointerAnalysis().getHeapGraph();
    }

    protected AccessPathDictionary getAPDictionary() {
        return this.APDictionary;
    }
}

