/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.typestate.ap;

import com.ibm.safe.ICFGSupergraph;
import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathDictionary;
import com.ibm.safe.accesspath.AccessPathSet;
import com.ibm.safe.accesspath.AccessPathSetTransformers;
import com.ibm.safe.accesspath.LocalPathElement;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.dfa.IDFAState;
import com.ibm.safe.dfa.events.IEvent;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.typestate.ap.TemporaryParameterPointerKey;
import com.ibm.safe.typestate.core.TypeStateFunctionProvider;
import com.ibm.safe.typestate.core.UniversalKillFlowFunction;
import com.ibm.safe.typestate.mine.TraceReporter;
import com.ibm.safe.typestate.mine.TracingProperty;
import com.ibm.safe.typestate.options.TypeStateOptions;
import com.ibm.safe.typestate.quad.AggregateFlowFunction;
import com.ibm.safe.typestate.quad.QuadFunctionProvider;
import com.ibm.safe.typestate.quad.QuadTypeStateDomain;
import com.ibm.safe.typestate.rules.ITypeStateDFA;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.escape.ILiveObjectAnalysis;
import com.ibm.wala.escape.LocalLiveRangeAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphReachability;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AccessPathFunctionProvider
extends QuadFunctionProvider {
    private static final boolean NORMAL_LIVE_KILL = true;
    protected final int accessPathKLimit;
    private final HeapGraph heapGraph;
    private final AccessPathDictionary APDictionary;
    protected final AccessPathSetTransformers apsTransformer;
    private final GraphReachability<CGNode, CGNode> reach;
    private final TypeStateOptions options;

    protected AccessPathSet removeDeadPaths(AccessPathSet s, CGNode n, ISSABasicBlock b, IR ir, DefUse du) {
        AccessPathSet result = new AccessPathSet(s);
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            LocalPointerKey lpk;
            LocalPathElement l;
            AccessPath ap = it.next();
            PathElement head = ap.getHead();
            if (!(head instanceof LocalPathElement) || !((l = (LocalPathElement)head).getPointerKey() instanceof LocalPointerKey) || (lpk = (LocalPointerKey)l.getPointerKey()).isParameter() || !lpk.getNode().equals(n) || LocalLiveRangeAnalysis.isLive((int)lpk.getValueNumber(), (int)b.getLastInstructionIndex(), (IR)ir, (DefUse)du)) continue;
            result.remove(ap);
        }
        return result;
    }

    public AccessPathFunctionProvider(CallGraph cg, PointerAnalysis pointerAnalysis, ICFGSupergraph supergraph, QuadTypeStateDomain domain, ITypeStateDFA dfa, Collection<InstanceKey> trackedInstances, AccessPathSetTransformers apst, GraphReachability<CGNode, CGNode> reach, TypeStateOptions options, ILiveObjectAnalysis live, TraceReporter traceReporter) throws PropertiesException {
        super(cg, pointerAnalysis, supergraph, domain, dfa, trackedInstances, live, traceReporter);
        this.APDictionary = apst.getAPDictionary();
        this.apsTransformer = apst;
        this.reach = reach;
        this.heapGraph = pointerAnalysis.getHeapGraph();
        this.options = options;
        this.accessPathKLimit = options.getAccessPathKLimit();
        Assertions.productionAssertion((this.accessPathKLimit > 0 ? 1 : 0) != 0);
    }

    public AccessPathSet assign(AccessPathSet s, PathElement x, AccessPath y) {
        return this.apsTransformer.assign(s, x, y);
    }

    public AccessPathSet assign(AccessPathSet s, PathElement x, Set<AccessPath> ySet) {
        return this.apsTransformer.assign(s, x, ySet);
    }

    public AccessPathSet gen(AccessPathSet s, PathElement x, AccessPath y) {
        return this.apsTransformer.gen(s, x, y);
    }

    public AccessPathSet kill(AccessPathSet s, PathElement x) {
        return this.apsTransformer.kill(s, x);
    }

    public AccessPathSet kill(AccessPathSet s, Set<PathElement> roots) {
        return this.apsTransformer.kill(s, roots);
    }

    public AccessPathSet rename(AccessPathSet s, PathElement x, Set<? extends PathElement> ySet) {
        return this.apsTransformer.rename(s, x, ySet);
    }

    protected LocalPointerKey getReceiverPointerKey(SSAInvokeInstruction srcInvokeInstr, CGNode caller) {
        if (srcInvokeInstr.isStatic()) {
            return null;
        }
        int rcv = srcInvokeInstr.getReceiver();
        LocalPointerKey p = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, rcv);
        return p;
    }

    @Override
    protected IUnaryFlowFunction getNonEntryCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> srcBlock, BasicBlockInContext<IExplodedBasicBlock> destBlock) {
        IEvent event;
        CGNode caller = srcBlock.getNode();
        CGNode callee = destBlock.getNode();
        IUnaryFlowFunction blockFunction = this.composeBlockFlowFunction(caller, srcBlock);
        SSAInvokeInstruction srcInvokeInstr = TypeStateFunctionProvider.getLastCallInstruction(this.getCFG(srcBlock), srcBlock);
        int p = 0;
        while (p < srcInvokeInstr.getNumberOfUses()) {
            if (callee.getMethod().getParameterType(p).isReferenceType()) {
                TemporaryParameterPointerKey def = TemporaryParameterPointerKey.make(p);
                LocalPointerKey use = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, srcInvokeInstr.getUse(p));
                IUnaryFlowFunction copy = this.makeLocalAssignFlowFunction(def, (AbstractPointerKey)use);
                blockFunction = AggregateFlowFunction.compose(blockFunction, copy);
            }
            ++p;
        }
        if (srcBlock.getLastInstructionIndex() >= 0) {
            blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeDeadAccessPathKiller(caller, (ISSABasicBlock)srcBlock));
        }
        if ((event = this.getEventForNode(callee)) != null && this.getDFA() instanceof TracingProperty) {
            event = this.getDFA().matchDispatchEvent(caller, callee.getMethod().getSignature());
        }
        if (event != null) {
            if (srcInvokeInstr.isStatic()) {
                Assertions.UNREACHABLE((String)("unexpected event on static call to " + callee));
                blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeCallFlowFunction(event, srcBlock, srcInvokeInstr, caller, callee));
            } else {
                blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeCallFlowFunction(event, srcBlock, srcInvokeInstr, caller, callee));
            }
        } else {
            blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeCallFlowFunction(null, srcBlock, srcInvokeInstr, caller, callee));
        }
        return blockFunction;
    }

    @Override
    public IFlowFunction getNonExitReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        CGNode callee = src.getNode();
        CGNode caller = dest.getNode();
        boolean isNormalFlow = this.getCFG(call).getNormalSuccessors((Object)((IExplodedBasicBlock)call.getDelegate())).contains(dest.getDelegate());
        if (!isNormalFlow) {
            return UniversalKillFlowFunction.kill();
        }
        IUnaryFlowFunction blockFunction = this.composeBlockFlowFunction(callee, src);
        SSAInvokeInstruction theInvokeInstr = this.getInvokeInstruction(call);
        if (theInvokeInstr != null) {
            SSAInvokeInstruction callStatement;
            Set<PathElement> retValueElements = this.computeReturnValueElements(callee);
            IUnaryFlowFunction returnEdgeFunction = this.makeReturnFlowFunction(retValueElements, caller, callee, theInvokeInstr);
            blockFunction = AggregateFlowFunction.compose(blockFunction, returnEdgeFunction);
            if (!retValueElements.isEmpty() && (callStatement = (SSAInvokeInstruction)call.getLastInstruction()).hasDef()) {
                TemporaryParameterPointerKey retValue = TemporaryParameterPointerKey.makeReturnValue();
                LocalPointerKey def = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(caller, callStatement.getDef());
                IUnaryFlowFunction copy = this.makeLocalRenameFlowFunction((AbstractPointerKey)def, retValue);
                blockFunction = AggregateFlowFunction.compose(blockFunction, copy);
            }
        }
        if (src.getLastInstructionIndex() >= 0) {
            blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeDeadAccessPathKiller(caller, (ISSABasicBlock)dest));
        }
        blockFunction = this.composeWithPhiAssignments(call, dest, blockFunction, caller);
        return blockFunction;
    }

    Set<PathElement> computeReturnValueElements(CGNode node) {
        if (node.getMethod().getReference().getReturnType().isReferenceType()) {
            ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg = this.getCFG(node);
            IExplodedBasicBlock exit = (IExplodedBasicBlock)cfg.exit();
            SSAInstruction[] instructions = (SSAInstruction[])cfg.getInstructions();
            HashSet result = HashSetFactory.make();
            Iterator it = cfg.getPredNodes((Object)exit);
            while (it.hasNext()) {
                int retValue;
                SSAReturnInstruction retInstr;
                SSAInstruction inst;
                IBasicBlock block = (IBasicBlock)it.next();
                int lastIndex = block.getLastInstructionIndex();
                if (lastIndex < 0 || !((inst = instructions[lastIndex]) instanceof SSAReturnInstruction) || (retInstr = (SSAReturnInstruction)inst) == null || (retValue = retInstr.getResult()) == -1) continue;
                LocalPointerKey retValueKey = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, retValue);
                result.add(new LocalPathElement((AbstractPointerKey)retValueKey));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public IUnaryFlowFunction makeNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        CGNode node = src.getNode();
        IUnaryFlowFunction blockFunction = this.composeBlockFlowFunction(node, src);
        if (src.getLastInstructionIndex() >= 0) {
            blockFunction = AggregateFlowFunction.compose(blockFunction, this.makeDeadAccessPathKiller(node, (ISSABasicBlock)src));
        }
        int destNumber = dest.getNumber();
        Iterator piIterator = src.iteratePis();
        while (piIterator.hasNext()) {
            SSAPiInstruction piInst = (SSAPiInstruction)piIterator.next();
            int piNumber = piInst.getSuccessor();
            if (piNumber != destNumber) continue;
            IUnaryFlowFunction piTransformer = this.makePiFlowFunction(node, (ISSABasicBlock)src, piInst);
            blockFunction = AggregateFlowFunction.compose(blockFunction, piTransformer);
        }
        if (dest.iteratePhis().hasNext()) {
            blockFunction = this.composeWithPhiAssignments(src, dest, blockFunction, node);
        }
        return blockFunction;
    }

    private IUnaryFlowFunction composeWithPhiAssignments(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest, IUnaryFlowFunction blockFunction, CGNode node) {
        ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg = this.getCFG(src);
        int j = Util.whichPred(cfg, (IBasicBlock)((IExplodedBasicBlock)src.getDelegate()), (IBasicBlock)((IExplodedBasicBlock)dest.getDelegate()));
        Iterator phiIterator = dest.iteratePhis();
        while (phiIterator.hasNext()) {
            SSAPhiInstruction phi = (SSAPhiInstruction)phiIterator.next();
            if (phi == null) continue;
            if (j >= phi.getNumberOfUses()) {
                Assertions.UNREACHABLE((String)("invalid whichPred " + j + " for " + dest));
            }
            if (phi.getUse(j) <= 0) continue;
            LocalPointerKey def = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, phi.getDef());
            LocalPointerKey use = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, phi.getUse(j));
            IUnaryFlowFunction phiFunction = use.isParameter() ? this.makeLocalAssignFlowFunction((AbstractPointerKey)def, (AbstractPointerKey)use) : this.makeLocalRenameFlowFunction((AbstractPointerKey)def, (AbstractPointerKey)use);
            blockFunction = AggregateFlowFunction.compose(blockFunction, phiFunction);
        }
        return blockFunction;
    }

    @Override
    protected ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> getCFG(BasicBlockInContext<IExplodedBasicBlock> src) {
        ICFGSupergraph s = this.getSupergraph();
        ControlFlowGraph sg = s.getCFG(src);
        return sg;
    }

    protected IUnaryFlowFunction composeBlockFlowFunction(CGNode node, BasicBlockInContext<IExplodedBasicBlock> srcBlock) {
        IdentityFlowFunction prevFunction = null;
        for (SSAInstruction inst : srcBlock) {
            if (inst == null) continue;
            class StatementVisitor
            extends SSAInstruction.Visitor {
                IUnaryFlowFunction currFunction = null;
                private final /* synthetic */ CGNode val$node;
                private final /* synthetic */ BasicBlockInContext val$srcBlock;

                StatementVisitor(CGNode cGNode, BasicBlockInContext basicBlockInContext) {
                    this.val$node = cGNode;
                    this.val$srcBlock = basicBlockInContext;
                }

                public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makeALoadFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitArrayStore(SSAArrayStoreInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makeAStoreFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitGet(SSAGetInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makeGetFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitPut(SSAPutInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makePutFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitNew(SSANewInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makeAllocFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitThrow(SSAThrowInstruction instruction) {
                }

                public void visitCheckCast(SSACheckCastInstruction instruction) {
                    this.currFunction = AccessPathFunctionProvider.this.makeCheckCastFlowFunction(this.val$node, (ISSABasicBlock)this.val$srcBlock, instruction);
                }

                public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
                }
            }
            StatementVisitor v = new StatementVisitor(node, srcBlock);
            inst.visit((SSAInstruction.IVisitor)v);
            if (v.currFunction == null) continue;
            prevFunction = prevFunction == null ? v.currFunction : AggregateFlowFunction.compose((IUnaryFlowFunction)prevFunction, v.currFunction);
        }
        prevFunction = prevFunction != null ? prevFunction : IdentityFlowFunction.identity();
        return prevFunction;
    }

    protected abstract IUnaryFlowFunction makeDeadAccessPathKiller(CGNode var1, ISSABasicBlock var2);

    protected abstract IUnaryFlowFunction makeReturnFlowFunction(Set<PathElement> var1, CGNode var2, CGNode var3, SSAInvokeInstruction var4);

    protected abstract IUnaryFlowFunction makePiFlowFunction(CGNode var1, ISSABasicBlock var2, SSAPiInstruction var3);

    protected abstract IUnaryFlowFunction makeLocalAssignFlowFunction(AbstractPointerKey var1, AbstractPointerKey var2);

    protected abstract IUnaryFlowFunction makeCheckCastFlowFunction(LocalPointerKey var1, LocalPointerKey var2, TypeReference var3);

    protected abstract IUnaryFlowFunction makeAllocFlowFunction(InstanceKey var1, IDFAState var2, LocalPointerKey var3);

    protected boolean allocatesTrackedInstance(CGNode node, SSANewInstruction newInst) {
        InstanceKey ik = this.getPointerAnalysis().getHeapModel().getInstanceKeyForAllocation(node, newInst.getNewSite());
        return this.getTrackedInstanceSet().contains((Object)ik);
    }

    protected IUnaryFlowFunction makeAllocFlowFunction(CGNode node, ISSABasicBlock block, SSANewInstruction newInst) {
        if (this.allocatesTrackedInstance(node, newInst)) {
            InstanceKey ik = this.getPointerAnalysis().getHeapModel().getInstanceKeyForAllocation(node, newInst.getNewSite());
            LocalPointerKey pk = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, newInst.getDef());
            return this.makeAllocFlowFunction(ik, this.getDFA().initial(), pk);
        }
        return IdentityFlowFunction.identity();
    }

    protected AccessPathSetTransformers getApsTransformer() {
        return this.apsTransformer;
    }

    protected IUnaryFlowFunction makePutFlowFunction(CGNode node, ISSABasicBlock block, SSAPutInstruction putInst) {
        int rhs = putInst.getVal();
        LocalPointerKey y = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, rhs);
        if (putInst.isStatic()) {
            FieldReference fieldRef = putInst.getDeclaredField();
            if (fieldRef.getFieldType().isReferenceType()) {
                IField fld = this.getCallGraph().getClassHierarchy().resolveField(fieldRef);
                if (fld != null) {
                    StaticFieldKey X_f = (StaticFieldKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForStaticField(fld);
                    return this.makePutStaticFlowFunction(X_f, y);
                }
                return IdentityFlowFunction.identity();
            }
        } else {
            int ref = putInst.getRef();
            FieldReference fieldReference = putInst.getDeclaredField();
            IField fld = this.getCallGraph().getClassHierarchy().resolveField(fieldReference);
            if (fld == null) {
                return IdentityFlowFunction.identity();
            }
            LocalPointerKey x = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, ref);
            return this.makePutFieldFlowFunction(x, y, fld);
        }
        return IdentityFlowFunction.identity();
    }

    protected abstract IUnaryFlowFunction makePutStaticFlowFunction(StaticFieldKey var1, LocalPointerKey var2);

    protected abstract IUnaryFlowFunction makePutFieldFlowFunction(LocalPointerKey var1, LocalPointerKey var2, IField var3);

    protected abstract IUnaryFlowFunction makeGetStaticFlowFunction(LocalPointerKey var1, StaticFieldKey var2);

    protected abstract IUnaryFlowFunction makeGetFieldFlowFunction(LocalPointerKey var1, LocalPointerKey var2, IField var3);

    protected abstract IUnaryFlowFunction makeALoadFlowFunction(LocalPointerKey var1, LocalPointerKey var2);

    protected abstract IUnaryFlowFunction makeAStoreFlowFunction(LocalPointerKey var1, LocalPointerKey var2);

    public AccessPathSet updateMust(AccessPathSet s, AccessPath x_f, PathElement y) {
        return this.getApsTransformer().updateMust(s, x_f, y, this.accessPathKLimit);
    }

    protected IUnaryFlowFunction makeCheckCastFlowFunction(CGNode node, ISSABasicBlock block, SSACheckCastInstruction inst) {
        LocalPointerKey x = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, inst.getDef());
        LocalPointerKey y = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, inst.getVal());
        TypeReference t = inst.getDeclaredResultType();
        return this.makeCheckCastFlowFunction(x, y, t);
    }

    protected IUnaryFlowFunction makeALoadFlowFunction(CGNode node, ISSABasicBlock block, SSAArrayLoadInstruction aload) {
        LocalPointerKey x = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, aload.getDef());
        LocalPointerKey y = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, aload.getArrayRef());
        return this.makeALoadFlowFunction(x, y);
    }

    protected IUnaryFlowFunction makeAStoreFlowFunction(CGNode node, ISSABasicBlock block, SSAArrayStoreInstruction astore) {
        LocalPointerKey x = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, astore.getArrayRef());
        LocalPointerKey y = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, astore.getValue());
        return this.makeAStoreFlowFunction(x, y);
    }

    protected IUnaryFlowFunction makeGetFlowFunction(CGNode node, ISSABasicBlock block, SSAGetInstruction getInst) {
        LocalPointerKey x = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, getInst.getDef());
        if (getInst.isStatic()) {
            FieldReference fieldRef = getInst.getDeclaredField();
            if (fieldRef.getFieldType().isReferenceType()) {
                IField fld = this.getCallGraph().getClassHierarchy().resolveField(fieldRef);
                if (fld != null) {
                    StaticFieldKey Y_f = (StaticFieldKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForStaticField(fld);
                    return this.makeGetStaticFlowFunction(x, Y_f);
                }
                return IdentityFlowFunction.identity();
            }
            return IdentityFlowFunction.identity();
        }
        IField fld = this.getCallGraph().getClassHierarchy().resolveField(getInst.getDeclaredField());
        LocalPointerKey y = (LocalPointerKey)this.getPointerAnalysis().getHeapModel().getPointerKeyForLocal(node, getInst.getRef());
        if (fld == null) {
            return IdentityFlowFunction.identity();
        }
        return this.makeGetFieldFlowFunction(x, y, fld);
    }

    protected IUnaryFlowFunction makeCallFlowFunction(IEvent event, BasicBlockInContext<IExplodedBasicBlock> src, SSAInvokeInstruction srcInvokeInstruction, CGNode caller, CGNode callee) {
        IUnaryFlowFunction callFlow = this.makeCallFlowFunction(caller, callee, srcInvokeInstruction);
        if (event == null) {
            return callFlow;
        }
        return AggregateFlowFunction.compose(callFlow, this.makeEventFlowFunction(event, src, srcInvokeInstruction, caller, callee));
    }

    protected abstract IUnaryFlowFunction makeEventFlowFunction(IEvent var1, BasicBlockInContext<IExplodedBasicBlock> var2, SSAInvokeInstruction var3, CGNode var4, CGNode var5);

    protected abstract IUnaryFlowFunction makeCallFlowFunction(CGNode var1, CGNode var2, SSAInvokeInstruction var3);

    public AccessPathSet updateMay(AccessPathSet s, AccessPath x_f, PathElement y) {
        return this.getApsTransformer().updateMay(s, x_f, y, this.accessPathKLimit);
    }

    protected AccessPathSet killOutOfScopeLocals(AccessPathSet s, CGNode n) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            PathElement head = ap.getHead();
            if (head instanceof LocalPathElement) {
                LocalPathElement lp = (LocalPathElement)head;
                AbstractPointerKey pk = (AbstractPointerKey)lp.getPointerKey();
                if (pk instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pk;
                    if (!this.reach.getReachableSet((Object)lpk.getNode()).contains((Object)n)) continue;
                    result.add(ap);
                    continue;
                }
                result.add(ap);
                continue;
            }
            result.add(ap);
        }
        return result;
    }

    protected AccessPathSet killLocals(AccessPathSet s, CGNode n) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            PathElement head = ap.getHead();
            if (head instanceof LocalPathElement) {
                LocalPathElement lp = (LocalPathElement)head;
                AbstractPointerKey pk = (AbstractPointerKey)lp.getPointerKey();
                if (pk instanceof LocalPointerKey) {
                    LocalPointerKey lpk = (LocalPointerKey)pk;
                    if (lpk.getNode().equals(n)) continue;
                    result.add(ap);
                    continue;
                }
                result.add(ap);
                continue;
            }
            result.add(ap);
        }
        return result;
    }

    protected abstract IUnaryFlowFunction makeLocalRenameFlowFunction(AbstractPointerKey var1, AbstractPointerKey var2);

    protected TypeStateOptions getOptions() {
        return this.options;
    }

    protected HeapGraph getHeapGraph() {
        return this.heapGraph;
    }

    protected GraphReachability<CGNode, CGNode> getReach() {
        return this.reach;
    }

    public AccessPathDictionary getAPDictionary() {
        return this.APDictionary;
    }
}

