/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.accesspath;

import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathDictionary;
import com.ibm.safe.accesspath.AccessPathSet;
import com.ibm.safe.accesspath.AliasOracle;
import com.ibm.safe.accesspath.ArrayContentsPathElement;
import com.ibm.safe.accesspath.InstanceFieldPathElement;
import com.ibm.safe.accesspath.LocalPathElement;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.accesspath.PointerPathElement;
import com.ibm.safe.accesspath.StaticFieldPathElement;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AbstractPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSite;
import com.ibm.wala.ipa.callgraph.propagation.ArrayContentsKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphReachability;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FIAliasOracle
implements AliasOracle {
    private static final boolean DEBUG = false;
    private static final boolean PRUNE_MUTUALLY_DEAD_LOCALS = true;
    private final PointerAnalysis pointerAnalysis;
    private final GraphReachability<CGNode, CGNode> reach;
    private final AccessPathDictionary APDictionary;

    public FIAliasOracle(PointerAnalysis pointerAnalysis, AccessPathDictionary APDictionary, GraphReachability<CGNode, CGNode> reach) {
        this.pointerAnalysis = pointerAnalysis;
        this.reach = reach;
        this.APDictionary = APDictionary;
    }

    @Override
    public AccessPathSet getGlobalAliases(PointerPathElement x) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        PointerKey xPtr = x.getPointerKey();
        OrdinalSet xPointsTo = this.pointerAnalysis.getPointsToSet(xPtr);
        for (InstanceKey ik : xPointsTo) {
            result.addAll(this.getAcyclicAccessPaths(ik));
        }
        if (x instanceof LocalPathElement) {
            LocalPointerKey lpk = (LocalPointerKey)x.getPointerKey();
            result = this.pruneForLiveLocals(result, lpk.getNode());
        }
        return result;
    }

    private AccessPathSet pruneForLiveLocals(AccessPathSet s, CGNode node) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            if (ap.length() <= 0) continue;
            PathElement pe = ap.getHead();
            if (pe instanceof LocalPathElement) {
                LocalPathElement lpe = (LocalPathElement)pe;
                AbstractLocalPointerKey lpk = (AbstractLocalPointerKey)lpe.getPointerKey();
                CGNode n = lpk.getNode();
                OrdinalSet reachable = this.reach.getReachableSet((Object)n);
                if (!reachable.contains((Object)node)) continue;
                result.add(ap);
                continue;
            }
            result.add(ap);
        }
        return result;
    }

    @Deprecated
    public AccessPathSet getAcyclicAccessPaths(InstanceKey instance) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        assert (instance != null);
        HeapGraph heapGraph = this.pointerAnalysis.getHeapGraph();
        HashSet visited = HashSetFactory.make();
        Set<Object> front = Collections.emptySet();
        HashSet nextFront = Collections.singleton(instance);
        AccessPathSet currentPaths = null;
        AccessPathSet nextPaths = new AccessPathSet(this.APDictionary);
        AccessPathSet anchoredPaths = new AccessPathSet(this.APDictionary);
        while (!nextFront.isEmpty()) {
            visited.addAll(front);
            front = nextFront;
            currentPaths = nextPaths;
            nextFront = HashSetFactory.make();
            nextPaths = new AccessPathSet(this.APDictionary);
            for (Object node : front) {
                Iterator predIt = heapGraph.getPredNodes(node);
                while (predIt.hasNext()) {
                    Object predObj = predIt.next();
                    if (visited.contains(predObj)) continue;
                    PathElement predElement = null;
                    if (predObj instanceof InstanceFieldKey) {
                        IField predField = ((InstanceFieldKey)predObj).getField();
                        predElement = new InstanceFieldPathElement(predField);
                    } else if (predObj instanceof AbstractLocalPointerKey) {
                        AbstractLocalPointerKey predPointer = (AbstractLocalPointerKey)predObj;
                        predElement = new LocalPathElement((AbstractPointerKey)predPointer);
                    } else if (predObj instanceof AllocationSite) {
                        AllocationSite predAllocSite = (AllocationSite)predObj;
                        predElement = null;
                    } else if (predObj instanceof StaticFieldKey) {
                        predElement = new StaticFieldPathElement((StaticFieldKey)predObj);
                    } else if (predObj instanceof ArrayContentsKey) {
                        predElement = ArrayContentsPathElement.instance();
                    } else if (predObj instanceof PropagationCallGraphBuilder.TypedPointerKey) {
                        PropagationCallGraphBuilder.TypedPointerKey tpk = (PropagationCallGraphBuilder.TypedPointerKey)predObj;
                        predObj = tpk.getBase();
                        assert (predObj instanceof AbstractLocalPointerKey);
                        AbstractLocalPointerKey lpk = (AbstractLocalPointerKey)predObj;
                        predElement = new LocalPathElement((AbstractPointerKey)lpk);
                    } else if (!(predObj instanceof InstanceKey)) {
                        Assertions.UNREACHABLE((String)predObj.getClass().toString());
                    }
                    Iterator<AccessPath> pathIterator = currentPaths.iterator();
                    while (pathIterator.hasNext()) {
                        AccessPath item;
                        AccessPath curr = item = pathIterator.next();
                        if (predElement == null) {
                            nextPaths.add(curr);
                            continue;
                        }
                        if (!this.isValidSuffix(node, curr)) continue;
                        AccessPath ap = this.APDictionary.concat(predElement, curr);
                        (predElement.isAnchor() ? anchoredPaths : nextPaths).add(ap);
                    }
                    if (currentPaths.isEmpty() && predElement != null) {
                        AccessPath ap = this.APDictionary.findOrCreate(predElement);
                        (predElement.isAnchor() ? anchoredPaths : nextPaths).add(ap);
                    }
                    if (predElement != null && predElement.isAnchor()) continue;
                    nextFront.add(predObj);
                }
            }
        }
        Iterator<AccessPath> it = currentPaths.iterator();
        while (it.hasNext()) {
            AccessPath accessPath = it.next();
        }
        result.addAll(anchoredPaths);
        result.addAll(currentPaths);
        assert (!result.isEmpty()) : "instance must be potentially reachable " + instance;
        return result;
    }

    private boolean isValidSuffix(Object node, AccessPath path) {
        PathElement pathHead = path.getHead();
        if (pathHead instanceof InstanceFieldPathElement) {
            IField pathHeadField = ((InstanceFieldPathElement)pathHead).getField();
            Iterator succIter = this.pointerAnalysis.getHeapGraph().getSuccNodes(node);
            while (succIter.hasNext()) {
                InstanceFieldKey succInstanceFieldKey;
                Object succObj = succIter.next();
                if (!(succObj instanceof InstanceFieldKey) || !(succInstanceFieldKey = (InstanceFieldKey)succObj).getField().equals(pathHeadField)) continue;
                return true;
            }
            return false;
        }
        if (pathHead instanceof ArrayContentsPathElement) {
            Iterator succIter = this.pointerAnalysis.getHeapGraph().getSuccNodes(node);
            while (succIter.hasNext()) {
                Object succObj = succIter.next();
                if (!(succObj instanceof ArrayContentsKey)) continue;
                return true;
            }
            return false;
        }
        Assertions.UNREACHABLE((String)("Expected path to start with an instance field or array contents: " + path));
        return false;
    }
}

