/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.accesspath;

import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathDictionary;
import com.ibm.safe.accesspath.AccessPathSet;
import com.ibm.safe.accesspath.AliasOracle;
import com.ibm.safe.accesspath.ArrayContentsPathElement;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.accesspath.PointerPathElement;
import com.ibm.safe.accesspath.StaticFieldPathElement;
import com.ibm.safe.typestate.quad.Auxiliary;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.GraphReachability;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AccessPathSetTransformers {
    protected static final boolean DEBUG = false;
    protected static final int LOGICAL_ZERO = 0;
    protected static final int LOGICAL_ONE = 1;
    protected static final int LOGICAL_ONEHALF = 2;
    private final PointerAnalysis pointerAnalysis;
    private final AliasOracle aliasOracle;
    private final AccessPathDictionary APDictionary = new AccessPathDictionary();

    public AccessPathSetTransformers(PointerAnalysis pointerAnalysis, GraphReachability<CGNode, CGNode> reach) {
        this.pointerAnalysis = pointerAnalysis;
        this.aliasOracle = this.makeAliasOracle(pointerAnalysis, this.APDictionary, reach);
    }

    protected abstract AliasOracle makeAliasOracle(PointerAnalysis var1, AccessPathDictionary var2, GraphReachability<CGNode, CGNode> var3);

    public AccessPathSet kill(AccessPathSet s, PathElement x) {
        return s.pathsWithOtherRoot(x);
    }

    public AccessPathSet kill(AccessPathSet s, Set<PathElement> roots) {
        return s.pathsWithOtherRoots(roots);
    }

    public AccessPathSet assign(AccessPathSet s, PathElement x, AccessPath y) {
        AccessPathSet result = new AccessPathSet(s);
        result.addAll(this.gen(s, x, y));
        return result;
    }

    public AccessPathSet gen(AccessPathSet s, PathElement x, AccessPath y) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        AccessPathSet yPaths = s.pathsWithPrefix(y);
        Iterator<AccessPath> it = yPaths.iterator();
        while (it.hasNext()) {
            AccessPath currPath = it.next();
            AccessPath newPath = this.APDictionary.findOrCreate(x);
            if (currPath.length() > y.length()) {
                List<PathElement> currSuffix = currPath.getSuffix(y.length());
                newPath = this.APDictionary.concat(newPath, currSuffix);
            }
            result.add(newPath);
        }
        return result;
    }

    public AccessPathSet assign(AccessPathSet s, PathElement x, Set<AccessPath> ySet) {
        AccessPathSet result = new AccessPathSet(s);
        for (AccessPath y : ySet) {
            result.addAll(this.gen(s, x, y));
        }
        return result;
    }

    public AccessPathSet rename(AccessPathSet s, PathElement x, Set<? extends PathElement> ySet) {
        if (s.isEmpty()) {
            return s;
        }
        AccessPathSet result = new AccessPathSet(s.getAPDictionary());
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            if (ySet.contains(ap.getHead())) {
                if (ap.length() > 1) {
                    result.add(this.APDictionary.concat(x, ap.getSuffix(1)));
                    continue;
                }
                result.add(this.APDictionary.findOrCreate(x));
                continue;
            }
            result.add(ap);
        }
        return result;
    }

    public AccessPathSet assign(AccessPathSet s1, AccessPathSet s2, PathElement x, Set<AccessPath> ySet) {
        AccessPathSet result = new AccessPathSet(s1);
        for (AccessPath y : ySet) {
            PathElement yHead = y.getHead();
            AccessPathSet yPaths1 = s1.pathsFrom(yHead);
            AccessPathSet yPaths2 = s2.pathsFrom(yHead);
            AccessPathSet yPaths = new AccessPathSet(this.APDictionary);
            yPaths.addAll(yPaths1);
            yPaths.addAll(yPaths2);
            Iterator<AccessPath> it = yPaths.iterator();
            while (it.hasNext()) {
                AccessPath currPath = it.next();
                AccessPath newPath = this.APDictionary.findOrCreate(x);
                if (currPath.length() <= y.length()) continue;
                List<PathElement> currSuffix = currPath.getSuffix(y.length());
                newPath = this.APDictionary.concat(newPath, currSuffix);
            }
        }
        return result;
    }

    protected AccessPathSet getGlobalAliases(PointerPathElement x) {
        return this.aliasOracle.getGlobalAliases(x);
    }

    public AccessPathSet getAccessPaths(InstanceKey instance, int maximalDepth) {
        assert (instance != null && maximalDepth > 0);
        throw new UnsupportedOperationException("NYI");
    }

    protected PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    protected abstract AccessPathSet getMustAccessPaths(Auxiliary var1);

    public AccessPathSet updateMust(AccessPathSet s, AccessPath x_f, PathElement y, int klimit) {
        AccessPathSet result = new AccessPathSet(s);
        AccessPathSet killSet = this.mustKill(result, x_f, klimit);
        result.removeAll(killSet);
        AccessPathSet genSet = this.mustGen(s, x_f, y, klimit);
        result.addAll(genSet);
        return result;
    }

    public AccessPathSet mustKill(AccessPathSet s, AccessPath x_f, int klimit) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        PointerPathElement x = (PointerPathElement)x_f.getHead();
        if (x instanceof StaticFieldPathElement) {
            assert (x_f.length() == 1);
            return s.pathsWithPrefix(x_f);
        }
        assert (x_f.length() == 2);
        PathElement f = x_f.getElementAt(1);
        Iterator<AccessPath> it = s.iterator();
        block0: while (it.hasNext()) {
            AccessPath currPath = it.next();
            int i = 1;
            while (i < currPath.length()) {
                if (currPath.getElementAt(i).equals(f)) {
                    int mayAliasPrefix;
                    int n = mayAliasPrefix = i == 1 ? this.aliased((PointerPathElement)currPath.getHead(), x) : this.aliased(this.APDictionary.findOrCreate(currPath.getPrefix(i)), x);
                    if (mayAliasPrefix != 0) {
                        result.add(currPath);
                        continue block0;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected AccessPathSet mustGen(AccessPathSet s, AccessPath x_f, PathElement y, int klimit) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        PathElement x = x_f.getHead();
        if (x instanceof StaticFieldPathElement) {
            assert (x_f.length() == 1);
            return this.gen(s, x, this.APDictionary.findOrCreate(y));
        }
        assert (x_f.length() == 2);
        PathElement f = x_f.getElementAt(1);
        AccessPathSet pathsFromY = s.pathsFrom(y);
        Set<AccessPath> xMustAliases = pathsFromY.isEmpty() ? null : this.getMustAliases(x);
        Iterator<AccessPath> it = pathsFromY.iterator();
        while (it.hasNext()) {
            AccessPath currPath = it.next();
            PathElement anchor = currPath.getHead();
            Assertions.productionAssertion((boolean)anchor.equals(y));
            for (AccessPath currMustAlias : xMustAliases) {
                AccessPath newPath = this.APDictionary.concat(currMustAlias, f);
                if (currPath.length() > 1) {
                    newPath = this.APDictionary.concat(newPath, currPath.getSuffix(1));
                }
                result.add(newPath);
            }
        }
        return result;
    }

    protected Set<AccessPath> getMustAliases(PathElement x) {
        HashSet result = HashSetFactory.make((int)1);
        AccessPath xPath = this.APDictionary.findOrCreate(x);
        result.add(xPath);
        return result;
    }

    public abstract int aliased(PointerPathElement var1, PointerPathElement var2);

    public abstract int aliased(AccessPath var1, PointerPathElement var2);

    public AccessPathSet updateMay(AccessPathSet s, AccessPath x_f, PathElement y, int klimit) {
        AccessPathSet result = new AccessPathSet(s);
        AccessPathSet mayKillSet = this.mayKill(s, x_f, klimit);
        result.removeAll(mayKillSet);
        AccessPathSet mayGenSet = this.mayGen(s, x_f, y, klimit);
        result.addAll(mayGenSet);
        return result;
    }

    AccessPathSet mayKill(AccessPathSet s, AccessPath x_f, int klimit) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        PointerPathElement x = (PointerPathElement)x_f.getHead();
        if (x instanceof StaticFieldPathElement) {
            assert (x_f.length() == 1);
            return s.pathsWithPrefix(x_f);
        }
        assert (x_f.length() == 2);
        PathElement f = x_f.getElementAt(1);
        Set<AccessPath> xMustAliases = null;
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath currPath = it.next();
            if (currPath.length() < 2) continue;
            if (klimit <= 2) {
                PointerPathElement anchor;
                if (!currPath.getElementAt(1).equals(f) || this.aliased(anchor = (PointerPathElement)currPath.getHead(), x) != 1) continue;
                result.add(currPath);
                continue;
            }
            int i = 1;
            while (i < currPath.length()) {
                if (currPath.getElementAt(i).equals(f)) {
                    AccessPath currPathPrefix = this.APDictionary.findOrCreate(currPath.getPrefix(i));
                    if (xMustAliases == null) {
                        xMustAliases = this.getMustAliases(x);
                    }
                    if (xMustAliases.contains(currPathPrefix)) {
                        result.add(currPath);
                    }
                }
                ++i;
            }
        }
        return result;
    }

    AccessPathSet mayGen(AccessPathSet s, AccessPath x_f, PathElement y, int klimit) {
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        PointerPathElement x = (PointerPathElement)x_f.getHead();
        if (x instanceof StaticFieldPathElement) {
            assert (x_f.length() == 1);
            return this.gen(s, x, this.APDictionary.findOrCreate(y));
        }
        assert (x_f.length() == 2);
        PathElement f = x_f.getElementAt(1);
        AccessPathSet pathsFromY = s.pathsFrom(y);
        AccessPathSet xMayAliases = pathsFromY.isEmpty() ? null : this.getMayAliases(x);
        Iterator<AccessPath> it = pathsFromY.iterator();
        while (it.hasNext()) {
            AccessPath currPath = it.next();
            PathElement anchor = currPath.getHead();
            Assertions.productionAssertion((boolean)anchor.equals(y));
            Iterator<AccessPath> mayIt = xMayAliases.iterator();
            while (mayIt.hasNext()) {
                AccessPath currMayAlias = mayIt.next();
                AccessPath newPath = this.APDictionary.concat(currMayAlias, f);
                if (currPath.length() > 1) {
                    newPath = this.APDictionary.concat(newPath, currPath.getSuffix(1));
                }
                result.add(newPath);
            }
        }
        return result;
    }

    public AccessPathSet kLimitPollution(AccessPathSet s, int k) {
        AccessPathSet result = new AccessPathSet(this.getAPDictionary());
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            if (ap.length() > k) continue;
            result.add(ap);
        }
        return result;
    }

    public AccessPathSet kLimit(AccessPathSet s, int accessPathKLimit) {
        if (accessPathKLimit > 0) {
            AccessPathSet result = new AccessPathSet(this.getAPDictionary());
            Iterator<AccessPath> it = s.iterator();
            while (it.hasNext()) {
                AccessPath ap = it.next();
                if (ap.length() > accessPathKLimit) continue;
                result.add(ap);
            }
            return result;
        }
        return s;
    }

    public static boolean containsArrayPath(AccessPathSet s) {
        Iterator<AccessPath> it = s.iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            int i = 1;
            while (i < ap.length()) {
                if (ap.getElementAt(i) instanceof ArrayContentsPathElement) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeArrayPaths(AccessPathSet s) {
        AccessPathSet toRemove = new AccessPathSet(s.getAPDictionary());
        Iterator<AccessPath> it = s.iterator();
        block0: while (it.hasNext()) {
            AccessPath ap = it.next();
            int i = 1;
            while (i < ap.length()) {
                if (ap.getElementAt(i) instanceof ArrayContentsPathElement) {
                    toRemove.add(ap);
                    continue block0;
                }
                ++i;
            }
        }
        s.removeAll(toRemove);
    }

    protected abstract AccessPathSet getMayAliases(PointerPathElement var1);

    public AccessPathDictionary getAPDictionary() {
        return this.APDictionary;
    }
}

