/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.accesspath;

import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.AccessPathDictionary;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.safe.typestate.quad.Auxiliary;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class AccessPathSet
implements Auxiliary {
    private static int maxSetWidth = -1;
    private BimodalMutableIntSet contents = new BimodalMutableIntSet();
    private final AccessPathDictionary APDictionary;

    public static int getMaxSetWidth() {
        return maxSetWidth;
    }

    public static void setMaxSetWidth(int maxWidth) {
        maxSetWidth = maxWidth;
    }

    public AccessPathSet(AccessPathDictionary APDictionary) {
        this.APDictionary = APDictionary;
    }

    public AccessPathSet(AccessPathSet baseSet) {
        this.APDictionary = baseSet.APDictionary;
        this.addAll(baseSet);
    }

    public AccessPathSet(AccessPathDictionary APDictionary, AccessPath ap) {
        this.APDictionary = APDictionary;
        this.add(ap);
    }

    private AccessPathSet(AccessPathDictionary dictionary, BimodalMutableIntSet set) {
        this.APDictionary = dictionary;
        this.contents = set;
    }

    public AccessPathSet pathsFrom(PathElement source) {
        BimodalMutableIntSet c = new BimodalMutableIntSet();
        c.addAllInIntersection((IntSet)this.contents, this.APDictionary.getPathsFrom(source));
        return new AccessPathSet(this.APDictionary, c);
    }

    public AccessPathSet pathsWithPrefix(AccessPath prefixPath) {
        assert (prefixPath != null) : "cannot get paths from null prefix";
        AccessPathSet result = new AccessPathSet(this.APDictionary);
        Iterator<AccessPath> it = this.pathsFrom(prefixPath.getHead()).iterator();
        while (it.hasNext()) {
            AccessPath ap = it.next();
            if (!ap.hasPrefix(prefixPath)) continue;
            result.add(ap);
        }
        return result;
    }

    public AccessPathSet pathsWithOtherRoot(PathElement root) {
        BimodalMutableIntSet c = new BimodalMutableIntSet(this.contents);
        c.removeAll(this.APDictionary.getPathsFrom(root));
        return new AccessPathSet(this.APDictionary, c);
    }

    public AccessPathSet pathsWithOtherRoots(Set<PathElement> roots) {
        assert (roots != null) : "cannot get paths from null roots";
        BimodalMutableIntSet c = new BimodalMutableIntSet(this.contents);
        for (PathElement p : roots) {
            c.removeAll(this.APDictionary.getPathsFrom(p));
        }
        return new AccessPathSet(this.APDictionary, c);
    }

    public int size() {
        return this.contents.size();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean contains(AccessPath ap) {
        assert (ap != null) : "null cannot be a member of an AccessPathSet";
        return this.contents.contains(ap.id());
    }

    public Iterator<AccessPath> iterator() {
        return new Iterator<AccessPath>(){
            IntIterator it;
            {
                this.it = AccessPathSet.this.contents.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public AccessPath next() {
                return AccessPathSet.this.APDictionary.getAccessPath(this.it.next());
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public boolean add(AccessPath ap) {
        assert (ap != null) : "AccessPathSet does not allow adding 'null' element";
        if (maxSetWidth >= 0) {
            return this.contents.size() < maxSetWidth ? this.contents.add(ap.id()) : false;
        }
        return this.contents.add(ap.id());
    }

    public boolean remove(AccessPath ap) {
        assert (ap != null) : "AccessPathSet does not allow removing 'null' element";
        return this.contents.remove(ap.id());
    }

    public boolean containsAll(AccessPathSet c) {
        assert (c != null) : "cannot check containment with null collection";
        return this.size() >= c.size() && this.contents.containsAll(c.contents);
    }

    public boolean addAll(AccessPathSet c) {
        assert (c != null) : "cannot add elements of a null collection";
        if (maxSetWidth >= 0) {
            int oldSize = this.contents.size();
            Iterator<AccessPath> iter = c.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
            return this.contents.size() > oldSize;
        }
        return this.contents.addAll((IntSet)c.contents);
    }

    public boolean retainAll(Collection<AccessPath> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(AccessPathSet c) {
        assert (c != null) : "cannot remove elements of a null collection";
        return this.contents.removeAll((IntSet)c.contents);
    }

    public void clear() {
        this.contents = new BimodalMutableIntSet();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AccessPathSet)) {
            return false;
        }
        return this.contents.sameValue((IntSet)((AccessPathSet)o).contents);
    }

    @Override
    public int hashCode() {
        return new BitVectorIntSet((IntSet)this.contents).getBitVector().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator<AccessPath> it = this.iterator();
        while (it.hasNext()) {
            AccessPath item = it.next();
            result.append(item);
            result.append("\n");
        }
        return result.toString();
    }

    public AccessPathDictionary getAPDictionary() {
        return this.APDictionary;
    }
}

