/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.accesspath;

import com.ibm.safe.accesspath.AccessPath;
import com.ibm.safe.accesspath.PathElement;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccessPathDictionary {
    private final boolean PARANOID = false;
    private final Map<APKey, AccessPath> map = HashMapFactory.make();
    private SimpleVector<AccessPath> vector = new SimpleVector();
    private final Map<PathElement, BitVectorIntSet> startsWith = HashMapFactory.make();

    public void clear() {
        this.map.clear();
        this.vector = new SimpleVector();
        this.startsWith.clear();
    }

    public AccessPath findOrCreate(PathElement initialElement) {
        APKey k = new APKey(initialElement);
        AccessPath result = this.map.get(k);
        if (result == null) {
            int id = this.vector.getMaxIndex() + 1;
            result = new AccessPath(k, id);
            this.map.put(k, result);
            this.vector.set(id, (Object)result);
            this.findOrCreateStartsWith(initialElement).add(id);
        }
        return result;
    }

    public AccessPath findOrCreate(List<PathElement> elements) {
        APKey k = new APKey(elements);
        AccessPath result = this.map.get(k);
        if (result == null) {
            int id = this.vector.getMaxIndex() + 1;
            result = new AccessPath(k, id);
            this.map.put(k, result);
            this.vector.set(id, (Object)result);
            this.findOrCreateStartsWith(result.getHead()).add(id);
        }
        return result;
    }

    BitVectorIntSet findOrCreateStartsWith(PathElement p) {
        BitVectorIntSet result = this.startsWith.get(p);
        if (result == null) {
            result = new BitVectorIntSet();
            this.startsWith.put(p, result);
        }
        return result;
    }

    public AccessPath concat(AccessPath ap, List<PathElement> suffix) {
        ArrayList<PathElement> l = new ArrayList<PathElement>(ap.key.pathElements);
        l.addAll(suffix);
        return this.findOrCreate(l);
    }

    public AccessPath concat(AccessPath ap, PathElement f) {
        ArrayList<PathElement> l = new ArrayList<PathElement>(ap.key.pathElements);
        l.add(f);
        return this.findOrCreate(l);
    }

    public AccessPath concat(PathElement p, AccessPath ap) {
        ArrayList<PathElement> l = new ArrayList<PathElement>();
        l.add(p);
        l.addAll(ap.key.pathElements);
        return this.findOrCreate(l);
    }

    public AccessPath concat(PathElement p1, PathElement p2) {
        ArrayList<PathElement> l = new ArrayList<PathElement>();
        l.add(p1);
        l.add(p2);
        return this.findOrCreate(l);
    }

    public AccessPath concat(PathElement p, List<PathElement> list) {
        ArrayList<PathElement> l = new ArrayList<PathElement>();
        l.add(p);
        l.addAll(list);
        return this.findOrCreate(l);
    }

    public AccessPath concat(AccessPath ap1, AccessPath ap2) {
        ArrayList<PathElement> l = new ArrayList<PathElement>(ap1.key.pathElements);
        l.addAll(ap2.key.pathElements);
        return this.findOrCreate(l);
    }

    public AccessPath getAccessPath(int i) {
        return (AccessPath)this.vector.get(i);
    }

    public IntSet getPathsFrom(PathElement source) {
        return this.findOrCreateStartsWith(source);
    }

    public class APKey {
        private List<PathElement> pathElements;
        private final int hashCode;

        APKey(PathElement initialElement) {
            this.pathElements = new ArrayList<PathElement>();
            this.pathElements.add(initialElement);
            this.hashCode = this.computeHashCode();
        }

        APKey(List<PathElement> elements) {
            assert (elements != null) : "Cannot create accesspath from null list";
            this.pathElements = new ArrayList<PathElement>(elements);
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            return this.pathElements.hashCode();
        }

        boolean isEmpty() {
            return this.pathElements.isEmpty();
        }

        public List<PathElement> getPathElements() {
            return this.pathElements;
        }

        public List<PathElement> getPrefix(int i) {
            assert (i <= this.pathElements.size()) : "attempt to get prefix beyond path length";
            return new ArrayList<PathElement>(this.pathElements.subList(0, i));
        }

        public List<PathElement> getSuffix(int i) {
            assert (i < this.pathElements.size()) : "attempt to get suffix beyond path length";
            return new ArrayList<PathElement>(this.pathElements.subList(i, this.pathElements.size()));
        }

        public boolean isAnchored() {
            if (this.pathElements.isEmpty()) {
                return false;
            }
            PathElement pe = this.pathElements.get(0);
            return pe.isAnchor();
        }

        public PathElement getHead() {
            return this.pathElements.get(0);
        }

        public int length() {
            return this.pathElements.size();
        }

        public PathElement getElementAt(int i) {
            return this.pathElements.get(i);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (PathElement curr : this.pathElements) {
                result.append(curr.toString());
            }
            return result.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof APKey)) {
                return false;
            }
            APKey otherPath = (APKey)other;
            if (this.pathElements != null) {
                return this.pathElements.equals(otherPath.pathElements);
            }
            return otherPath.pathElements == null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean hasPrefix(AccessPath prefixPath) {
            if (this.length() < prefixPath.length()) {
                return false;
            }
            int i = 0;
            while (i < prefixPath.length()) {
                if (!this.getElementAt(i).equals(prefixPath.getElementAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean hasSuffix(AccessPath suffixPath) {
            if (this.length() < suffixPath.length()) {
                return false;
            }
            int i = 0;
            while (i < suffixPath.length()) {
                if (!this.getElementAt(this.length() - i).equals(suffixPath.getElementAt(this.length() - i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

