/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.traverse.DFSDiscoverTimeIterator;
import java.util.Iterator;
import java.util.Map;

public class CAstFunctions {
    public static CAstNode findIf(CAstNode tree, Predicate<CAstNode> f) {
        if (f.test((Object)tree)) {
            return tree;
        }
        int i = 0;
        while (i < tree.getChildCount()) {
            CAstNode result = CAstFunctions.findIf(tree.getChild(i), f);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Iterator<CAstNode> iterateNodes(CAstNode tree) {
        return new DFSDiscoverTimeIterator<CAstNode>(tree){
            private final Map<Object, Iterator<? extends CAstNode>> pendingChildren = HashMapFactory.make();
            {
                this.init(cAstNode);
            }

            protected Iterator<? extends CAstNode> getPendingChildren(CAstNode n) {
                return this.pendingChildren.get(n);
            }

            protected void setPendingChildren(CAstNode v, Iterator<? extends CAstNode> iterator) {
                this.pendingChildren.put(v, iterator);
            }

            protected Iterator<CAstNode> getConnected(final CAstNode n) {
                return new Iterator<CAstNode>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < n.getChildCount();
                    }

                    @Override
                    public CAstNode next() {
                        return n.getChild(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterator<CAstNode> findAll(CAstNode tree, Predicate<?> f) {
        return new FilterIterator(CAstFunctions.iterateNodes(tree), f);
    }
}

